#!/bin/bash

#############################################################################
#
# SPECvirt Datacenter 2021
#
# Copyright (c) 2021 Standard Performance Evaluation Corporation (SPEC)
# All rights reserved.
#
##############################################################################

# PowerOffVM.sh - Powers off a VM
#
# Note: used before deleting the VM:  
# 	prepSUT.sh, runspecvirt.sh, DeployClientTiles.sh, and DeployClientTiles-custom.sh

if [ "$#" -ne 1 ]; then
   echo "Usage:  ./PowerOffVM.sh <targetVM>"
   exit 1
fi

# Set up environment variables
. /export/home/cp/bin/getVars.sh
SCRIPT_LOG_FILE=/export/home/cp/log/${virtVendor}_scripts.log

targetVM=$1

echo; echo $(date -u) "Powering off $targetVM" |& tee -a $SCRIPT_LOG_FILE
  pwsh ./powerOffVM.ps1 $targetVM >/dev/null
echo; echo $(date -u) "$targetVM powered off" |& tee -a $SCRIPT_LOG_FILE
