#!/bin/bash

#############################################################################
#
# SPECvirt Datacenter 2021
#
# Copyright (c) 2021 Standard Performance Evaluation Corporation (SPEC)
# All rights reserved.
#
##############################################################################

# PowerOnVM.sh - Power on a VM

if [ "$#" -ne 1 ]; then
   echo "Usage:  ./PowerOnVM.sh <targetVM>"
   exit 1
fi

# Set up environment variables
. /export/home/cp/bin/getVars.sh
SCRIPT_LOG_FILE=/export/home/cp/log/${virtVendor}_scripts.log

targetVM=$1

cd /export/home/cp/config/workloads/specvirt/HV_Operations/${virtVendor}

echo $(date -u) "PowerOn script for ${targetVM} started" |& tee -a $SCRIPT_LOG_FILE
    pwsh ./powerOnVM.ps1 "${targetVM}"

getstate=1
pingcount=0

# Ping to check if VM is up

while [ $getstate -ne "0" ]
do
   ping -q -c 1 -t 1 $targetVM &> /dev/null; getstate=$?; pingcount=`expr $pingcount + 1`; sleep 1
   if [ $pingcount -ge "60" ]
      then
      echo $(date -u) "Unable to ping ${targetVM}. PowerOn failed" |& tee -a $SCRIPT_LOG_FILE
      exit 1
   fi

done

echo $(date -u) "${targetVM} running ...${pingcount}. PowerOn succeeded." |& tee -a $SCRIPT_LOG_FILE

