===================================================
VMware® PowerCLI™ SDK for SPECvirt® Datacenter 2021
===================================================

The VMware PowerCLI for SPECvirt Datacenter 2021 is a supplemental SDK for vSphere environments. SPECvirt Datacenter 2021 
contains the pre-installed VMware Perl SDK, and this SDK allows you to use VMware PowerCLI instead.

NOTE: Install this SDK only on the svdc-director VM. Do not change svdc-template.

This document discusses two scenarios:

1. You have not yet deployed the svdc-director VM (initial installation and configuration)
2. You already have deployed and configured the svdc-director VM and wish to switch to the VMware PowerCLI SDK

Scenario 1: At initial svdc-director deployment
===============================================

You need to install the VMware PowerCLI SDK on the newly deployed svdc-director *before* you can the makeme_svdc-director.sh 
script. Follow these steps if you are deploying the svdc-director for the first time. 

1. Perform the steps in the User's Guide Sections 3.2.1 to 3.2.5.5 to:

   a) Download and import the template download the CentOS 7 DVD iso file  

   b) Clone it to the svdc-director VM and configure its infrastructure services and network(s)

   c) Configure the harness testbed and set parameters in Control.config and hosts.txt

2. STOP after completing Section 3.2.5.5. 

3. *Before* you invoke the makeme_svdc-director.sh script in Section 3.2.5.6 (https://www.spec.org/virt_datacenter2021/docs/userguide.html#run-the-makeme-svdc-director-vm-script):

   a) Copy the VMware PowerCLI SDK tarball to $CP_HOME/config/workloads/specvirt/HV_Operations

NOTE: Install this SDK only on the svdc-director VM. Do not change svdc-template.

   b) Set default directory to HV_Operations:

      cd $CP_HOME/config/workloads/specvirt/HV_Operations

   c) Unpack the VMware PowerCLI SDK tarball into the new PowerCLI directory:

      tar -zxf ~/Downloads/VMware-PowerCLI-SDK-for-SPECvirt-Datacenter-2021.tgz

   d) Change directory to the PowerCLI subdirectory, and invoke Install-PowerCLI-SDK.sh:

      cd PowerCLI
      ./Install-PowerCLI-SDK.sh

4. Resume the steps in the User's Guide at Section 3.2.5.6 to run the script to configure svdc-director:

    cd /root/
    ./makeme_svdc-director.sh


Scenario 2: On an existing svdc-director
========================================

Follow these steps if you already deployed the svdc-director and want to switch to the PowerCLI SDK. 

1. Copy the VMware PowerCLI SDK tarball to $CP_HOME/config/workloads/specvirt/HV_Operations

NOTE: Install this SDK only on the svdc-director VM. Do not change svdc-template.

2. Set default directory to HV_Operations:

   cd $CP_HOME/config/workloads/specvirt/HV_Operations

3. Unpack the VMware PowerCLI SDK tarball into the new PowerCLI directory:

   tar -zxf ~/Downloads/VMware-PowerCLI-SDK-for-SPECvirt-Datacenter-2021.tgz

4. Change directory to the PowerCLI subdirectory, and invoke Install-PowerCLI-SDK.sh: 

   cd PowerCLI
   ./Install-PowerCLI-SDK.sh

5. Reboot svdc-director

When you enable PowerCLI, you do not need to recreate any workload or client VMs. After 
svdc-director VM reboots, PowerCLI works with existing VMs.

Details
=======

This script: 

   * Updates Control.config to set ${virtVendor} = PowerCLI 
   * Updates ~/.bashrc to add $CP_POWERCLI = 
        ${CP_HOME}/config/workloads/specvirt/HV_Operations/PowerCLI
   * Installs Microsoft PowerShell with yum (included in this SDK)
   * Installs VMware PowerCLI from within PowerShell (included in this SDK)

References
==========

* Install PowerShell on Linux: 
   https://docs.microsoft.com/en-us/powershell/scripting/install/installing-powershell-on-linux?view=powershell-7.2
* Microsoft PowerShell Gallery for VMware.PowerCLI: 
   https://www.powershellgallery.com/packages/VMware.PowerCLI/12.0.0.15947286 
* VMware PowerCLI Installation Guide: 
   https://developer.vmware.com/powercli/installation-guide

Copyright 2021,2022 Standard Performance Evaluation Corporation (SPEC). All rights reserved.

Microsoft and PowerShell are trademarks of the Microsoft group of companies.

VMware and VMware PowerCLI are trademarks of VMware, Inc. 

SPECvirt Datacenter 2021 web site: 
   http://www.spec.org/virt_datacenter2021
SPECvirt Datacenter 2021 Design Overview: 
   http://www.spec.org/virt_datacenter2021/docs/designoverview.html
SPECvirt Datacenter 2021 FAQ: 
   http://www.spec.org/virt_datacenter2021/docs/faq.html
SPECvirt Datacenter 2021 Patches: 
   http://www.spec.org/virt_datacenter2021/docs/patches.html
SPECvirt Datacenter 2021 Run and Reporting Rules: 
   http://www.spec.org/virt_datacenter2021/docs/runrules.html
SPECvirt Datacenter 2021 Technical Support: 
   http://www.spec.org/virt_datacenter2021/docs/techsupport.html
SPECvirt Datacenter 2021 User Guide: 
   http://www.spec.org/virt_datacenter2021/docs/userguide.html
SPECvirt Datacenter 2021 SDKs: 
   http://www.spec.org/virt_datacenter2021/sdks

