#!/bin/bash

REPORTERVERSION="09212022"

if [ ! -e /etc/vmware-vpx/vpxd.cfg ] ; then
   printf "\n$0 must be run on a vCenter Server.  To run the Reporter," 
   printf "\nplease execute Reporter.sh on svdc-director.\n"
   exit 1
fi

# Check VC manifest was copied by the Prime Client
if [ ! -e /tmp/Reporter-VC.mfx ] ; then
   printf "\nThe vCenter Server manifest does not exist.  To run the Reporter," 
   printf "\nplease execute Reporter.sh on the Prime Client.\n"
   exit 1
fi

rm -f /tmp/ReporterFile.txt 2>/dev/null  # clean up old temporary files from unclean exit

############################################################################
# Collect vc-support file
############################################################################

# All manifests are replaced by Reporter-VC.mfx which was transferred by Reporter.sh.
# This manifest is run by default so it does not have to be specified.
OUTPUTSTR=$(vc-support --manifestdir /tmp --quiet | head -n1)  # ex. "File: '/storage/log/vc-localhost-2022-09-19--14.38-33952.tgz'"
# Extract vc-support filename from vc-support output string
VCSUPPORTTGZ=`expr match "$OUTPUTSTR" "File: .\(\/.*tgz\)"`  # ex. /storage/log/vc-localhost-2022-09-19--14.38-33952.tgz
VCSUPPORTDIR=$(echo ${VCSUPPORTTGZ%\.tgz})  # full directory created when vc-support is extracted, ex. /storage/log/vc-localhost-2022-09-19--14.38-33952
VCSUPPORTSUBDIR=$(basename $VCSUPPORTDIR)   # subdirectory created when vc-support is extracted, ex. vc-localhost-2022-09-19--14.38-33952

############################################################################
# Extract vc-support .tgz and recompress as .tar.xz
############################################################################

# Hostname will be part of reporter package filename.
HOSTNAME=$(hostname -s 2>/dev/null)
# If hostname is localhost, use hostname if passed from director
if [ "$HOSTNAME" = "localhost" ] && [ -n "$1" ] ; then
   HOSTNAME=$1
fi

# Date will be part of reporter directory and reporter package filename.
DATE=$(date +"%Y%m%d-%H%M%S")                       # 20220921-113609
REPORTERDIR=$(dirname $VCSUPPORTDIR)/reporter-$DATE # ex. /storage/log/reporter-20220921-113609
SUBMITDIR=$HOSTNAME-$DATE                           # ex. vcsa-20220921-113609
SUBMITFILE=$HOSTNAME-$DATE.tar.xz                   # ex. vcsa-20220921-113609.tar.xz

mkdir -pm 755 $REPORTERDIR
cd $REPORTERDIR
tar -xzf $VCSUPPORTTGZ                    # extract vcsupport .tgz into VCSUPPORTSUBDIR
mv $VCSUPPORTSUBDIR $SUBMITDIR            # change VCSUPPORTSUBDIR to a more friendly name, SUBMITDIR
tar -cJf $SUBMITFILE $SUBMITDIR	         # Compress SUBMITDIR subdirectory into SUBMITFILE in REPORTERDIR

rm -rf $VCSUPPORTTGZ $SUBMITDIR 2>/dev/null # remove .tgz and extracted subdirectory

# Publish location of reporter package directory/filename for calling scripts & harness
# ex. /storage/log/reporter-20220921-113609/vcsa-20220921-113609
printf "$REPORTERDIR/$SUBMITFILE\n" >> /tmp/ReporterFile.txt 2>/dev/null

