#!/bin/pwsh

#############################################################################
#
# SPECvirt Datacenter 2021
#
# Copyright (c) 2021 Standard Performance Evaluation Corporation (SPEC)
# All rights reserved.
#
##############################################################################

# addVMDisk.ps1 - Add a virtual disk to a VM
#
# Get and set variables from Control.config
$configfile = ConvertFrom-StringData (Get-Content /export/home/cp/bin/Control.config -raw)
$ErrorActionPreference = "SilentlyContinue"
$PSStyle.OutputRendering = 'PlainText'

$mgmtServerIP  = $configfile.Get_Item("mgmtServerIP")
$virtUser      = $configfile.Get_Item("virtUser")
$virtPassword  = $configfile.Get_Item("virtPassword")

# Get variables from harness
$targetVM      = [string]$args[0]
$diskSizeGB    = [string]$args[1]

Try
{
   #Write-Host "Info: Connect to vSphere"
   $vc = Connect-VIServer -Server $mgmtServerIP -User $virtUser -Password $virtPassword
}
Catch
{
   Write-Host "Error on Connect-VIServer at Line $($_.InvocationInfo.ScriptLineNumber): $_ "
   exit 1
}

Try
{
   #Write-Host "Info: Adding hard disk"
   Get-VM $targetVM | New-HardDisk -CapacityGB $diskSizeGB -Persistence persistent -WarningAction:SilentlyContinue -Confirm:$False -Verbose:$false | Out-Null
}

Catch
{  
   Write-Host "Error adding virtual disk to VM: $_.Exception.Message at line $($_.InvocationInfo.ScriptLineNumber)" -ForegroundColor Red
   exit 1
}

Disconnect-VIServer -Confirm:$False
