#!/bin/bash

###########################################################################
#                                                                         
#  SPECvirt Datacenter 2021
#
#  Copyright (c) 2021 Standard Performance Evaluation Corporation (SPEC). 
#  All rights reserved.                                                   
#                                                                         
###########################################################################

# Invoke Reporter.sh to copy Reporter-{Host|VC}.{sh|mfx} to collect hypervisor support files for submission

# Set up environment variables
. /export/home/cp/bin/getVars.sh

runfolder=`ls -l /export/home/cp/results/specvirt|grep ^d|awk '{print $9}'|egrep '^[0-9]{4}-[0-9]{2}-[0-9]{2}_[0-9]{2}-[0-9]{2}-[0-9]{2}'|tail -1`
cd /export/home/cp/results/specvirt/$runfolder
mkdir -p support
LOG_FILE=/export/home/cp/results/specvirt/$runfolder/support/collectSupport.log

echo $(date -u) "Invoking reporter to create supporting tarballs for result ${runfolder}." |& tee -a $LOG_FILE

wtime=2000
elapsed=0
bgstatus=0
pidlist=()

for i in $(seq 1 $numHosts)
do
   setsid /export/home/cp/config/workloads/specvirt/HV_Operations/${virtVendor}/Reporter.sh sutHost$i & 
   pidlist+=($!)
   #echo  $(date -u) debug: pid = $!
   sleep 5
done

running=${#pidlist[@]}

while [ "$running" -ge 1 ]
do
   sleep 10
   elapsed=$((elapsed+10))
   #echo  $(date -u) "Elapsed time is $elapsed"  
   # check if any of the processes are still running
   running=`ps -o pid= -p ${pidlist[@]} |wc -l`

   # If elapsed time has exceeded wait time and there are still
   # processes running, kill off remaing processes via pgrp
   if [ $elapsed -ge $wtime ] && [ $running -ge 1 ]
   then
      for i in ${pidlist[@]}
      do
         echo $(date -u) pidlist is ${pidlist} |& tee -a $LOG_FILE
	 if [ `ps -o pgrp= -p $i |wc -w` -eq 1 ]
            then 
            echo  $(date -u) "Killing process ids ${pidlist}"
  	    kill -TERM -- -$i >/dev/null 2>&1
	 fi
      done

   # check if any process is still running and print warning message
   sleep 2
   running=`ps -o pid= -p ${pidlist[@]} |wc -l` 
   if [ $running -ne 0 ]
      then
         echo $(date -u) "Running processes are $running" |& tee -a $LOG_FILE
         echo $(date -u) "Timer expired, reporter processes may not have terminated. Please rerun manually. " |& tee -a $LOG_FILE
      else
         echo $(date -u) "Timer expired, reporter processes. Please rerun manually. " |& tee -a $LOG_FILE
    fi
    bgstatus=1
    break
    fi
done

#echo $(date -u) bgstatus is $bgstatus

if [ $bgstatus -eq 0 ] 
  then
  echo $(date -u) "Background processes finished. Bundling support files" |& tee -a $LOG_FILE
  cd /export/home/cp/results/specvirt
  tar czf $runfolder-support.tar.tgz $runfolder
  mv $runfolder-support.tar.tgz $runfolder/
fi

echo; echo $(date -u) "collectSupport.sh complete." |& tee -a $LOG_FILE
