#!/bin/pwsh

#############################################################################
#
# SPECvirt Datacenter 2021
#
# Copyright (c) 2021 Standard Performance Evaluation Corporation (SPEC)
# All rights reserved.
#
##############################################################################

# deleteVM.ps1 - Delete a VM 
#
# Get and set variables from Control.config
$configfile = ConvertFrom-StringData (Get-Content /export/home/cp/bin/Control.config -raw)
$ErrorActionPreference = "SilentlyContinue"
$PSStyle.OutputRendering = 'PlainText'

$mgmtServerIP  = $configfile.Get_Item("mgmtServerIP")
$virtUser      = $configfile.Get_Item("virtUser")
$virtPassword  = $configfile.Get_Item("virtPassword")

# Get variables from harness
$targetVM      = [string]$args[0]

Try
{
   #Write-Host "Info: Connect to vSphere"
   $vc = Connect-VIServer -Server $mgmtServerIP -User $virtUser -Password $virtPassword
}
Catch
{
   Write-Host "Error: Connect-VIServer at Line $($_.InvocationInfo.ScriptLineNumber): $_ "
}

Try 
{
   #Write-Host "Info: Check for existence of VM"
   $VMexists = Get-VM $targetVM -Verbose:$false  

   if ( $VMexists -eq $null ) {
        Write-Host "VM does not exist."
        exit 
   } 
   if ( $VMexists.PowerState -ne "PoweredOff" ) {
      #Write-Host "Info: Stopping VM "  
      Stop-VM -VM $VMexists -confirm:$false -Verbose:$false | Out-Null
      sleep 5
      Get-VM -Name $VMexists | Stop-VMGuest -confirm:$false -Verbose:$false | Out-Null
      sleep 5
      #Write-Host "Info: Powered off VM" 
      }
}
Catch
{
   Write-Host "Error powering off VM: $_.Exception.Message at line $($_.InvocationInfo.ScriptLineNumber)" -ForegroundColor Red
}

Try
{
   #Write-Host "Info: Deleting VM "  
   Get-VM -Name $VMexists | Remove-VM -confirm:$false -RunAsync:$false -DeletePermanently -Verbose:$false | Out-Null
}

Catch
{
   Write-Host "Error deleting VM: $_.Exception.Message at line $($_.InvocationInfo.ScriptLineNumber)" -ForegroundColor Red
}

Disconnect-VIServer -Confirm:$False
