#!/bin/pwsh

#############################################################################
#
# SPECvirt Datacenter 2021
#
# Copyright (c) 2021 Standard Performance Evaluation Corporation (SPEC)
# All rights reserved.
#
##############################################################################

# enterMaintenanceMode.ps1 - Places a host in maintenance mode

# Get and set variables from Control.config
$configfile = ConvertFrom-StringData (Get-Content /export/home/cp/bin/Control.config -raw)
$ErrorActionPreference = "SilentlyContinue"
$PSStyle.OutputRendering = 'PlainText'

$cluster        = $configfile.Get_Item("cluster")
$mgmtServerIP   = $configfile.Get_Item("mgmtServerIP")
$virtUser       = $configfile.Get_Item("virtUser")
$virtPassword   = $configfile.Get_Item("virtPassword")

# Get variables from harness
$offlineHost    = [String]$args[0]

Try
{
   #Write-Host "Info: Connect to vSphere"
   $vc = Connect-VIServer -Server $mgmtServerIP -User $virtUser -Password $virtPassword
}
Catch
{
   Write-Host "Error: Connect-VIServer at Line $($_.InvocationInfo.ScriptLineNumber): $_ "
}
Try
{
   Set-VMHost -VMHost $offlineHost -State "Maintenance" -evacuate -runAsync:$false | Out-Null
   Write-Host "Info: $offlineHost entering maintenance mode"
}
Catch
{
   Write-Host "Error entering maintenance mode: $_.Exception.Message at line $($_.InvocationInfo.ScriptLineNumber)" -ForegroundColor Red
}

Disconnect-VIServer -Confirm:$False
