#!/bin/pwsh

###########################################################################
#                                                                         
# SPECvirt Datacenter 2021
#
#  Copyright (c) 2021 Standard Performance Evaluation Corporation (SPEC). 
#  All rights reserved.                                                   
#                                                                         
###########################################################################

#  events.ps1 - Collects hypervisor events during the measurement needed 
#   for the test validaton.  
#
# Get and set variables from Control.config
$configfile = ConvertFrom-StringData (Get-Content /export/home/cp/bin/Control.config -raw)
#$ErrorActionPreference = "SilentlyContinue"
$PSStyle.OutputRendering = 'PlainText'

$mgmtServerIP  = $configfile.Get_Item("mgmtServerIP")
$virtUser      = $configfile.Get_Item("virtUser")
$virtPassword  = $configfile.Get_Item("virtPassword")

Try
{
   $vc = Connect-VIServer -Server $mgmtServerIP -User $virtUser -Password $virtPassword
}
Catch
{
   Write-Host "Error: Connect-VIServer at Line $($_.InvocationInfo.ScriptLineNumber): $_ "
   exit 1
}

Try
{
   $now = get-date -AsUTC
   $begin = $now.AddHours(-3)

   $StartTime = $begin
   #$StartTime = (Get-Date).AddHours(-3)
   $arrEvents = @()
   $viewEventMgr = (Get-View EventManager).Description.EventInfo
   $events = Get-VIEvent -Start $startTime -MaxSamples 1000000
   foreach ($event in $events)
      {
          $objEvent = "" | Select CreatedTime,EventCategory,FullFormattedMessage
          $objEvent.CreatedTime = $event.CreatedTime
          $objEvent.FullFormattedMessage = $event.FullFormattedMessage
          If ($event.EventTypeId -ne $null)
          {
             $objEvent.EventCategory = $viewEventMgr | Where{$_.FullFormat -match $event.EventTypeId} | Select -expand Category
          }
          else
          {
             $objEvent.EventCategory = $viewEventMgr | Where{$_.Key -eq $event.GetType().Name} | Select -expand Category
          }
    $arrEvents += $objEvent
      }
$arrEvents | Sort-Object -Property CreatedTime | format-list 
}
                                                                                                                                                   
Catch                                                                                                                                                
{                                                                                                                                                    
    Write-Host "Error getting events at Line $($_.InvocationInfo.ScriptLineNumber): $_ "                                                            
}                                                                                                                                                    
                                                                                                                                                     
Disconnect-VIServer -Confirm:$False
