#!/bin/pwsh
#
#############################################################################
#
# SPECvirt Datacenter 2021
#
# Copyright (c) 2021 Standard Performance Evaluation Corporation (SPEC)
# All rights reserved.
#
##############################################################################

# getCluster.ps1 - Gathers SUT host configuration

# Get and set variables from Control.config
$configfile = ConvertFrom-StringData (Get-Content /export/home/cp/bin/Control.config -raw)
$ErrorActionPreference = "SilentlyContinue"
$PSStyle.OutputRendering = 'PlainText'

$mgmtServerIP   = $configfile.Get_Item("mgmtServerIP")
$virtUser       = $configfile.Get_Item("virtUser")
$virtPassword   = $configfile.Get_Item("virtPassword")
$cluster        = $configfile.Get_Item("cluster")

Try
{
   $vc = Connect-VIServer -Server $mgmtServerIP -User $virtUser -Password $virtPassword
}
Catch
{
   Write-Host "Error: Connect-VIServer at Line $($_.InvocationInfo.ScriptLineNumber): $_ "
   exit 1
}

Get-VMHost | Sort-Object
foreach ($vmhost in $vmhosts) {
         $object = New-Object -TypeName PSObject
         $object | Add-Member -MemberType NoteProperty -Name "Cluster" -Value $cluster
         $object | Add-Member -MemberType NoteProperty -Name "Host" -Value $vmhost
         $object | Add-Member -MemberType NoteProperty -Name "Version" -Value $vmhost.Version
         $object | Add-Member -MemberType NoteProperty -Name "Build" -Value $vmhost.Build
         $object | Add-Member -MemberType NoteProperty -Name "Uptime (Days)" -Value (New-TimeSpan -Start $vmhost.ExtensionData.Summary.Runtime.BootTime -End (Get-Date) | Select-Object -ExpandProperty Days)
         $objects += $object
     }
$vmhosts | FT -wrap

Disconnect-VIServer -Confirm:$False
