#!/bin/pwsh

#############################################################################
#
# SPECvirt Datacenter 2021
#
# Copyright (c) 2021, 2022 Standard Performance Evaluation Corporation (SPEC)
# All rights reserved.
#
##############################################################################

# install-VMware-PowerCLI.ps1 - Checks install of VMware PowerCLI SDK and 
#     sets up environment 

$ErrorActionPreference = "SilentlyContinue"
$VerbosePreference = "SilentlyContinue"

Set-PSRepository -Name 'PSGallery' -InstallationPolicy Trusted 
Set-PowerCLIConfiguration -Scope User -ParticipateInCEIP $false -InvalidCertificateAction Ignore -DefaultVIServerMode Single -Confirm:$false | Out-Null

$sdk = Get-Module -ListAvailable VMware.PowerCLI
if ( $sdk -eq $null ) {
   Write-Host "VMware PowerCLI failed to install."
   exit 1
}
else
{
   Write-Host "VMware PowerCLI successfully installed."
   exit 0
}
