#!/bin/pwsh
#############################################################################
#
# SPECvirt Datacenter 2021
#
##############################################################################
#
# migrationDetails.ps1 - Gets details of migrations
#
# Get and set variables from Control.config
$configfile = ConvertFrom-StringData (Get-Content /export/home/cp/bin/Control.config -raw)
$ErrorActionPreference = "SilentlyContinue"
$PSStyle.OutputRendering = 'PlainText'

$mgmtServerIP   = $configfile.Get_Item("mgmtServerIP")
$virtUser       = $configfile.Get_Item("virtUser")
$virtPassword   = $configfile.Get_Item("virtPassword")
$cluster        = $configfile.Get_Item("cluster")

Try
{
   $vc = Connect-VIServer -Server $mgmtServerIP -User $virtUser -Password $virtPassword
}
Catch
{
   Write-Host "Error: Connect-VIServer at Line $($_.InvocationInfo.ScriptLineNumber): $_ "
}

# Clean up
Remove-Item -Path /tmp/vm*.txt 

$resultsdir = (Get-ChildItem '/export/home/cp/results/specvirt' -Attributes Directory | Sort-Object -Descending -Property LastWriteTime | select -First 1)
Set-Location $resultsdir/config

"==================" | Add-Content "SUTConfig.out"
"Migration Details:" | Add-Content "SUTConfig.out"
"==================" | Add-Content "SUTConfig.out"
""                   | Add-Content "SUTConfig.out"

$count = grep "migrated" SUTConfig.out | wc -l | awk '{ print $1 }'
"SUT.VM.migration.total=$count" | Add-Content "endRun.config" 

$details = grep "migrated" SUTConfig.out | Add-Content "SUTConfig.out"

Disconnect-VIServer -Confirm:$False
