#!/bin/pwsh

#############################################################################
#
# SPECvirt Datacenter 2021
#
# Copyright (c) 2021 Standard Performance Evaluation Corporation (SPEC)
# All rights reserved.
#
##############################################################################

# powerOnVM.ps1 - Power on (start) a VM

# Get and set variables from Control.config
$configfile = ConvertFrom-StringData (Get-Content /export/home/cp/bin/Control.config -raw)
$ErrorActionPreference = "SilentlyContinue"
$PSStyle.OutputRendering = 'PlainText'

$mgmtServerIP  = $configfile.Get_Item("mgmtServerIP")
$virtUser      = $configfile.Get_Item("virtUser")
$virtPassword  = $configfile.Get_Item("virtPassword")

# Get variables from harness
$targetVM      = [string]$args[0]

Try
{
   #Write-Host "Info: Connect to vSphere"
   $vc = Connect-VIServer -Server $mgmtServerIP -User $virtUser -Password $virtPassword
}
Catch
{
   Write-Host "Error: Connect-VIServer at Line $($_.InvocationInfo.ScriptLineNumber): $_ "
}

Try
{
   $VMexists = Get-VM $targetVM -Verbose:$false  
   if (($VMexists.PowerState -eq "PoweredOn") -or ($VMexists -eq $null)) {
   exit
   }
}
Catch
{
   Write-Host "Error powering on VM: $_.Exception.Message at line $($_.InvocationInfo.ScriptLineNumber)" -ForegroundColor Red
}

Try
{
   Start-VM $targetVM -Verbose:$false -Confirm:$false | Out-Null
   #Write-Host "Info: VM powered on"
}
Catch
{  
   Write-Host "Error powering on VM: $_.Exception.Message at line $($_.InvocationInfo.ScriptLineNumber)" -ForegroundColor Red
}

Disconnect-VIServer -Confirm:$False
