#!/bin/sh
#
# Set up passwordless login to vSphere hosts and vCenter
#
# Before running this script, make sure to update /etc/hosts with hostname aliases for
#   SUT online and offline hosts, client hosts, and the vCenter VM.
#
# For example:
#
#  12.22.0.2   vcenter vCHost
#  12.22.0.11  sutHost1
#  12.22.0.12  sutHost2
#  12.22.0.13  sutHost3
#  12.22.0.14  sutHost4 offline_host1
#
# Optionally you can add aliases for the client hosts:
#
#  12.22.0.21  clientHost1
#  12.22.0.22  clientHost2

# Get environment variables
. /export/home/cp/bin/getVars.sh

# Generate key and accept defaults
ssh-keygen -t ecdsa -f /root/.ssh/id_ecdsa -N ''

echo $(date -u) "Enabling password-less login to vSphere hosts"; echo
for Host in `grep Host /etc/hosts | awk '{print $1}' | grep -v "#"`
do
      echo "Processing host ${Host}"
      cat ~/.ssh/id_ecdsa.pub | ssh -o PubkeyAuthentication=no $Host 'cat >> /etc/ssh/keys-root/authorized_keys'
      cat ~/.ssh/id_ecdsa.pub | ssh -o PubkeyAuthentication=no $Host 'cat >> .ssh/authorized_keys'
      ssh -o PubkeyAuthentication=no $Host 'chmod +t /etc/ssh/keys-root/authorized_keys'
      ssh -o PubkeyAuthentication=no $Host 'chmod +t .ssh/keys-root/authorized_keys'
      ssh -o PubkeyAuthentication=no $Host '/etc/init.d/SSH restart'
done
echo; echo $(date -u) "Password-less login to vSphere hosts and vCenter enabled"
