#!/bin/bash

#############################################################################
#
# SPECvirt Datacenter 2021
#
# Copyright (c) 2021 Standard Performance Evaluation Corporation (SPEC)
# All rights reserved.
#
##############################################################################

# startesxtop.sh - vSphere esxtop initialization script 
#
#   $CP_BIN/Control.config defines:
#     - $clientStoragePool[0] as the default storage target for esxtop batch files.
#         You can change the value of $LUN to use your persistent shared LUN and directory
#         (for example "/vmfs/volumes/LUN6")
#     - $offlineHost_X as the host(s) in maintenance mode
#
#  Requirements:
#
#  1. Make sure you define all ONLINE cluster hosts with an alias starting with the string "sutHost".
#       Edit /export/home/cp/bin/hosts.txt to add each sutHost and its IP address. For example:
#           172.23.0.11   sutHost1
#           172.23.0.12   sutHost2
#           172.23.0.13   sutHost3
#
#  2. Make sure you define all MAINTENANCE MODE hosts in /export/home/cp/bin/Control.config:
#           offlineHost_1 = 172.23.0.14
#
#  If you make changes to hosts.txt and/or Control.config, rerun /export/home/cp/bin/genConfig.sh
#
#set -x

. /export/home/cp/bin/getVars.sh

LUN=${clientStoragePool[0]}

ssh $offlineHost_1 "if [ ! -d /vmfs/volumes/$LUN/SVDCperf ]; then mkdir /vmfs/volumes/$LUN/SVDCperf; fi &"
sleep 2
# Start esxtop on online cluster hosts
for sutHost in `grep sutHost /etc/hosts | awk '{print $1}'`
do
   echo; echo $(date -u) "Starting esxtop in batch mode on $sutHost ... "
   ssh $sutHost "nohup esxtop -b -d 10 -n 1080 > /vmfs/volumes/$LUN/SVDCperf/$sutHost-esxtop.csv &" &

done

#echo; echo "Sleeping until Phase 3 starts ... "
#sleep $phase3StartTime
## Start esxtop on offline (maintMode) hosts
#for offlineHost in `grep offlineHost /export/home/cp/bin/Control.config | awk '{print $3}'`
#do
#   echo; echo "Starting esxtop in batch mode on $offlineHost ... "
#   ssh $offlineHost "nohup esxtop -b -d 10 -n 1080 > /vmfs/volumes/$LUN/$offlineHost-$runfolder-esxtop.csv &"
#done
#set +x
