#!/bin/bash

#############################################################################
#
# SPECvirt Datacenter 2021
#
# Copyright (c) 2021 Standard Performance Evaluation Corporation (SPEC)
# All rights reserved.
#
##############################################################################

# stopesxtop.sh - vSphere esxtop stop script
#
# Follow instructions in startesxtop.sh

. /export/home/cp/bin/getVars.sh

LOG_FILE=/export/home/cp/results/specvirt/${runfolder}/esxtop.log

LUN=${clientStoragePool[0]}

runfolder=`ls -l /export/home/cp/results/specvirt|grep ^d|awk '{print $9}'|egrep '^[0-9]{4}-[0-9]{2}-[0-9]{2}_[0-9]{2}-[0-9]{2}-[0-9]{2}'|tail -1`
if [ -f /export/home/cp/results/specvirt/$runfolder/perf/$runfolder-esxtop.tgz ]; then
   mv /export/home/cp/results/specvirt/$runfolder/perf/$runfolder-esxtop.tgz /export/home/cp/results/specvirt/$runfolder/perf/$runfolder-esxtop.tgz_prior
fi

# Stop esxtop on online cluster hosts
for host in `grep sutHost /etc/hosts | awk '{print $1}'i|grep -v ^# `
do
   echo; echo $(date -u) "Stopping esxtop on $host ... " |& tee $LOG_FILE
   ssh $host "pkill esxtop"
   ssh $host "pkill esxtop"
done

sleep 20

# Copy perf collector output CSV files from offline host
cd $CP_RESULTS/$runfolder
echo; echo $(date -u) "Bundling up and copying esxtop output to $CP_RESULTS/$runfolder/perf ... " |& tee $LOG_FILE
mkdir -p perf; cd perf
ssh $offlineHost_1 "cd /vmfs/volumes/$LUN/SVDCperf; tar -czf $runfolder-esxtop.tgz *esxtop.csv"
scp -p $offlineHost_1:/vmfs/volumes/$LUN/SVDCperf/$runfolder-esxtop.tgz /export/home/cp/results/specvirt/$runfolder/perf
scp -p $offlineHost_1:/etc/vmware/esx.conf /export/home/cp/results/specvirt/$runfolder/perf

# Optional clean up keeping current CSV and tgz files and deleting all others
#ssh $offlineHost_1 "ls -lQ /vmfs/volumes/$LUN/*.csv | grep -v '$runfolder' | rm -f"
#ssh $offlineHost_1 "ls -lQ /vmfs/volumes/$LUN/*.tgz | grep -v '$runfolder' | rm -f"

echo; echo $(date -u) "esxtop stop script test run $runfolder" |& tee $LOG_FILE

