#/bin/bash

#############################################################################
#
# SPECvirt Datacenter 2021
#
# Copyright (c) 2021 Standard Performance Evaluation Corporation (SPEC)
# All rights reserved.
#
##############################################################################

# sutConfig.sh - Get SUT details - at the beginning (0) and end (1) of benchmark run 

if [ "$#" -ne 1 ]; then
   echo "Usage:./sutConfig.sh <0/1>"
   exit 1
fi

# Set up environment variables
. /export/home/cp/bin/getVars.sh

# Get most recent results directory name
runfolder=`ls -l /export/home/cp/results/specvirt|grep ^d|awk '{print $9}'|egrep '^[0-9]{4}-[0-9]{2}-[0-9]{2}_[0-9]{2}-[0-9]{2}-[0-9]{2}'|tail -1`
mkdir -p /export/home/cp/results/specvirt/$runfolder/config
LOG_FILE=/export/home/cp/results/specvirt/${runfolder}/config/sutConfig.log

cd /export/home/cp/results/specvirt/$runfolder/config

# Start of measurement interval called by startRun.sh
if [ $1 = "0" ]
  then
  rm -rf /tmp/tmp.*; rm -rf /tmp/vm*txt
  echo $(date -u) "Creating start of run config files for result ${runfolder}." |& tee $LOG_FILE
  pwsh /export/home/cp/config/workloads/specvirt/HV_Operations/${virtVendor}/sutConfig.ps1 $1 > startRun.config
  cp startRun.config /tmp
  exit 0

# End of measurement interval called by endRun.sh
else [ $1 = "1" ]
  echo $(date -u) "Creating end of run config files for result ${runfolder}." |& tee $LOG_FILE
  pwsh /export/home/cp/config/workloads/specvirt/HV_Operations/${virtVendor}/sutConfig.ps1 $1 > endRun.config

# Start processing from [start,end]Run.config
  if [[ ! -f startRun.config ]] || [[ ! -f endRun.config ]]; then
    echo $(date -u) "Problem with startRun.config and/or endRun.config. Contact SPECvirt support." |& tee $LOG_FILE
    exit 1
  else

    echo $(date -u) "Collecting VM details for result ${runfolder}." |& tee $LOG_FILE
    echo "============" > SUTConfig.out
    echo "List of VMs:" >> SUTConfig.out
    echo "============" >> SUTConfig.out
    pwsh /export/home/cp/config/workloads/specvirt/HV_Operations/${virtVendor}/vmDetails.ps1 >> SUTConfig.out

    echo $(date -u) "Collecting event details for result ${runfolder}." |& tee $LOG_FILE
    echo "===============" >> SUTConfig.out
    echo "vSphere Events:" >> SUTConfig.out
    echo "===============" >> SUTConfig.out
    pwsh /export/home/cp/config/workloads/specvirt/HV_Operations/${virtVendor}/events.ps1 >> SUTConfig.out

    echo $(date -u) "Collecting migration details for result ${runfolder}." |& tee $LOG_FILE
    echo "==================" >> SUTConfig.out
    echo "Migration Details:" >> SUTConfig.out
    echo "==================" >> SUTConfig.out
    pwsh /export/home/cp/config/workloads/specvirt/HV_Operations/${virtVendor}/migrationDetails.ps1 
    cat /tmp/vmotions.txt >> SUTConfig.out
    cat /tmp/vmcount.txt >> endRun.config
  fi
fi

cd /export/home/cp/results/specvirt/$runfolder/config
for i in $(seq 1 $numHosts);
do
   echo $(date -u) "Non-default settings on sutHost${i}" > sutHost${i}-esx-conf-non-defaults.txt 
   echo "===================================" >> sutHost${i}-esx-conf-non-defaults.txt 
   ssh sutHost${i} "esxcli system settings advanced list -d" >> sutHost${i}-esx-conf-non-defaults.txt
done

# Clean up temp files
rm -rf /tmp/tmp.*; rm -rf /tmp/vm*.txt

echo $(date -u) "sutConfig.sh complete." |& tee -a $LOG_FILE
