#!/bin/pwsh
#
###########################################################################
#                                                                         
#  SPECvirt Datacenter 2021
#
#  Copyright (c) 2021 Standard Performance Evaluation Corporation (SPEC). 
#  All rights reserved.                                                   
#                                                                         
###########################################################################

# vmDetails.ps1 - Get VM details for validation

# Get and set variables from Control.config
$configfile = ConvertFrom-StringData (Get-Content /export/home/cp/bin/Control.config -raw)
$ErrorActionPreference = "SilentlyContinue"
$PSStyle.OutputRendering = 'PlainText'

$mgmtServerIP  = $configfile.Get_Item("mgmtServerIP")
$virtUser      = $configfile.Get_Item("virtUser")
$virtPassword  = $configfile.Get_Item("virtPassword")
$cluster       = $configfile.Get_Item("cluster")

Try
{
   $vc = Connect-VIServer -Server $mgmtServerIP -User $virtUser -Password $virtPassword
}
Catch
{
   Write-Host "Error: Connect-VIServer at Line $($_.InvocationInfo.ScriptLineNumber): $_ "
   exit 1
}

Try
{
   $vms=Get-VM -Name 'svdc-t*'| Where{$_.Name -match '^svdc-t\d{3}-.*' -and $_.Name -notMatch 'client'} |
      select @{N='VM Name';E={$_.Name}},
      @{N='HostName';E={$_.VMHost}},
      @{N='VM Status';E={$_.PowerState}},
      @{N="Memory(GB)";E={[math]::round($_.MemoryGB, 0 )}},
      @{N="vCPU Count";E={$_.NumCpu}} 
$vms | Format-Table -Autosize 
}

Catch 
{
   Write-Host "Error collecting VM info: $_.Exception.Message at line $($_.InvocationInfo.ScriptLineNumber)" 
}

Disconnect-VIServer -Confirm:$False
