#!/bin/pwsh

#############################################################################
#
# SPECvirt Datacenter 2021
#
# Copyright (c) 2021 Standard Performance Evaluation Corporation (SPEC)
# All rights reserved.
#
##############################################################################

# vmExist.ps1 - Check if VM exists

# Get and set variables from Control.config
$configfile = ConvertFrom-StringData (Get-Content /export/home/cp/bin/Control.config -raw)
$ErrorActionPreference = "SilentlyContinue"
$PSStyle.OutputRendering = 'PlainText'

$mgmtServerIP  = $configfile.Get_Item("mgmtServerIP")
$virtUser      = $configfile.Get_Item("virtUser")
$virtPassword  = $configfile.Get_Item("virtPassword")

# Get variables from harness
$targetVM      = [string]$args[0]

Try
{
   #Write-Host "Info: Connect to vSphere"
   $vc = Connect-VIServer -Server $mgmtServerIP -User $virtUser -Password $virtPassword
}
Catch
{
   Write-Host "Error: Connect-VIServer at Line $($_.InvocationInfo.ScriptLineNumber): $_ "
}

#Write-Host "Info: Check for existence of VM"
$Exists = Get-VM -Name $targetVM 
If ($Exists){
	Write-Host "VM exists"
}
Else {
	Write-Host "VM does not exist"
}

Disconnect-VIServer -Confirm:$False
