/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jbi.serviceengine.bridge.transport;

import com.sun.enterprise.jbi.serviceengine.comm.MessageExchangeTransport;
import com.sun.enterprise.jbi.serviceengine.comm.MessageExchangeTransportFactory;
import com.sun.enterprise.jbi.serviceengine.comm.UnWrappedMessage;
import com.sun.enterprise.jbi.serviceengine.core.DescriptorEndpointInfo;
import com.sun.enterprise.jbi.serviceengine.core.EndpointRegistry;
import com.sun.enterprise.jbi.serviceengine.core.JavaEEServiceEngineContext;
import com.sun.enterprise.jbi.serviceengine.util.soap.EndpointMetaData;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.xml.namespace.QName;

public class NMRClientConnection {
    private boolean oneWay;
    private URL wsdlLocation;
    private QName service;
    private String endpointName;
    private QName operation;
    private MessageExchange me = null;
    private MessageExchangeTransport meTransport;
    private static ConcurrentHashMap<String, EndpointMetaData> emdCache = new ConcurrentHashMap(11, 0.75f, 4);

    public NMRClientConnection(URL wsdlLocation, QName service, String endpointName, QName operation, boolean oneWay) {
        this.wsdlLocation = wsdlLocation;
        this.service = service;
        this.endpointName = endpointName;
        this.operation = operation;
        this.setOneWay(oneWay);
    }

    public void setOneWay(boolean oneWay) {
        this.oneWay = oneWay;
    }

    public void initialize() {
        try {
            DeliveryChannel channel = JavaEEServiceEngineContext.getInstance().getDeliveryChannel();
            String key = DescriptorEndpointInfo.getDEIKey(this.service, this.endpointName);
            DescriptorEndpointInfo dei = EndpointRegistry.getInstance().getJBIEndpts().get(key);
            QName service = dei == null ? this.service : dei.getServiceName();
            String endpointName = dei == null ? this.endpointName : dei.getEndpointName();
            MessageExchangeFactory factory = channel.createExchangeFactoryForService(service);
            this.me = this.oneWay ? factory.createInOnlyExchange() : factory.createInOutExchange();
            this.me.setService(service);
            ComponentContext context = JavaEEServiceEngineContext.getInstance().getJBIContext();
            this.me.setEndpoint(context.getEndpoint(service, endpointName));
            this.me.setOperation(this.operation);
            this.meTransport = MessageExchangeTransportFactory.getHandler(this.me);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    private EndpointMetaData getEndpointMetaData() {
        String clientCache = System.getProperty("com.sun.enterprise.jbi.se.clientcache");
        if ("false".equalsIgnoreCase(clientCache)) {
            return this.createEndpointMetaData();
        }
        String key = this.wsdlLocation.toString();
        EndpointMetaData emd = emdCache.get(key);
        if (emd == null) {
            emd = this.createEndpointMetaData();
            emdCache.put(key, emd);
        }
        return emd;
    }

    private EndpointMetaData createEndpointMetaData() {
        EndpointMetaData emd = new EndpointMetaData(this.wsdlLocation, this.service, this.endpointName);
        emd.resolve();
        return emd;
    }

    public void sendRequest(Packet packet) throws Exception {
        this.meTransport.send(packet, this.getEndpointMetaData());
    }

    public Packet receiveResponse(Packet request) {
        UnWrappedMessage respMsg = this.meTransport.receive(this.getEndpointMetaData());
        Packet reply = request.createResponse((Message)respMsg);
        if (reply.invocationProperties != null) {
            reply.invocationProperties.putAll(this.meTransport.getMessageProperties());
        }
        return reply;
    }

    public void sendStatus() {
        if (this.me.getStatus().equals(ExchangeStatus.ACTIVE)) {
            this.meTransport.sendStatus(ExchangeStatus.DONE);
        }
    }
}

