/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jbi.serviceengine.comm;

import com.sun.enterprise.jbi.serviceengine.comm.UnWrappedMessage;
import com.sun.enterprise.jbi.serviceengine.core.JavaEEServiceEngineContext;
import com.sun.enterprise.jbi.serviceengine.util.DOMUtil;
import com.sun.enterprise.jbi.serviceengine.util.JBIConstants;
import com.sun.enterprise.jbi.serviceengine.util.soap.EndpointMetaData;
import com.sun.enterprise.jbi.serviceengine.util.soap.SOAPConstants;
import com.sun.logging.LogDomains;
import com.sun.xml.bind.api.Bridge;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Message;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Fault;
import javax.wsdl.Part;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WrappedMessage
extends Message
implements JBIConstants,
SOAPConstants {
    private static Logger logger = LogDomains.getLogger((String)"javax.enterprise.system");
    private static DocumentBuilderFactory dbf;
    Source wrappedMessage;
    Message abstractMessage;
    QName wsdlMessageType;
    String wsdlBindingStyle;
    String wsdlMessageName;
    List<Part> wsdlOrderedParts;
    int[] wsdlPartBindings;
    private boolean log = false;

    public void setAbstractMessage(Message abstractMessage) {
        this.abstractMessage = abstractMessage;
    }

    public void setWSDLMessageType(QName wsdlMessageType) {
        this.wsdlMessageType = wsdlMessageType;
    }

    public void setWSDLBindingStyle(String wsdlBindingStyle) {
        this.wsdlBindingStyle = wsdlBindingStyle;
    }

    public void setWSDLMessageName(String wsdlMessageName) {
        this.wsdlMessageName = wsdlMessageName;
    }

    public void setWSDLOrderedParts(List<Part> wsdlOrderedParts) {
        this.wsdlOrderedParts = wsdlOrderedParts;
    }

    public void setWSDLPartBindings(int[] wsdlPartBindings) {
        this.wsdlPartBindings = wsdlPartBindings;
    }

    private void setLog() {
        if (logger.isLoggable(Level.FINE)) {
            this.log = true;
        }
    }

    public WrappedMessage() {
        if (dbf == null) {
            dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
        }
        this.setLog();
    }

    public void wrap() throws Exception {
        if (JavaEEServiceEngineContext.getInstance().isServiceMix()) {
            if (this.log) {
                logger.log(Level.FINE, "Skipping the wrapping...");
            }
            this.wrappedMessage = this.abstractMessage.readPayloadAsSource();
        } else if ("rpc".equalsIgnoreCase(this.wsdlBindingStyle)) {
            new RPCStyleWrapper().wrap();
        } else {
            new DocumentStyleWrapper().wrap();
        }
    }

    private void writeJBIHeader(XMLStreamWriter writer) throws Exception {
        writer.writeStartDocument();
        writer.writeStartElement("jbi:message");
        this.writeMessageAttributes(writer, this.wsdlMessageName);
    }

    private void writeJBIFooter(XMLStreamWriter writer) throws Exception {
        writer.writeEndElement();
        writer.writeEndDocument();
        writer.flush();
    }

    private void setMessage(byte[] data) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        String usedWith = System.getProperty("com.sun.enterprise.jbi.se.usedwith");
        if (usedWith != null && usedWith.indexOf("httpsoapbc") != -1) {
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.wrappedMessage = new DOMSource(db.parse(bais));
        } else {
            this.wrappedMessage = new StreamSource(bais);
        }
    }

    private void writeMessageAttributes(XMLStreamWriter sw, String wsdlMessageName) throws XMLStreamException {
        String prefix = this.wsdlMessageType.getPrefix();
        if (prefix == null || prefix.trim().length() == 0) {
            prefix = "msgns";
        }
        sw.writeAttribute("version", "1.0");
        if (wsdlMessageName != null) {
            sw.writeAttribute("name", wsdlMessageName);
        }
        sw.writeAttribute("type", prefix + ":" + this.wsdlMessageType.getLocalPart());
        sw.writeAttribute("xmlns:" + prefix, this.wsdlMessageType.getNamespaceURI());
        sw.writeAttribute("xmlns:jbi", "http://java.sun.com/xml/ns/jbi/wsdl-11-wrapper");
    }

    public Source readPayloadAsSource() {
        return this.wrappedMessage;
    }

    public boolean isFault() {
        return this.abstractMessage.isFault();
    }

    public String getPayloadLocalPart() {
        return this.abstractMessage.getPayloadLocalPart();
    }

    public String getPayloadNamespaceURI() {
        return this.abstractMessage.getPayloadNamespaceURI();
    }

    public XMLStreamReader readPayload() throws XMLStreamException {
        return this.abstractMessage.readPayload();
    }

    public boolean hasPayload() {
        return this.abstractMessage.hasPayload();
    }

    public boolean hasHeaders() {
        return this.abstractMessage.hasHeaders();
    }

    public HeaderList getHeaders() {
        return this.abstractMessage.getHeaders();
    }

    public Message copy() {
        return null;
    }

    public Source readEnvelopeAsSource() {
        return this.abstractMessage.readEnvelopeAsSource();
    }

    public SOAPMessage readAsSOAPMessage() throws SOAPException {
        return this.abstractMessage.readAsSOAPMessage();
    }

    public <T> T readPayloadAsJAXB(Unmarshaller unmarshaller) throws JAXBException {
        return (T)this.abstractMessage.readPayloadAsJAXB(unmarshaller);
    }

    public <T> T readPayloadAsJAXB(Bridge<T> bridge) throws JAXBException {
        return (T)this.abstractMessage.readPayloadAsJAXB(bridge);
    }

    public void writePayloadTo(XMLStreamWriter sw) throws XMLStreamException {
        try {
            sw.flush();
            this.abstractMessage.writePayloadTo(sw);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new XMLStreamException(ex);
        }
    }

    public void writeTo(ContentHandler contentHandler, ErrorHandler errorHandler) throws SAXException {
        this.abstractMessage.writeTo(contentHandler, errorHandler);
    }

    public void writeTo(XMLStreamWriter sw) throws XMLStreamException {
        this.writePayloadTo(sw);
    }

    private Node getNodeValue(Document d, String localName) {
        NodeList nl = d.getElementsByTagNameNS("", localName);
        Node n = nl != null && nl.getLength() > 0 ? nl.item(0).getFirstChild() : null;
        return n;
    }

    public void wrapFault(String operationName, EndpointMetaData emd) {
        Node faultDetail;
        if (JavaEEServiceEngineContext.getInstance().isServiceMix()) {
            if (this.log) {
                logger.log(Level.FINE, "Skipping the wrapping...");
            }
            this.wrappedMessage = this.abstractMessage.readPayloadAsSource();
            return;
        }
        DOMResult result = new DOMResult();
        try {
            Transformer t = TF.newTransformer();
            t.transform(this.abstractMessage.readPayloadAsSource(), result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
        Document d = (Document)result.getNode();
        if (this.log) {
            logger.log(Level.FINE, "Fault received from JAX-WS : " + UnWrappedMessage.toString(d));
        }
        if ((faultDetail = this.getNodeValue(d, "detail")) == null) {
            logger.log(Level.WARNING, "RuntimeException thrown from the JAX-WS. No <detail> found.");
            RuntimeException rt_ex = new RuntimeException("RuntimeException thrown from the JAX-WS. No details found.");
            rt_ex.setStackTrace(new StackTraceElement[0]);
            throw rt_ex;
        }
        javax.wsdl.Message wsdlMsg = null;
        String wsdlMessageName = null;
        try {
            Fault fault = emd.getFault(operationName, faultDetail.getLocalName(), faultDetail.getNamespaceURI());
            if (fault != null) {
                wsdlMsg = fault.getMessage();
                wsdlMessageName = fault.getName();
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, ex.getMessage(), ex);
        }
        if (wsdlMsg == null) {
            logger.log(Level.WARNING, "RuntimeException thrown from the Application. Fault is not defined in the WSDL");
            Node n = this.getNodeValue(d, "faultstring");
            Node m = this.getNodeValue(d, "message");
            String exMsg = m != null ? m.getTextContent() : n.getTextContent();
            RuntimeException rt_ex = new RuntimeException(exMsg);
            rt_ex.setStackTrace(new StackTraceElement[0]);
            throw rt_ex;
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XMLStreamWriter writer = XOF.createXMLStreamWriter(baos, "UTF-8");
            writer.writeStartDocument();
            this.wsdlMessageType = wsdlMsg.getQName();
            writer.writeStartElement("jbi:message");
            this.writeMessageAttributes(writer, wsdlMessageName);
            writer.writeStartElement("jbi:part");
            writer.writeCharacters("");
            DOMUtil.UTIL.writeNode(faultDetail, writer);
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.flush();
            this.setMessage(baos.toByteArray());
            if (this.log) {
                logger.log(Level.FINE, "\n\nWrapped fault = " + baos.toString() + "\n\n");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class RPCStyleWrapper {
        RPCStyleWrapper() {
        }

        void wrap() throws Exception {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                XMLStreamWriter writer = JBIConstants.XOF.createXMLStreamWriter(baos, "UTF-8");
                WrappedMessage.this.writeJBIHeader(writer);
                XMLStreamReader payLoad = WrappedMessage.this.abstractMessage.readPayload();
                if (payLoad.getEventType() == 7) {
                    payLoad.next();
                }
                HashMap<String, String> payLoadNSAttrs = new HashMap<String, String>();
                this.copyNamespaceAttributes(payLoad, payLoadNSAttrs);
                payLoad.next();
                this.copyNamespaceAttributes(payLoad, payLoadNSAttrs);
                if (WrappedMessage.this.log) {
                    logger.log(Level.FINE, "Payload namespace attributes = " + payLoadNSAttrs);
                }
                this.writeJBIParts(payLoad, writer, payLoadNSAttrs);
                WrappedMessage.this.writeJBIFooter(writer);
                WrappedMessage.this.setMessage(baos.toByteArray());
                if (WrappedMessage.this.log) {
                    logger.log(Level.FINE, "\n\nWrapped message = " + baos.toString() + "\n\n");
                }
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }

        private void copyNamespaceAttributes(XMLStreamReader reader, Map<String, String> m) throws Exception {
            for (int i = 0; i < reader.getNamespaceCount(); ++i) {
                m.put(reader.getNamespacePrefix(i), reader.getNamespaceURI(i));
            }
        }

        private void writeJBIParts(XMLStreamReader payLoad, XMLStreamWriter writer, Map<String, String> ancestorNamespaceAttrs) throws Exception {
            if (WrappedMessage.this.log) {
                logger.log(Level.FINE, "Number of parts = " + WrappedMessage.this.wsdlPartBindings.length);
            }
            int headerIndex = 0;
            block5: for (int partIndex = 0; partIndex < WrappedMessage.this.wsdlPartBindings.length && payLoad.hasNext(); ++partIndex) {
                switch (WrappedMessage.this.wsdlPartBindings[partIndex]) {
                    case 1: {
                        if (WrappedMessage.this.log) {
                            logger.log(Level.FINE, "Adding part number " + partIndex + " from header");
                        }
                        writer.writeStartElement("jbi:part");
                        writer.writeCharacters("");
                        writer.flush();
                        WrappedMessage.this.abstractMessage.getHeaders().get(headerIndex++).writeTo(writer);
                        writer.writeEndElement();
                        continue block5;
                    }
                    case 0: {
                        if (WrappedMessage.this.log) {
                            logger.log(Level.FINE, "Adding part number " + partIndex + " from payLoad");
                        }
                        writer.writeStartElement("jbi:part");
                        DOMUtil.UTIL.writeChildren(payLoad, writer, ancestorNamespaceAttrs);
                        writer.writeEndElement();
                        continue block5;
                    }
                    case 2: {
                        if (!WrappedMessage.this.log) continue block5;
                        logger.log(Level.FINE, "Part number " + partIndex + " is an attachment");
                    }
                }
            }
        }

        private boolean isSimpleType(Part part) {
            String s;
            QName parttype = part.getTypeName();
            return parttype != null && (s = parttype.getNamespaceURI()) != null && s.trim().equals("http://www.w3.org/2001/XMLSchema");
        }
    }

    class DocumentStyleWrapper {
        DocumentStyleWrapper() {
        }

        void wrap() {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                XMLStreamWriter writer = JBIConstants.XOF.createXMLStreamWriter(baos, "UTF-8");
                WrappedMessage.this.writeJBIHeader(writer);
                int headerIndex = 0;
                block7: for (int i = 0; i < WrappedMessage.this.wsdlPartBindings.length; ++i) {
                    switch (WrappedMessage.this.wsdlPartBindings[i]) {
                        case 0: {
                            if (WrappedMessage.this.log) {
                                logger.log(Level.FINE, "Adding part number " + i + " from payLoad");
                            }
                            if (!WrappedMessage.this.abstractMessage.hasPayload()) continue block7;
                            writer.writeStartElement("jbi:part");
                            writer.writeCharacters("");
                            WrappedMessage.this.writePayloadTo(writer);
                            writer.writeEndElement();
                            continue block7;
                        }
                        case 1: {
                            if (WrappedMessage.this.log) {
                                logger.log(Level.FINE, "Adding part number " + i + " from header");
                            }
                            writer.writeStartElement("jbi:part");
                            writer.writeCharacters("");
                            writer.flush();
                            WrappedMessage.this.abstractMessage.getHeaders().get(headerIndex++).writeTo(writer);
                            writer.writeEndElement();
                            continue block7;
                        }
                        case 2: {
                            if (!WrappedMessage.this.log) continue block7;
                            logger.log(Level.FINE, "Part number " + i + " is an attachment");
                        }
                    }
                }
                WrappedMessage.this.writeJBIFooter(writer);
                WrappedMessage.this.setMessage(baos.toByteArray());
                if (WrappedMessage.this.log) {
                    logger.log(Level.FINE, "\n\nWrapped message = " + baos.toString() + "\n\n");
                }
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
    }
}

