/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc;

import com.sun.jbi.httpsoapbc.NodeListImpl;
import com.sun.jbi.httpsoapbc.OperationMetaData;
import com.sun.jbi.httpsoapbc.util.DebugLog;
import com.sun.jbi.httpsoapbc.util.HttpGetStringUtil;
import com.sun.jbi.httpsoapbc.util.Util;
import com.sun.jbi.internationalization.Messages;
import com.sun.jbi.nms.wsdl11wrapper.HelperFactory;
import com.sun.jbi.nms.wsdl11wrapper.WrapperBuilder;
import com.sun.jbi.nms.wsdl11wrapper.WrapperProcessingException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.ws.handler.MessageContext;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlGetNormalizer {
    private static final String SOAP_HEADERS_PROPERTY = "com.sun.jbi.headers.soap";
    private static final String HTTP_HEADERS_PROPERTY = "com.sun.jbi.headers.http";
    private static Messages mMessages = Messages.getMessages(XmlGetNormalizer.class);
    private static Logger mLog = Messages.getLogger(XmlGetNormalizer.class);
    private static TransformerFactory cTransformerFactory = TransformerFactory.newInstance();
    private static final String URL_DECODE_ENCODING = "UTF-8";
    private final URLDecoder mUrlDecoder;
    private final DocumentBuilder mBuilder;
    private final WrapperBuilder wrapperBuilder;
    private boolean mIsHeaderCopyEnabled = false;

    public XmlGetNormalizer() throws MessagingException {
        try {
            this.wrapperBuilder = HelperFactory.createBuilder();
        }
        catch (WrapperProcessingException ex) {
            throw new MessagingException("Failed to create wrapper builder", (Throwable)ex);
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            this.mBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new MessagingException("Failed to create document builder", (Throwable)ex);
        }
        this.mUrlDecoder = new URLDecoder();
    }

    private Document newDocument() throws ParserConfigurationException {
        Document doc = null;
        doc = this.mBuilder.newDocument();
        return doc;
    }

    public NormalizedMessage normalize(Object message, MessageExchange exchange, OperationMetaData meta, boolean inMsg, MessageContext context) throws MessagingException {
        MessageContext msgContext;
        NormalizedMessage normalMsg = exchange.createMessage();
        try {
            msgContext = (MessageContext)message;
        }
        catch (ClassCastException ex) {
            String msg = mMessages.getString("HTTPBC-E00797.Normalize_fail_wrong_type", new Object[]{MessageContext.class.toString(), message.getClass().toString()});
            throw new MessagingException(msg, (Throwable)ex);
        }
        try {
            Message msg;
            String name;
            if (inMsg) {
                name = meta.getInMsgName();
                msg = meta.getInputMessage();
            } else {
                name = meta.getOutMsgName();
                msg = meta.getOutputMessage();
            }
            Document normalDoc = this.newDocument();
            this.wrapperBuilder.initialize(normalDoc, msg, name);
            String queryString = (String)msgContext.get((Object)"javax.xml.ws.http.request.querystring");
            if ("".equals(queryString) || queryString == null) {
                queryString = (String)msgContext.get((Object)"javax.xml.ws.http.request.pathinfo");
            }
            Map<String, String> namesToValues = this.extractQuery(queryString, meta);
            Collection<Part> parts = msg.getParts().values();
            this.validateForCongruence(namesToValues, parts);
            if (!parts.isEmpty()) {
                for (Part p : parts) {
                    String localName = p.getName();
                    String value = namesToValues.get(localName);
                    Node node = Util.textAsDom(value);
                    if (node == null) {
                        node = normalDoc.createTextNode(value == null ? "" : value);
                    } else if (node instanceof Document) {
                        node = ((Document)node).getDocumentElement();
                    }
                    NodeListImpl nodeList = new NodeListImpl();
                    nodeList.addItem(node);
                    this.wrapperBuilder.addPart(p.getName(), (NodeList)nodeList);
                }
            }
            normalDoc = this.wrapperBuilder.getResult();
            if (this.mIsHeaderCopyEnabled && context != null && inMsg) {
                this.processHTTPRequestHeaders(normalMsg, context);
            }
            if (mLog.isLoggable(Level.FINE)) {
                DebugLog.debugLog(mLog, Level.FINE, "Normalized message", normalDoc);
            }
            normalMsg.setContent((Source)new DOMSource(normalDoc));
            return normalMsg;
        }
        catch (ParserConfigurationException tex) {
            throw new MessagingException("unable to obtain normalized message as a DOM document", (Throwable)tex);
        }
        catch (WrapperProcessingException ex) {
            String msg = mMessages.getString("HTTPBC-E00798.Normalize_fail");
            throw new MessagingException(msg, (Throwable)ex);
        }
        catch (TransformerConfigurationException e) {
            throw new MessagingException("unable to obtain normalized message as a DOM document", (Throwable)e);
        }
    }

    protected final Map<String, String> extractQuery(String queryString, OperationMetaData opMetaData) throws MessagingException {
        if ("urlEncoded".equals(opMetaData.getHttpUrlEncoding())) {
            return this.extractNameValuePairs(queryString);
        }
        if ("urlReplacement".equals(opMetaData.getHttpUrlEncoding())) {
            try {
                return HttpGetStringUtil.extractNameValuePairs(queryString, opMetaData.getHttpOperationLocation());
            }
            catch (HttpGetStringUtil.PatternMatchException ex) {
                String msg = mMessages.getString("HTTPBC-E00785.Url_replacement_failed_op_match", new Object[]{queryString, opMetaData.getHttpOperationLocation()});
                throw new MessagingException(msg);
            }
        }
        String msg = mMessages.getString("HTTPBC-E00756.Query_extract_encoding_unsupported", (Object)opMetaData.getHttpUrlEncoding());
        throw new MessagingException(msg);
    }

    protected final Map<String, String> extractNameValuePairs(String queryString) throws MessagingException {
        HashMap<String, String> nvMap = new HashMap<String, String>();
        if (queryString != null) {
            StringTokenizer nvTokenizer = new StringTokenizer(queryString, "&");
            while (nvTokenizer.hasMoreTokens()) {
                String nvPair = nvTokenizer.nextToken();
                StringTokenizer pairTokenizer = new StringTokenizer(nvPair, "=");
                if (pairTokenizer.countTokens() == 2) {
                    try {
                        String name = pairTokenizer.nextToken();
                        String value = pairTokenizer.nextToken();
                        nvMap.put(URLDecoder.decode(name, URL_DECODE_ENCODING), URLDecoder.decode(value, URL_DECODE_ENCODING));
                        continue;
                    }
                    catch (UnsupportedEncodingException e) {
                        String msg = mMessages.getString("HTTPBC-E00754.Query_encoding_unsupported", (Object)URL_DECODE_ENCODING);
                        throw new MessagingException(msg, (Throwable)e);
                    }
                }
                if (pairTokenizer.countTokens() <= 0) continue;
                String msg = mMessages.getString("HTTPBC-E00755.Query_invalid_segment", (Object)nvPair);
                throw new MessagingException(msg);
            }
        }
        return nvMap;
    }

    protected final void validateForCongruence(Map<String, String> namesToValues, Collection<Part> parts) throws MessagingException {
        int partsSize = parts.size();
        int nvSize = namesToValues.size();
        boolean valid = true;
        boolean bl = valid = partsSize == nvSize;
        if (valid) {
            int partsCount = 0;
            for (Part p : parts) {
                String partName = p.getName();
                if (!namesToValues.containsKey(partName)) continue;
                ++partsCount;
            }
            boolean bl2 = valid = partsCount == partsSize;
        }
        if (!valid) {
            String msg = mMessages.getString("HTTPBC-W00700.Query_part_message_parts_mismatch");
            if (mLog.isLoggable(Level.WARNING)) {
                mLog.log(Level.WARNING, msg);
            }
            if (mLog.isLoggable(Level.FINE)) {
                StringBuffer detail = new StringBuffer(msg).append("\n");
                detail.append("Message parts dump:").append("\n");
                for (Part p : parts) {
                    String partName = p.getName();
                    detail.append(partName).append("\n");
                }
                detail.append("\nQuery parts dump:").append("\n");
                Set<String> keys = namesToValues.keySet();
                for (String key : keys) {
                    String value = namesToValues.get(key);
                    detail.append(key).append(": ").append(value != null ? value : "").append("\n");
                }
                mLog.log(Level.FINE, detail.toString());
            }
            throw new MessagingException(msg);
        }
    }

    private void processHTTPRequestHeaders(NormalizedMessage normalMsg, MessageContext context) {
        HashMap<String, String> httpHeadersProperty = (HashMap<String, String>)normalMsg.getProperty(HTTP_HEADERS_PROPERTY);
        if (httpHeadersProperty == null) {
            httpHeadersProperty = new HashMap<String, String>();
            normalMsg.setProperty(HTTP_HEADERS_PROPERTY, httpHeadersProperty);
        }
        Map requestHeaders = (Map)context.get((Object)"javax.xml.ws.http.request.headers");
        for (Map.Entry entry : requestHeaders.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)((List)entry.getValue()).get(0);
            httpHeadersProperty.put(key, value);
        }
    }
}

