/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.common.descriptor.parsers;

import com.sun.jbi.common.descriptor.EndpointInfo;
import com.sun.jbi.common.descriptor.model.Connection;
import com.sun.jbi.common.xml.StackableParser;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionParser
extends StackableParser {
    private List<Connection> mConnections;
    private EndpointInfo mConsumer;
    private EndpointInfo mProvider;

    public ConnectionParser() {
        this(null, new ArrayList<Connection>());
    }

    protected ConnectionParser(ConnectionParser cp) {
        this(cp.getParent(), cp.mConnections);
    }

    protected ConnectionParser(StackableParser cp, List<Connection> cons) {
        super(cp);
        this.mConnections = cons;
    }

    @Override
    public StackableParser newInstance(StackableParser parent) {
        if (parent != this) {
            return super.newInstance(parent);
        }
        return new ConnectionParser(this);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ((qName = this.stripPrefix(qName)).equals("consumer")) {
            this.mConsumer = this.resolveEndpoint(attributes, false);
            this.setValue(this.mConsumer);
        } else if (qName.equals("provider")) {
            this.mProvider = this.resolveEndpoint(attributes, true);
            this.setValue(this.mProvider);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ((qName = this.stripPrefix(qName)).equals("connection")) {
            this.acceptValue(new Connection(this.mConsumer, this.mProvider));
            this.mConsumer = null;
            this.mProvider = null;
        }
    }

    public Connection[] getConnections() {
        Connection[] result = new Connection[this.mConnections.size()];
        this.mConnections.toArray(result);
        return result;
    }

    @Override
    protected void acceptValue(Object obj) {
        if (obj instanceof EndpointInfo) {
            EndpointInfo info = (EndpointInfo)obj;
            if (info.isProvides()) {
                this.mProvider = info;
            } else {
                this.mConsumer = info;
            }
        } else if (obj instanceof Connection) {
            this.mConnections.add((Connection)obj);
        }
    }

    protected EndpointInfo getConsumer() {
        return this.mConsumer;
    }

    protected EndpointInfo getProvider() {
        return this.mProvider;
    }
}

