name=vm-idlet17
dev1=/dev/vgt17/lvt17idle
dev2=/dev/vgt17/lvt17idle-data
vnc_port='6200'
monitor_port='13100'
serial_port='14100'
macaddr=00:50:56:78:00:64
alt_macaddr=00:50:57:78:00:64
bridge=br0
cpus=1
mem=1024
numactl --preferred=1 --cpunodebind=1  /usr/libexec/qemu-kvm -name $name -M rhel6.0.0 -enable-kvm\
    -drive file=$dev1,if=virtio,boot=on,cache=none\
    -drive file=$dev2,if=virtio,boot=off,cache=none\
    -netdev tap,id=idlet17,ifname=idlet17,script=/etc/kvm/qemu-ifup-$bridge,vhost=off\
    -device virtio-net-pci,netdev=idlet17,mac=$macaddr\
    -m $mem \
    -vnc :$vnc_port\
    -cpu qemu64,+x2apic -no-kvm-pit-reinjection\
    -smp $cpus,sockets=$cpus,cores=1,threads=1\
    -monitor telnet::$monitor_port,server,nowait\
    -serial telnet::$serial_port,server,nowait\
    -daemonize
