name=vg-dbt17
dev1=/dev/vgt17/lvt17db
dev2=/dev/vgt17/lvt17db-data
vnc_port='6199'
monitor_port='13099'
serial_port='14099'
macaddr=00:50:58:78:00:63
alt_macaddr=00:50:59:78:00:63
bridge=br0
cpus=1
mem=2048
numactl --preferred=1 --cpunodebind=1  /usr/libexec/qemu-kvm -name $name -M rhel6.0.0 -enable-kvm\
    -drive file=$dev1,if=virtio,boot=on,cache=none\
    -drive file=$dev2,if=virtio,boot=off,cache=none\
    -netdev tap,id=dbt17,ifname=dbt17,script=/etc/kvm/qemu-ifup-$bridge,vhost=off\
    -device virtio-net-pci,netdev=dbt17,mac=$macaddr\
    -pcidevice host=0e:11.5\
    -m $mem \
    -vnc :$vnc_port\
    -cpu qemu64,+x2apic -no-kvm-pit-reinjection\
    -smp $cpus,sockets=$cpus,cores=1,threads=1\
    -monitor telnet::$monitor_port,server,nowait\
    -serial telnet::$serial_port,server,nowait\
    -daemonize
