name=vg-dbt18
dev1=/dev/vgt18/lvt18db
dev2=/dev/vgt18/lvt18db-data
vnc_port='6205'
monitor_port='13105'
serial_port='14105'
macaddr=00:50:58:78:00:69
alt_macaddr=00:50:59:78:00:69
bridge=br0
cpus=1
mem=2048
numactl --preferred=2 --cpunodebind=2  /usr/libexec/qemu-kvm -name $name -M rhel6.0.0 -enable-kvm\
    -drive file=$dev1,if=virtio,boot=on,cache=none\
    -drive file=$dev2,if=virtio,boot=off,cache=none\
    -netdev tap,id=dbt18,ifname=dbt18,script=/etc/kvm/qemu-ifup-$bridge,vhost=off\
    -device virtio-net-pci,netdev=dbt18,mac=$macaddr\
    -pcidevice host=0e:12.5\
    -m $mem \
    -vnc :$vnc_port\
    -cpu qemu64,+x2apic -no-kvm-pit-reinjection\
    -smp $cpus,sockets=$cpus,cores=1,threads=1\
    -monitor telnet::$monitor_port,server,nowait\
    -serial telnet::$serial_port,server,nowait\
    -daemonize
