name=vg-dbt28
dev1=/dev/vgt28/lvt28db
dev2=/dev/vgt28/lvt28db-data
vnc_port='6265'
monitor_port='13165'
serial_port='14165'
macaddr=00:50:58:78:00:A5
alt_macaddr=00:50:59:78:00:A5
bridge=br0
cpus=1
mem=2048
numactl --preferred=4 --cpunodebind=4  /usr/libexec/qemu-kvm -name $name -M rhel6.0.0 -enable-kvm\
    -drive file=$dev1,if=virtio,boot=on,cache=none\
    -drive file=$dev2,if=virtio,boot=off,cache=none\
    -netdev tap,id=dbt28,ifname=dbt28,script=/etc/kvm/qemu-ifup-$bridge,vhost=off\
    -device virtio-net-pci,netdev=dbt28,mac=$macaddr\
    -pcidevice host=0e:1c.5\
    -m $mem \
    -vnc :$vnc_port\
    -cpu qemu64,+x2apic -no-kvm-pit-reinjection\
    -smp $cpus,sockets=$cpus,cores=1,threads=1\
    -monitor telnet::$monitor_port,server,nowait\
    -serial telnet::$serial_port,server,nowait\
    -daemonize
