name=vg-dbt34
dev1=/dev/vgt34/lvt34db
dev2=/dev/vgt34/lvt34db-data
vnc_port='6301'
monitor_port='13201'
serial_port='14201'
macaddr=00:50:58:78:00:C9
alt_macaddr=00:50:59:78:00:C9
bridge=br0
cpus=1
mem=2048
numactl --preferred=2 --cpunodebind=2  /usr/libexec/qemu-kvm -name $name -M rhel6.0.0 -enable-kvm\
    -drive file=$dev1,if=virtio,boot=on,cache=none\
    -drive file=$dev2,if=virtio,boot=off,cache=none\
    -netdev tap,id=dbt34,ifname=dbt34,script=/etc/kvm/qemu-ifup-$bridge,vhost=off\
    -device virtio-net-pci,netdev=dbt34,mac=$macaddr\
    -pcidevice host=13:13.4\
    -m $mem \
    -vnc :$vnc_port\
    -cpu qemu64,+x2apic -no-kvm-pit-reinjection\
    -smp $cpus,sockets=$cpus,cores=1,threads=1\
    -monitor telnet::$monitor_port,server,nowait\
    -serial telnet::$serial_port,server,nowait\
    -daemonize
