/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jbi.serviceengine.core;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.jbi.serviceengine.util.soap.EndpointMetaData;
import com.sun.xml.ws.api.server.WSEndpoint;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.wsdl.Definition;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;

public class ServiceEngineEndpoint {
    private Document wsdlDocument;
    private EndpointMetaData endpointMetaData;
    private ServiceEndpoint jbiEndpoint;
    private WSEndpoint wsep = null;
    private WebServiceEndpoint endpointDesc;
    private String url;
    private String sei;
    private String implClass;
    private boolean jaxwsFlag;
    private boolean ejbType;
    private boolean enabled;
    private String contextRoot;
    private QName serviceName;
    private String endpointName;
    private String applicationName;
    private ClassLoader classLoader;

    public ServiceEngineEndpoint(WebServiceEndpoint endpointDesc, QName serviceName, String endpointName, String implClass, String contextRoot, boolean enabled) {
        this.serviceName = serviceName;
        this.endpointName = endpointName;
        this.endpointDesc = endpointDesc;
        this.setApplicationName(endpointDesc);
        this.url = endpointDesc.getEndpointAddressUri();
        this.ejbType = endpointDesc.implementedByEjbComponent();
        this.sei = endpointDesc.getServiceEndpointInterface();
        this.implClass = implClass;
        this.jaxwsFlag = endpointDesc.getWebService().getMappingFileUri() == null;
        this.enabled = enabled;
        this.contextRoot = contextRoot;
        this.classLoader = endpointDesc.getBundleDescriptor().getClassLoader();
    }

    public String getServiceEndpointInterface() {
        return this.sei;
    }

    public String getURI() {
        return this.url;
    }

    public boolean isImplementedByEJB() {
        return this.ejbType;
    }

    public String getImplementationClass() {
        return this.implClass;
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    public ServiceEndpoint getServiceEndpoint() {
        return this.jbiEndpoint;
    }

    public void setServiceEndpoint(ServiceEndpoint jbiEp) {
        this.jbiEndpoint = jbiEp;
    }

    public QName getServiceName() {
        return this.serviceName;
    }

    public String getEndpointName() {
        return this.endpointName;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean flag) {
        this.enabled = flag;
    }

    public boolean isJAXWSEndpoint() {
        return this.jaxwsFlag;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public WebServiceEndpoint getEndpointDesc() {
        return this.endpointDesc;
    }

    public Document getWsdlDocument() {
        return this.wsdlDocument;
    }

    public void setWsdlDocument(Document wsdlDocument) {
        this.wsdlDocument = wsdlDocument;
    }

    public EndpointMetaData getEndpointMetaData() {
        if (this.endpointMetaData == null) {
            this.initializeEndpointMetaData();
        }
        return this.endpointMetaData;
    }

    public void setEndpointMetaData(EndpointMetaData emd) {
        this.endpointMetaData = emd;
    }

    public WSEndpoint getWsep() {
        return this.wsep;
    }

    public void setWsep(WSEndpoint wsep) {
        this.wsep = wsep;
    }

    private synchronized void initializeEndpointMetaData() {
        if (this.endpointMetaData == null) {
            try {
                EndpointMetaData emd = new EndpointMetaData(this.readWSDLDefinition(), this.serviceName, this.endpointName);
                emd.resolve();
                this.endpointMetaData = emd;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private Definition readWSDLDefinition() throws Exception {
        WSDLFactory mFactory = WSDLFactory.newInstance();
        WSDLReader mReader = mFactory.newWSDLReader();
        return this.wsdlDocument != null ? mReader.readWSDL(this.wsdlDocument.getDocumentURI(), this.wsdlDocument) : mReader.readWSDL(this.endpointDesc.getWebService().getGeneratedWsdlFilePath());
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    private void setServiceName(QName svcName) {
        this.serviceName = svcName;
    }

    private void setEndpointName(String epName) {
        this.endpointName = epName;
    }

    private void setApplicationName(WebServiceEndpoint endpointDesc) {
        BundleDescriptor bundleDescriptor = endpointDesc.getBundleDescriptor();
        this.applicationName = bundleDescriptor.getModuleDescriptor().isStandalone() ? bundleDescriptor.getApplication().getRegistrationName() : bundleDescriptor.getModuleDescriptor().getArchiveUri();
    }
}

