/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jbi.serviceengine.bridge;

import com.sun.enterprise.jbi.serviceengine.ServiceEngineException;
import com.sun.enterprise.jbi.serviceengine.bridge.JBIAdapterBuilder;
import com.sun.enterprise.jbi.serviceengine.bridge.transport.JBIAdapter;
import com.sun.enterprise.jbi.serviceengine.comm.MessageProcessor;
import com.sun.enterprise.jbi.serviceengine.core.DescriptorEndpointInfo;
import com.sun.enterprise.jbi.serviceengine.core.EndpointRegistry;
import java.util.logging.Level;
import javax.jbi.messaging.MessageExchange;
import javax.xml.namespace.QName;

public class JAXWSMessageProcessor
extends MessageProcessor {
    public void process() {
        this.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWork() {
        try {
            MessageExchange me = this.getMessageExchange();
            String endpointName = me.getEndpoint().getEndpointName();
            QName service = me.getEndpoint().getServiceName();
            String key = DescriptorEndpointInfo.getDEIKey(service, endpointName);
            DescriptorEndpointInfo dei = EndpointRegistry.getInstance().getWSDLEndpts().get(key);
            if (dei != null) {
                service = dei.getServiceName();
                endpointName = dei.getEndpointName();
            }
            JBIAdapterBuilder builder = new JBIAdapterBuilder();
            JBIAdapter jbiAdapter = null;
            try {
                this.debug(Level.FINE, "serviceengine.process_incoming_request", new Object[]{service.getLocalPart(), endpointName});
                jbiAdapter = builder.createAdapter(service, endpointName, me);
                Thread curThread = Thread.currentThread();
                if (jbiAdapter != null) {
                    ClassLoader currentLoader = curThread.getContextClassLoader();
                    try {
                        curThread.setContextClassLoader(jbiAdapter.getClassLoader());
                        jbiAdapter.handle();
                    }
                    finally {
                        curThread.setContextClassLoader(currentLoader);
                    }
                } else {
                    logger.log(Level.WARNING, "Endpoint [" + endpointName + "] not registered");
                }
                this.debug(Level.FINE, "serviceengine.success_incoming_request", new Object[]{service.getLocalPart(), endpointName});
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, "serviceengine.error_incoming_request", e);
                ServiceEngineException seException = new ServiceEngineException(e);
                if (jbiAdapter != null) {
                    jbiAdapter.handleException((Exception)seException);
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "JavaEEServiceEngine : Error processing request" + e, e);
        }
    }

    private void debug(Level logLevel, String msgID, Object[] params) {
        logger.log(logLevel, msgID, params);
    }
}

