/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jbi.serviceengine.core;

import com.sun.enterprise.jbi.serviceengine.core.JavaEEDeployer;
import com.sun.enterprise.jbi.serviceengine.core.JavaEEServiceEngineContext;
import com.sun.enterprise.webservice.ServiceEngineUtil;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.component.ComponentLifeCycle;
import javax.management.ObjectName;

public class JavaEEServiceEngineLifeCycle
implements ComponentLifeCycle {
    private JavaEEServiceEngineContext context;
    private ComponentContext jbiContext;
    private Thread managerThread;
    protected static final Logger logger = LogDomains.getLogger((String)"javax.enterprise.system");

    public ObjectName getExtensionMBeanName() {
        return null;
    }

    public void init(ComponentContext jbiContext) throws JBIException {
        this.jbiContext = jbiContext;
    }

    public void shutDown() throws JBIException {
    }

    public void start() throws JBIException {
        try {
            if (ServiceEngineUtil.isServiceEngineEnabled()) {
                logger.log(Level.FINE, "Service Engine starting");
                this.context = JavaEEServiceEngineContext.getInstance();
                this.context.setJBIContext(this.jbiContext);
                this.context.initialize();
                if (this.context.isSunESB()) {
                    this.jbiContext.getMBeanServer().registerMBean(new JavaEEDeployer(), this.jbiContext.getMBeanNames().createCustomComponentMBeanName("JavaEEDeployer"));
                    logger.log(Level.FINE, "Successfully registered JavaEEDeployer.");
                }
                this.managerThread = new Thread(this.context.getWorkManager());
                this.managerThread.start();
                logger.log(Level.INFO, "serviceengine.success_start");
            } else {
                logger.log(Level.INFO, "Java EE Service Engine is not active as it is disabled by setting the JVM flag com.sun.enterprise.jbi.se.disable to true");
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "serviceengine.error_start", new Object[]{e.getMessage()});
            throw new JBIException(e.getMessage());
        }
    }

    public void stop() throws JBIException {
        try {
            if (ServiceEngineUtil.isServiceEngineEnabled()) {
                this.context.getDeliveryChannel().close();
                this.context.getWorkManager().stop();
                this.managerThread.join();
                if (this.context.isSunESB()) {
                    this.jbiContext.getMBeanServer().unregisterMBean(this.jbiContext.getMBeanNames().createCustomComponentMBeanName("JavaEEDeployer"));
                }
                logger.log(Level.INFO, "serviceengine.success_stop");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JBIException(e.getMessage());
        }
    }
}

