/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc.extensions;

import com.ibm.wsdl.util.xml.DOMUtils;
import com.sun.jbi.httpsoapbc.configuration.RuntimeConfigurationMBean;
import com.sun.jbi.httpsoapbc.extensions.AccessManagerValidation;
import com.sun.jbi.httpsoapbc.extensions.BasicAuthenticationDetail;
import com.sun.jbi.httpsoapbc.extensions.MustSupportBasicAuthentication;
import com.sun.jbi.httpsoapbc.extensions.Policy;
import com.sun.jbi.httpsoapbc.extensions.PolicyReference;
import com.sun.jbi.httpsoapbc.extensions.RealmValidation;
import com.sun.jbi.httpsoapbc.extensions.StringCompareValidation;
import com.sun.jbi.internationalization.Messages;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionDeserializer;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SOAPExtSerializer
implements ExtensionSerializer,
ExtensionDeserializer,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Messages mMessages = Messages.getMessages(SOAPExtSerializer.class);
    private static final String WSP_NAMESPACE = "http://schemas.xmlsoap.org/ws/2004/09/policy";
    private static final String SP_NAMESPACE = "http://schemas.xmlsoap.org/ws/2005/07/securitypolicy";
    private static final String MY_SP_NAMESPACE = "http://sun.com/ws/httpbc/security/BasicauthSecurityPolicy";
    private static final String WSU_NAMESPACE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";
    private static final String USER_TOKEN_NAME_SPACE = "http://schemas.xmlsoap.org/ws/2005/07/securitypolicy/IncludeToken/AlwaysToRecipient";
    private RuntimeConfigurationMBean mRuntimeConfig = null;
    private Map mApplicationVariablesMap = null;
    private boolean mResolveTokens = false;

    public SOAPExtSerializer(RuntimeConfigurationMBean runtimeConfig, boolean resolveTokens) {
        this.mRuntimeConfig = runtimeConfig;
        this.mApplicationVariablesMap = runtimeConfig.retrieveApplicationVariablesMap();
        this.mResolveTokens = resolveTokens;
    }

    public void registerSerializer(ExtensionRegistry registry) {
        registry.registerSerializer(Port.class, PolicyReference.QNAME_ADDRESS, (ExtensionSerializer)this);
        registry.registerDeserializer(Port.class, PolicyReference.QNAME_ADDRESS, (ExtensionDeserializer)this);
        registry.mapExtensionTypes(Port.class, PolicyReference.QNAME_ADDRESS, PolicyReference.class);
        registry.registerSerializer(Definition.class, Policy.QNAME_ADDRESS, (ExtensionSerializer)this);
        registry.registerDeserializer(Definition.class, Policy.QNAME_ADDRESS, (ExtensionDeserializer)this);
        registry.mapExtensionTypes(Definition.class, Policy.QNAME_ADDRESS, Policy.class);
    }

    public void marshall(Class parentType, QName elementType, ExtensibilityElement extension, PrintWriter pw, Definition def, ExtensionRegistry extReg) throws WSDLException {
        String spNs;
        String wspNs = def.getPrefix(WSP_NAMESPACE) != null && !def.getPrefix(WSP_NAMESPACE).equals("") ? def.getPrefix(WSP_NAMESPACE) : "wsp";
        String myspNs = def.getPrefix(MY_SP_NAMESPACE) != null && !def.getPrefix(MY_SP_NAMESPACE).equals("") ? def.getPrefix(MY_SP_NAMESPACE) : "mysp";
        String wsuNs = def.getPrefix(WSU_NAMESPACE) != null && !def.getPrefix(WSU_NAMESPACE).equals("") ? def.getPrefix(WSU_NAMESPACE) : "wsu";
        String string = spNs = def.getPrefix(SP_NAMESPACE) != null && !def.getPrefix(SP_NAMESPACE).equals("") ? def.getPrefix(SP_NAMESPACE) : "sp";
        if (extension instanceof Policy) {
            Policy policy = (Policy)extension;
            pw.print("<" + wspNs + ":Policy");
            String policyId = policy.getID();
            if (policyId != null && !policyId.equals("")) {
                DOMUtils.printAttribute((String)(wsuNs + ":Id"), (String)policyId, (PrintWriter)pw);
            }
            pw.print(">");
            if (policy.getMustSupportBasicAuthentication() != null) {
                MustSupportBasicAuthentication msba = policy.getMustSupportBasicAuthentication();
                pw.print("<" + myspNs + ":MustSupportBasicAuthentication");
                String authEnabled = msba.getAuthEnabled() == Boolean.TRUE ? "true" : "false";
                DOMUtils.printAttribute((String)"on", (String)authEnabled, (PrintWriter)pw);
                pw.print(">");
                if (policy.getBasicAuthenticationDetail() != null) {
                    boolean useUserNameToken = false;
                    BasicAuthenticationDetail detail = policy.getBasicAuthenticationDetail();
                    pw.print("<" + myspNs + ":BasicAuthenticationDetail>");
                    BasicAuthenticationDetail.CredentialValidationType type = detail.getCredentialValidationType();
                    if (type == BasicAuthenticationDetail.CredentialValidationType.StringCompare) {
                        useUserNameToken = true;
                        pw.print("<" + myspNs + ":WssTokenCompare/>");
                    } else if (type == BasicAuthenticationDetail.CredentialValidationType.AM) {
                        pw.print("<" + myspNs + ":AccessManager/>");
                    } else if (type == BasicAuthenticationDetail.CredentialValidationType.Realm) {
                        pw.print("<" + myspNs + ":Realm");
                        RealmValidation realm = (RealmValidation)detail.getCredentialValidation();
                        if (realm.getRealmName() != null) {
                            DOMUtils.printAttribute((String)"realmName", (String)realm.getRealmName(), (PrintWriter)pw);
                        }
                        pw.print("/>");
                    }
                    pw.print("</" + myspNs + ":BasicAuthenticationDetail>");
                    pw.print("</" + myspNs + ":MustSupportBasicAuthentication>");
                    if (useUserNameToken) {
                        pw.print("<" + myspNs + ":UsernameToken>");
                        DOMUtils.printAttribute((String)(myspNs + ":IncludeToken"), (String)USER_TOKEN_NAME_SPACE, (PrintWriter)pw);
                        pw.println(">");
                        pw.print("<" + wspNs + ":Policy>");
                        pw.print("<" + spNs + ":WssUsernameToken10>");
                        StringCompareValidation stringCompare = (StringCompareValidation)policy.getBasicAuthenticationDetail().getCredentialValidation();
                        if (stringCompare.getUsername() != null) {
                            pw.print(stringCompare.getUsername());
                        }
                        pw.print("</" + spNs + ":WssUsernameToken10>");
                        if (stringCompare.getPassword() != null) {
                            pw.print("<" + spNs + ":WssPassword>******</" + spNs + ":WssPassword>");
                        }
                        pw.print("</" + wspNs + ":Policy>");
                        pw.print("</" + myspNs + ":UsernameToken>");
                    }
                }
            }
            pw.print("</" + wspNs + ":Policy>");
        } else if (extension instanceof PolicyReference) {
            PolicyReference pref = (PolicyReference)extension;
            pw.print("<" + wspNs + ":PolicyReference");
            String uri = pref.getURI();
            if (uri != null && !uri.equals("")) {
                DOMUtils.printAttribute((String)"URI", (String)uri, (PrintWriter)pw);
            }
            pw.println("/>");
        } else {
            ExtensionSerializer extSerializer = extReg.getDefaultSerializer();
            extSerializer.marshall(parentType, elementType, extension, pw, def, extReg);
        }
    }

    public ExtensibilityElement unmarshall(Class parentType, QName elementType, Element el, Definition def, ExtensionRegistry extReg) throws WSDLException {
        String URI2;
        if (Policy.QNAME_ADDRESS.equals(elementType)) {
            NodeList list;
            String wsuNs = def.getPrefix(WSU_NAMESPACE) != null && !def.getPrefix(WSU_NAMESPACE).equals("") ? def.getPrefix(WSU_NAMESPACE) : "wsu";
            String id = DOMUtils.getAttribute((Element)el, (String)(wsuNs + ":Id"));
            Policy pol = null;
            if (id != null && (list = el.getElementsByTagNameNS(Policy.NS_URI_BASIC_AUTHENTICATION_SECURITY_POLICY, "MustSupportBasicAuthentication")) != null && list.getLength() > 0) {
                Element passwordElem;
                NodeList passwordList;
                Element userElem;
                Node msbaNode = list.item(0);
                MustSupportBasicAuthentication msba = new MustSupportBasicAuthentication();
                NamedNodeMap attrs = msbaNode.getAttributes();
                Node onNode = attrs.getNamedItem("on");
                if (onNode != null) {
                    String on = onNode.getNodeValue();
                    msba.setAuthEnabled(on.equalsIgnoreCase("true") || on.equalsIgnoreCase("yes") || on.equalsIgnoreCase("1"));
                }
                BasicAuthenticationDetail bad = new BasicAuthenticationDetail();
                try {
                    this.getAuthenticationDetail(msbaNode, bad);
                }
                catch (Exception e) {
                    throw new WSDLException("INVALID_WSDL", e.getMessage(), (Throwable)e);
                }
                pol = new Policy();
                pol.setID(id);
                pol.setMustSupportBasicAuthentication(msba);
                pol.setBasicAuthenticationDetail(bad);
                NodeList userNameList = el.getElementsByTagNameNS(Policy.NS_URI_SECURITY_POLICY, "WssUsernameToken10");
                if (userNameList != null && (userElem = (Element)userNameList.item(0)) != null && userElem.getChildNodes().getLength() > 0) {
                    String username = userElem.getChildNodes().item(0).getNodeValue();
                    try {
                        if (this.isAToken(username)) {
                            String[] metadata;
                            String token = username;
                            String appVariableName = this.getApplicationVariableName(token);
                            if (!this.mResolveTokens) {
                                if (!this.mApplicationVariablesMap.containsKey(appVariableName)) {
                                    metadata = new String[]{null, "STRING"};
                                    this.mApplicationVariablesMap.put(appVariableName, metadata);
                                }
                            } else {
                                metadata = (String[])this.mApplicationVariablesMap.get(appVariableName);
                                if (metadata == null || metadata[0] == null) {
                                    throw new Exception(mMessages.getString("HTTPBC-E00252.Application_variable_not_defined", (Object)token));
                                }
                                pol.setUserName(metadata[0]);
                                if (bad.getCredentialValidation() instanceof StringCompareValidation) {
                                    StringCompareValidation scv = (StringCompareValidation)bad.getCredentialValidation();
                                    scv.setUsername(metadata[0]);
                                }
                            }
                        } else {
                            pol.setUserName(username);
                            if (bad.getCredentialValidation() instanceof StringCompareValidation) {
                                StringCompareValidation scv = (StringCompareValidation)bad.getCredentialValidation();
                                scv.setUsername(username);
                            }
                        }
                    }
                    catch (Exception e) {
                        throw new WSDLException("INVALID_WSDL", e.getMessage(), (Throwable)e);
                    }
                }
                if ((passwordList = el.getElementsByTagNameNS(Policy.NS_URI_SECURITY_POLICY, "WssPassword")) != null && (passwordElem = (Element)passwordList.item(0)) != null && passwordElem.getChildNodes().getLength() > 0) {
                    String password = passwordElem.getChildNodes().item(0).getNodeValue();
                    try {
                        if (this.isAToken(password)) {
                            String[] metadata;
                            String token = password;
                            String appVariableName = this.getApplicationVariableName(token);
                            if (!this.mResolveTokens) {
                                if (!this.mApplicationVariablesMap.containsKey(appVariableName)) {
                                    metadata = new String[]{null, "PASSWORD"};
                                    this.mApplicationVariablesMap.put(appVariableName, metadata);
                                }
                            } else {
                                metadata = (String[])this.mApplicationVariablesMap.get(appVariableName);
                                if (metadata == null || metadata[0] == null) {
                                    throw new Exception(mMessages.getString("HTTPBC-E00252.Application_variable_not_defined", (Object)token));
                                }
                                pol.setPassword(metadata[0]);
                                if (bad.getCredentialValidation() instanceof StringCompareValidation) {
                                    StringCompareValidation scv = (StringCompareValidation)bad.getCredentialValidation();
                                    scv.setPassword(metadata[0].toCharArray());
                                }
                            }
                        } else {
                            pol.setPassword(password);
                            if (bad.getCredentialValidation() instanceof StringCompareValidation) {
                                StringCompareValidation scv = (StringCompareValidation)bad.getCredentialValidation();
                                scv.setPassword(password.toCharArray());
                            }
                        }
                    }
                    catch (Exception e) {
                        throw new WSDLException("INVALID_WSDL", e.getMessage(), (Throwable)e);
                    }
                }
                if (bad.getCredentialValidationType() == BasicAuthenticationDetail.CredentialValidationType.StringCompare && (userNameList == null || passwordList == null)) {
                    throw new WSDLException("INVALID_WSDL", mMessages.getString("HTTPBC-E00256.WssTokenCompare_authentication_no_username_or_password"));
                }
                return pol;
            }
        }
        if (PolicyReference.QNAME_ADDRESS.equals(elementType) && (URI2 = DOMUtils.getAttribute((Element)el, (String)"URI")) != null) {
            PolicyReference pref = new PolicyReference();
            pref.setURI(URI2);
            return pref;
        }
        ExtensionDeserializer extDeserializer = extReg.getDefaultDeserializer();
        try {
            if (!this.mResolveTokens) {
                this.mRuntimeConfig.updateApplicationVariablesMap(this.mApplicationVariablesMap);
            }
        }
        catch (Exception e) {
            throw new WSDLException("OTHER_ERROR", mMessages.getString("HTTPBC-E00251.Application_variable_values_update_failed"), (Throwable)e);
        }
        return extDeserializer.unmarshall(parentType, elementType, el, def, extReg);
    }

    protected boolean isAToken(String name) throws Exception {
        boolean isToken = false;
        if (name.startsWith("${")) {
            if (name.endsWith("}")) {
                isToken = true;
            } else {
                throw new Exception(mMessages.getString("HTTPBC-E00253.Token_name_invalid", (Object)name));
            }
        }
        return isToken;
    }

    protected String getApplicationVariableName(String aToken) throws Exception {
        String tokenName = null;
        if (aToken == null || "".equals(aToken)) {
            throw new Exception(mMessages.getString("HTTPBC-E00253.Token_name_invalid", (Object)aToken));
        }
        tokenName = aToken.substring(2, aToken.length() - 1);
        if ("".equals(tokenName)) {
            throw new Exception(mMessages.getString("HTTPBC-E00253.Token_name_invalid", (Object)aToken));
        }
        return tokenName;
    }

    private void getAuthenticationDetail(Node mustSupportAuthNode, BasicAuthenticationDetail detail) throws Exception {
        if (mustSupportAuthNode != null) {
            NodeList list = mustSupportAuthNode.getChildNodes();
            if (list == null) {
                detail.setCredentialValidationType(BasicAuthenticationDetail.CredentialValidationType.StringCompare);
                detail.setCredentialValidation(new StringCompareValidation());
            } else {
                block0: for (int i = 0; i < list.getLength(); ++i) {
                    Element elem;
                    String elemLN;
                    Node cNode = list.item(i);
                    if (cNode.getNodeType() != 1 || !(elemLN = (elem = (Element)cNode).getLocalName()).equals("BasicAuthenticationDetail")) continue;
                    NodeList detailChildren = cNode.getChildNodes();
                    if (detailChildren == null) {
                        detail.setCredentialValidationType(BasicAuthenticationDetail.CredentialValidationType.StringCompare);
                        detail.setCredentialValidation(new StringCompareValidation());
                        continue;
                    }
                    for (int ii = 0; ii < detailChildren.getLength(); ++ii) {
                        Node detailChild = detailChildren.item(ii);
                        if (detailChild.getNodeType() != 1) continue;
                        Element dcelem = (Element)detailChild;
                        String dcelemLN = dcelem.getLocalName();
                        if (dcelemLN.equals("WssTokenCompare")) {
                            detail.setCredentialValidationType(BasicAuthenticationDetail.CredentialValidationType.StringCompare);
                            detail.setCredentialValidation(new StringCompareValidation());
                            continue block0;
                        }
                        if (dcelemLN.equals("AccessManager")) {
                            AccessManagerValidation am = new AccessManagerValidation();
                            detail.setCredentialValidationType(BasicAuthenticationDetail.CredentialValidationType.AM);
                            detail.setCredentialValidation(am);
                            continue block0;
                        }
                        if (!dcelemLN.equals("Realm")) continue;
                        RealmValidation rv = new RealmValidation();
                        NamedNodeMap attrs = detailChild.getAttributes();
                        Node realmNameNode = attrs.getNamedItem("realmName");
                        if (realmNameNode != null) {
                            String realmName = realmNameNode.getNodeValue();
                            if (this.isAToken(realmName)) {
                                String[] metadata;
                                String token = realmName;
                                String appVariableName = this.getApplicationVariableName(token);
                                if (!this.mResolveTokens) {
                                    if (!this.mApplicationVariablesMap.containsKey(appVariableName)) {
                                        metadata = new String[]{null, "STRING"};
                                        this.mApplicationVariablesMap.put(appVariableName, metadata);
                                    }
                                } else {
                                    metadata = (String[])this.mApplicationVariablesMap.get(appVariableName);
                                    if (metadata == null || metadata[0] == null) {
                                        throw new Exception(mMessages.getString("HTTPBC-E00252.Application_variable_not_defined", (Object)token));
                                    }
                                    rv.setRealmName(metadata[0]);
                                }
                            } else {
                                rv.setRealmName(realmName);
                            }
                        } else {
                            throw new Exception(mMessages.getString("HTTPBC-E00255.Realm_authentication_no_realm_name"));
                        }
                        detail.setCredentialValidationType(BasicAuthenticationDetail.CredentialValidationType.Realm);
                        detail.setCredentialValidation(rv);
                        continue block0;
                    }
                }
            }
        }
    }
}

