/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc.jaxwssupport;

import com.sun.jbi.httpsoapbc.Denormalizer;
import com.sun.jbi.httpsoapbc.Endpoint;
import com.sun.jbi.httpsoapbc.HttpSoapBindingLifeCycle;
import com.sun.jbi.httpsoapbc.HttpSoapComponentContext;
import com.sun.jbi.httpsoapbc.InboundMessageProcessor;
import com.sun.jbi.httpsoapbc.MessageExchangeSupport;
import com.sun.jbi.httpsoapbc.Normalizer;
import com.sun.jbi.httpsoapbc.OperationMetaData;
import com.sun.jbi.httpsoapbc.ReplyListener;
import com.sun.jbi.httpsoapbc.jaxwssupport.JAXWSXmlHttpDenormalizer;
import com.sun.jbi.httpsoapbc.jaxwssupport.JAXWSXmlHttpGetNormalizer;
import com.sun.jbi.httpsoapbc.jaxwssupport.JAXWSXmlHttpPostNormalizer;
import com.sun.jbi.httpsoapbc.util.DebugLog;
import com.sun.jbi.internationalization.Messages;
import com.sun.jbi.nms.exchange.ExchangePattern;
import com.sun.xml.ws.api.server.AsyncProvider;
import com.sun.xml.ws.api.server.AsyncProviderCallback;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataSource;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.ws.Service;
import javax.xml.ws.ServiceMode;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.WebServiceProvider;
import javax.xml.ws.handler.MessageContext;
import net.java.hulp.measure.Probe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebServiceProvider
@ServiceMode(value=Service.Mode.MESSAGE)
public class AsyncXmlHttpJBIProvider
implements AsyncProvider<DataSource>,
ReplyListener {
    private static final Messages mMessages = Messages.getMessages(AsyncXmlHttpJBIProvider.class);
    private static final Logger mLogger = Messages.getLogger(AsyncXmlHttpJBIProvider.class);
    private Endpoint targetEndpoint;
    private HttpSoapBindingLifeCycle lifeCycle = null;
    private ReplyListener replyListener;
    Map exchangeIDToContext = Collections.synchronizedMap(new HashMap());
    private static ThreadLocal processorSupport = new ThreadLocal(){

        protected Object initialValue() {
            return new HashMap();
        }
    };
    private static ThreadLocal cReplyDenormalizer = new ThreadLocal(){

        protected Object initialValue() {
            return new JAXWSXmlHttpDenormalizer();
        }
    };

    public AsyncXmlHttpJBIProvider(Endpoint endpoint) {
        this.targetEndpoint = endpoint;
        this.lifeCycle = (HttpSoapBindingLifeCycle)HttpSoapComponentContext.getInstance().getAssociatedLifeCycle();
        this.replyListener = this;
    }

    public void invoke(DataSource request, AsyncProviderCallback asyncProviderCallback, WebServiceContext webserviceContext) {
        if (mLogger.isLoggable(Level.FINE)) {
            mLogger.log(Level.FINE, "Processing SOAPMessage received in AsyncProvider. WebServiceContext: " + webserviceContext);
        }
        try {
            MessageContext context = webserviceContext.getMessageContext();
            String reqMethod = (String)context.get((Object)"javax.xml.ws.http.request.method");
            InboundMessageProcessor anInboundProcessor = new InboundMessageProcessor(this.getProcessorSupport((String)reqMethod).normalizer, this);
            anInboundProcessor.setInput(request);
            anInboundProcessor.setTargetEndpoint(this.targetEndpoint);
            anInboundProcessor.setMessageContext(context);
            String exchangeID = anInboundProcessor.execute(asyncProviderCallback);
        }
        catch (Exception e) {
            mLogger.log(Level.SEVERE, mMessages.getString("HTTPBC-W00625.Exception_during_request_processing"), e);
            asyncProviderCallback.sendError((Throwable)e);
        }
    }

    @Override
    public void setMessageExchangeId(String messageExchangeId, Object clientContext) {
        this.exchangeIDToContext.put(messageExchangeId, clientContext);
    }

    @Override
    public void removeMessageExchangeId(String messageExchangeId) {
        this.exchangeIDToContext.remove(messageExchangeId);
    }

    @Override
    public void onReply(MessageExchange exchange) throws MessagingException {
        DataSource response = null;
        MessageExchangeSupport.removeReplyListener(exchange.getExchangeId());
        AsyncProviderCallback asyncProviderCallback = (AsyncProviderCallback)this.exchangeIDToContext.remove(exchange.getExchangeId());
        Probe denormalizationMeasurement = null;
        try {
            String pattern = exchange.getPattern().toString().trim();
            if (exchange.getStatus() == ExchangeStatus.ACTIVE) {
                if (ExchangePattern.isInOut((MessageExchange)exchange)) {
                    String operation;
                    Map nameToMeta;
                    OperationMetaData operationMetaData;
                    InOut inout = (InOut)exchange;
                    NormalizedMessage outMsgOrFault = inout.getOutMessage();
                    if (outMsgOrFault == null) {
                        Fault aFault = exchange.getFault();
                        outMsgOrFault = aFault;
                    }
                    if (mLogger.isLoggable(Level.FINE)) {
                        if (outMsgOrFault != null) {
                            DebugLog.debugLog(mLogger, Level.FINE, "Denormalizing received msg", outMsgOrFault.getContent());
                        } else {
                            mLogger.log(Level.FINE, "Message received is empty.");
                        }
                    }
                    if ((operationMetaData = (OperationMetaData)(nameToMeta = this.targetEndpoint.getOperationNameToMetaData()).get(operation = exchange.getOperation().getLocalPart())) == null) {
                        String error = mMessages.getString("HTTPBC-E00667.No_opmeta_for_operation", (Object)exchange.getOperation());
                        throw new MessagingException(error);
                    }
                    Denormalizer denormalizer = (Denormalizer)cReplyDenormalizer.get();
                    denormalizationMeasurement = Probe.info(this.getClass(), (String)this.targetEndpoint.getUniqueName(), (String)"Denormalization");
                    response = (DataSource)denormalizer.denormalize(outMsgOrFault, exchange, response, operationMetaData);
                } else if (ExchangePattern.isInOnly((MessageExchange)exchange)) {
                    response = null;
                }
                if (mLogger.isLoggable(Level.FINE)) {
                    mLogger.log(Level.FINE, "Calling back JAX-WS asynchronously to proceed with response");
                }
                asyncProviderCallback.send(response);
            } else if (exchange.getStatus() == ExchangeStatus.DONE) {
                if (ExchangePattern.isInOnly((MessageExchange)exchange)) {
                    asyncProviderCallback.send(null);
                }
            } else if (exchange.getStatus() == ExchangeStatus.ERROR) {
                String errText;
                Exception errorDetail = null;
                if (exchange.getError() != null) {
                    errorDetail = exchange.getError();
                    errText = mMessages.getString("HTTPBC-E00720.Message_exchange_error", new Object[]{this.targetEndpoint.getServiceName(), this.targetEndpoint.getEndpointName(), errorDetail.getLocalizedMessage()});
                    errorDetail = new Exception(errText, errorDetail);
                } else {
                    errText = mMessages.getString("HTTPBC-E00721.Message_exchange_error_no_detail", new Object[]{this.targetEndpoint.getServiceName(), this.targetEndpoint.getEndpointName()});
                    errorDetail = new Exception(errText);
                }
                if (ExchangePattern.isInOut((MessageExchange)exchange)) {
                    Denormalizer denormalizer = (Denormalizer)cReplyDenormalizer.get();
                    response = (DataSource)denormalizer.denormalizeException(errorDetail, response);
                    if (mLogger.isLoggable(Level.FINE)) {
                        mLogger.log(Level.FINE, "Responding to JAX-WS with a fault");
                    }
                    asyncProviderCallback.send((Object)response);
                } else {
                    if (mLogger.isLoggable(Level.FINE)) {
                        mLogger.log(Level.FINE, "Responding to JAX-WS with the following error", errorDetail);
                    }
                    asyncProviderCallback.sendError((Throwable)errorDetail);
                }
            }
        }
        catch (MessagingException e) {
            if (mLogger.isLoggable(Level.WARNING)) {
                mLogger.log(Level.WARNING, mMessages.getString("HTTPBC-E00800.Failed_to_process_reply_from_jbi"), e);
            }
            asyncProviderCallback.sendError((Throwable)e);
            throw e;
        }
        finally {
            if (denormalizationMeasurement != null) {
                denormalizationMeasurement.end();
            }
        }
    }

    ProcessorSupport getProcessorSupport(String requestMethod) throws MessagingException {
        Map methodToProcessor = (Map)processorSupport.get();
        ProcessorSupport currentProcSupport = (ProcessorSupport)methodToProcessor.get(requestMethod);
        if (currentProcSupport == null) {
            currentProcSupport = new ProcessorSupport();
            if ("POST".equals(requestMethod)) {
                currentProcSupport.normalizer = new JAXWSXmlHttpPostNormalizer();
            } else if ("GET".equals(requestMethod) || requestMethod != null) {
                currentProcSupport.normalizer = new JAXWSXmlHttpGetNormalizer();
            } else {
                String msg = mMessages.getString("HTTPBC-E00632.No_support_for_request_method", (Object)requestMethod);
                throw new MessagingException(msg);
            }
            currentProcSupport.denormalizer = new JAXWSXmlHttpDenormalizer();
            currentProcSupport.inboundProcessor = new InboundMessageProcessor(currentProcSupport.normalizer, this);
            methodToProcessor.put(requestMethod, currentProcSupport);
        }
        return currentProcSupport;
    }

    static class ProcessorSupport {
        Normalizer normalizer;
        Denormalizer denormalizer;
        InboundMessageProcessor inboundProcessor;

        ProcessorSupport() {
        }
    }
}

