/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.component.jbiext;

import java.lang.reflect.Method;
import javax.jbi.component.ComponentContext;

public class KeyStoreUtilClient {
    private Object mKeyStoreUtil;

    public KeyStoreUtilClient(ComponentContext context) {
        if (context != null) {
            try {
                this.mKeyStoreUtil = this.invoke(context, "getKeyStoreUtil", null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void addKey(String keyName) throws Exception {
        if (this.mKeyStoreUtil != null) {
            this.invoke(this.mKeyStoreUtil, "addKey", keyName);
        }
    }

    public boolean hasKey(String keyName) throws Exception {
        if (this.mKeyStoreUtil != null) {
            Object retVal = this.invoke(this.mKeyStoreUtil, "hasKey", keyName);
            return (Boolean)retVal;
        }
        return false;
    }

    public void updateKey(String keyName) throws Exception {
        if (this.mKeyStoreUtil != null) {
            this.invoke(this.mKeyStoreUtil, "updateKey", keyName);
        }
    }

    public void deleteKey(String keyName) throws Exception {
        if (this.mKeyStoreUtil != null) {
            this.invoke(this.mKeyStoreUtil, "deleteKey", keyName);
        }
    }

    public String[] listKeyNames() throws Exception {
        if (this.mKeyStoreUtil != null) {
            return (String[])this.invoke(this.mKeyStoreUtil, "listKeyNames", null);
        }
        return new String[0];
    }

    public String getKey(String keyName) throws Exception {
        if (this.mKeyStoreUtil != null) {
            return (String)this.invoke(this.mKeyStoreUtil, "getKey", keyName);
        }
        return null;
    }

    public byte[] encrypt(String keyName, byte[] clearText) throws Exception {
        if (this.mKeyStoreUtil != null) {
            return (byte[])this.invoke(this.mKeyStoreUtil, "encrypt", keyName, clearText);
        }
        return clearText;
    }

    public byte[] decrypt(String keyName, byte[] cipherText) throws Exception {
        if (this.mKeyStoreUtil != null) {
            return (byte[])this.invoke(this.mKeyStoreUtil, "decrypt", keyName, cipherText);
        }
        return cipherText;
    }

    public String encrypt(String keyName, String clearText) throws Exception {
        if (this.mKeyStoreUtil != null) {
            return (String)this.invoke(this.mKeyStoreUtil, "encrypt", keyName, clearText);
        }
        return clearText;
    }

    public String decrypt(String keyName, String base64EncodedCipherText) throws Exception {
        if (this.mKeyStoreUtil != null) {
            return (String)this.invoke(this.mKeyStoreUtil, "mKeyStoreUtil", keyName, base64EncodedCipherText);
        }
        return base64EncodedCipherText;
    }

    public byte[] encrypt(byte[] clearText) throws Exception {
        if (this.mKeyStoreUtil != null) {
            return (byte[])this.invoke(this.mKeyStoreUtil, "encrypt", new Object[]{clearText});
        }
        return clearText;
    }

    public byte[] decrypt(byte[] cipherText) throws Exception {
        if (this.mKeyStoreUtil != null) {
            return (byte[])this.invoke(this.mKeyStoreUtil, "decrypt", new Object[]{cipherText});
        }
        return cipherText;
    }

    public String encrypt(String clearText) throws Exception {
        if (this.mKeyStoreUtil != null) {
            return (String)this.invoke(this.mKeyStoreUtil, "encrypt", clearText);
        }
        return clearText;
    }

    public String decrypt(String base64EncodedCipherText) throws Exception {
        if (this.mKeyStoreUtil != null) {
            return (String)this.invoke(this.mKeyStoreUtil, "decrypt", base64EncodedCipherText);
        }
        return base64EncodedCipherText;
    }

    public Object invoke(Object caller, String methodName, Object ... args) throws Exception {
        Class[] classArgs = null;
        if (args != null) {
            classArgs = new Class[args.length];
            for (int ii = 0; ii < args.length; ++ii) {
                classArgs[ii] = args[ii] != null ? args[ii].getClass() : null;
            }
        }
        Method callerMethod = caller.getClass().getMethod(methodName, classArgs);
        Object retVal = callerMethod.invoke(caller, args);
        return retVal;
    }
}

