/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.alerter;

import com.sun.jbi.alerter.EventImpl;
import com.sun.jbi.alerter.NotificationEvent;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NotificationEventImpl
extends EventImpl
implements NotificationEvent {
    static final long serialVersionUID = 5298513832820910083L;
    static String RCS_ID = "$Id: NotificationEventImpl.java,v 1.2 2007/10/04 00:07:08 reuven_damir Exp $";
    private long mId;
    private String mType;
    private int mSeverity;
    private String[] severityStrings = new String[]{"FATAL", "CRITICAL", "MAJOR", "MINOR", "WARNING", "INFO"};
    private int mOperationalState;
    private String[] opStateStrings = new String[]{"UNKNOWN", "STARTING", "SUSPENDING", "SUSPENDED", "STOPPING", "STOPPED", "RUNNING"};
    private String mMessageCode;
    private String[] mMessageCodeArgs;
    private String mMessageDetails;
    private int mObservationalState;
    private String[] obStateStrings = new String[]{"UNOBSERVED", "OBSERVED", "RESOLVED"};
    private boolean mListenersNotified;
    private static final Logger mLogger = Logger.getLogger(NotificationEventImpl.class.getName());
    private static boolean isDebugEnabled;

    public NotificationEventImpl() {
    }

    public NotificationEventImpl(String componentType, String componentProjectPathName, String componentName, long timeStamp) {
        super(componentType, componentProjectPathName, componentName, timeStamp);
    }

    public NotificationEventImpl(String physicalHostName, String environmentName, String logicalHostName, String serverType, String serverName, String componentType, String componentProjectPathName, String componentName, String type, int severity, int operationalState, String messageCode, String[] messageCodeArgs, String messageDetails) {
        super(physicalHostName, environmentName, logicalHostName, serverType, serverName, componentType, componentProjectPathName, componentName, new Date().getTime());
        this.mType = type;
        this.mSeverity = severity;
        this.mOperationalState = operationalState;
        this.mMessageCode = messageCode;
        this.mMessageCodeArgs = messageCodeArgs;
        this.mMessageDetails = messageDetails;
        this.mObservationalState = 0;
        this.mListenersNotified = false;
    }

    public long getId() {
        return this.mId;
    }

    public void setId(long id) {
        this.mId = id;
    }

    public String getType() {
        return this.mType;
    }

    public void setType(String type) {
        this.mType = type;
    }

    public int getSeverity() {
        return this.mSeverity;
    }

    public String getSeverityString(int severity) {
        if (severity >= 0 && severity < this.severityStrings.length) {
            return this.severityStrings[severity];
        }
        if (isDebugEnabled) {
            mLogger.finest("WARNING: getSeverityStrings: invalid index: " + severity);
        }
        return "";
    }

    public void setSeverity(int severity) {
        this.mSeverity = severity;
    }

    public String getMessageDetails() {
        return this.mMessageDetails;
    }

    public void setMessageDetails(String messageDetails) {
        this.mMessageDetails = messageDetails;
    }

    public int getOperationalState() {
        return this.mOperationalState;
    }

    public String getOpStateString(int opState) {
        if (opState >= 0 && opState < this.opStateStrings.length) {
            return this.opStateStrings[opState];
        }
        if (isDebugEnabled) {
            mLogger.finest("WARNING: getOpStateString: invalid index: " + opState);
        }
        return "";
    }

    public void setOperationalState(int operationalState) {
        this.mOperationalState = operationalState;
    }

    public int getObservationalState() {
        return this.mObservationalState;
    }

    public String getObStateString(int obState) {
        if (obState >= 0 && obState < this.obStateStrings.length) {
            return this.obStateStrings[obState];
        }
        if (isDebugEnabled) {
            mLogger.finest("WARNING: getObStateString: invalid index: " + obState);
        }
        return "";
    }

    public void setObservationalState(int observationalState) {
        this.mObservationalState = observationalState;
    }

    public boolean getListenersNotified() {
        return this.mListenersNotified;
    }

    public void setListenersNotified(boolean listenersNotified) {
        this.mListenersNotified = listenersNotified;
    }

    public String getMessageCode() {
        return this.mMessageCode;
    }

    public void setMessageCode(String messageCode) {
        this.mMessageCode = messageCode;
    }

    public String[] getMessageCodeArgs() {
        return this.mMessageCodeArgs;
    }

    public void setMessageCodeArgs(String[] messageCodeArgs) {
        this.mMessageCodeArgs = messageCodeArgs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NotificationEvent)) {
            return false;
        }
        NotificationEvent event = (NotificationEvent)o;
        if (this.mListenersNotified != event.getListenersNotified()) {
            return false;
        }
        if (this.mSeverity != event.getSeverity()) {
            return false;
        }
        if (this.mObservationalState != event.getObservationalState()) {
            return false;
        }
        if (this.mOperationalState != event.getOperationalState()) {
            return false;
        }
        if (this.mMessageCode != null ? !this.mMessageCode.equals(event.getMessageCode()) : event.getMessageCode() != null) {
            return false;
        }
        if (this.mType != null ? !this.mType.equals(event.getType()) : event.getType() != null) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.mMessageDetails != null ? !this.mMessageDetails.equals(event.getMessageDetails()) : event.getMessageDetails() != null) {
            return false;
        }
        if (this.mMessageCodeArgs == null) {
            if (event.getMessageCodeArgs() != null) {
                return false;
            }
        } else {
            if (this.mMessageCodeArgs.length != event.getMessageCodeArgs().length) {
                return false;
            }
            String[] messageCodeArgs = event.getMessageCodeArgs();
            for (int i = 0; i < this.mMessageCodeArgs.length; ++i) {
                if (this.mMessageCodeArgs[i].equals(messageCodeArgs[i])) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.mType != null ? this.mType.hashCode() : 0);
        result = 29 * result + this.mSeverity;
        result = 29 * result + this.mOperationalState;
        result = 29 * result + (this.mMessageCode != null ? this.mMessageCode.hashCode() : 0);
        if (this.mMessageCodeArgs == null) {
            result = 29 * result;
        } else {
            for (int i = 0; i < this.mMessageCodeArgs.length; ++i) {
                result = 29 * result + this.mMessageCodeArgs[i].hashCode();
            }
        }
        result = 29 * result + (this.mMessageDetails != null ? this.mMessageDetails.hashCode() : 0);
        result = 29 * result + this.mObservationalState;
        result = 29 * result + (this.mListenersNotified ? 1 : 0);
        return result;
    }

    public String toString() {
        String event = super.toString();
        StringBuffer sb = new StringBuffer();
        sb.append("\n\n\n");
        sb.append("\tAlert type:                ");
        sb.append(this.mType);
        sb.append("\n");
        sb.append("\tSeverity:                  ");
        sb.append(this.getSeverityString(this.mSeverity));
        sb.append("\n");
        sb.append("\tEvent ID:                  ");
        sb.append(this.mId);
        sb.append("\n");
        sb.append("\tOperational state:         ");
        sb.append(this.getOpStateString(this.mOperationalState));
        sb.append("\n");
        sb.append("\tMessage code:              ");
        sb.append(this.mMessageCode);
        sb.append("\n");
        sb.append("\tMessage details:           ");
        sb.append(this.mMessageDetails);
        sb.append("\n");
        sb.append("\tObservational state:       ");
        sb.append(this.getObStateString(this.mObservationalState));
        sb.append("\n");
        sb.append("\tListeners notified:        ");
        sb.append(this.mListenersNotified ? "True" : "False");
        sb.append("\n");
        sb.append(event);
        return sb.toString();
    }

    public String createQuery(String notificationType, String environmentName, String logicalHostName, String serverType, String serverName, String componentType, String componentProjectPathName, String componentName, Integer observationalState) {
        StringBuffer stmt = new StringBuffer("select * from NOTIFICATION_EVENT");
        StringBuffer whereStmt = new StringBuffer();
        int count = 1;
        if (notificationType != null) {
            whereStmt.append("notificationType = '" + notificationType + "'");
            ++count;
        }
        if (environmentName != null) {
            if (count > 1) {
                whereStmt.append(" and ");
            }
            whereStmt.append("environmentName = '" + environmentName + "'");
            ++count;
        }
        if (logicalHostName != null) {
            if (count > 1) {
                whereStmt.append(" and ");
            }
            whereStmt.append("logicalHostName = '" + logicalHostName + "'");
            ++count;
        }
        if (serverType != null) {
            if (count > 1) {
                whereStmt.append(" and ");
            }
            whereStmt.append("serverType = '" + serverType + "'");
            ++count;
        }
        if (serverName != null) {
            if (count > 1) {
                whereStmt.append(" and ");
            }
            whereStmt.append("serverName = '" + serverName + "'");
            ++count;
        }
        if (componentType != null) {
            if (count > 1) {
                whereStmt.append(" and ");
            }
            whereStmt.append("componentType = '" + componentType + "'");
            ++count;
        }
        if (componentProjectPathName != null) {
            if (count > 1) {
                whereStmt.append(" and ");
            }
            whereStmt.append("componentProjectPathName = '" + componentProjectPathName + "'");
            ++count;
        }
        if (componentName != null) {
            if (count > 1) {
                whereStmt.append(" and ");
            }
            whereStmt.append("componentName = '" + componentName + "'");
            ++count;
        }
        if (observationalState != null) {
            if (count > 1) {
                whereStmt.append(" and ");
            }
            whereStmt.append("observationalState = " + observationalState);
            ++count;
        }
        if (count > 1) {
            stmt.append(" where ");
            stmt.append(whereStmt.toString());
        }
        stmt.append(" order by timeStamp desc");
        return stmt.toString();
    }

    public String createQuery2(String notificationType, String deploymentName, String environmentName, String logicalHostName, String serverType, String serverName, String componentType, String componentProjectPathName, String componentName, Integer observationalState, String dateFrom, String dateTo, Integer severity, Integer operationalState, String messageDetail) {
        int count;
        StringBuffer whereStmt;
        StringBuffer stmt;
        block35: {
            long t;
            Date date;
            ParsePosition pos;
            SimpleDateFormat formatter;
            block34: {
                stmt = new StringBuffer("select * from NOTIFICATION_EVENT");
                whereStmt = new StringBuffer();
                count = 1;
                if (notificationType != null && notificationType.length() > 0) {
                    whereStmt.append("notificationType = '" + notificationType + "'");
                    ++count;
                }
                if (deploymentName != null && deploymentName.length() > 0) {
                    if (count > 1) {
                        whereStmt.append(" and ");
                    }
                    whereStmt.append("deploymentName = '" + deploymentName + "'");
                    ++count;
                }
                if (environmentName != null && environmentName.length() > 0) {
                    if (count > 1) {
                        whereStmt.append(" and ");
                    }
                    whereStmt.append("environmentName = '" + environmentName + "'");
                    ++count;
                }
                if (logicalHostName != null && logicalHostName.length() > 0) {
                    if (count > 1) {
                        whereStmt.append(" and ");
                    }
                    whereStmt.append("logicalHostName = '" + logicalHostName + "'");
                    ++count;
                }
                if (serverType != null && serverType.length() > 0) {
                    if (count > 1) {
                        whereStmt.append(" and ");
                    }
                    whereStmt.append("serverType = '" + serverType + "'");
                    ++count;
                }
                if (serverName != null && serverName.length() > 0) {
                    if (count > 1) {
                        whereStmt.append(" and ");
                    }
                    whereStmt.append("serverName = '" + serverName + "'");
                    ++count;
                }
                if (componentType != null && componentType.length() > 0) {
                    if (count > 1) {
                        whereStmt.append(" and ");
                    }
                    whereStmt.append("componentType = '" + componentType + "'");
                    ++count;
                }
                if (componentProjectPathName != null && componentProjectPathName.length() > 0) {
                    if (count > 1) {
                        whereStmt.append(" and ");
                    }
                    whereStmt.append("componentProjectPathName = '" + componentProjectPathName + "'");
                    ++count;
                }
                if (componentName != null && componentName.length() > 0) {
                    if (count > 1) {
                        whereStmt.append(" and ");
                    }
                    whereStmt.append("componentName = '" + componentName + "'");
                    ++count;
                }
                if (observationalState != null) {
                    if (count > 1) {
                        whereStmt.append(" and ");
                    }
                    whereStmt.append("observationalState = " + observationalState);
                    ++count;
                }
                if (dateFrom != null && dateFrom.length() > 0) {
                    try {
                        formatter = new SimpleDateFormat("MM/dd/yyyy");
                        pos = new ParsePosition(0);
                        date = formatter.parse(dateFrom, pos);
                        t = date.getTime();
                        if (count > 1) {
                            whereStmt.append(" and ");
                        }
                        whereStmt.append("timeStamp >= " + t);
                        ++count;
                    }
                    catch (Exception e) {
                        if (!mLogger.isLoggable(Level.SEVERE)) break block34;
                        mLogger.severe("Unable to parse dateFrom:" + dateFrom);
                    }
                }
            }
            if (dateTo != null && dateTo.length() > 0) {
                try {
                    formatter = new SimpleDateFormat("MM/dd/yyyy hh:mm:sss");
                    pos = new ParsePosition(0);
                    date = formatter.parse(dateTo + " 23:59:59", pos);
                    t = date.getTime();
                    if (count > 1) {
                        whereStmt.append(" and ");
                    }
                    whereStmt.append("timeStamp <= " + t);
                    ++count;
                }
                catch (Exception e) {
                    if (!mLogger.isLoggable(Level.SEVERE)) break block35;
                    mLogger.severe("Unable to parse dateTo:" + dateTo);
                }
            }
        }
        if (severity != null) {
            if (count > 1) {
                whereStmt.append(" and ");
            }
            whereStmt.append("severity <= " + severity);
            ++count;
        }
        if (operationalState != null) {
            if (count > 1) {
                whereStmt.append(" and ");
            }
            whereStmt.append("operationalState = " + operationalState);
            ++count;
        }
        if (messageDetail != null && messageDetail.length() > 0) {
            if (count > 1) {
                whereStmt.append(" and ");
            }
            whereStmt.append("messageDetail like '" + messageDetail + "%'");
            ++count;
        }
        if (count > 1) {
            stmt.append(" where ");
            stmt.append(whereStmt.toString());
        }
        stmt.append(" order by timeStamp desc");
        return stmt.toString();
    }

    public String createQuery2(String notificationType, String environmentName, String logicalHostName, String serverType, String serverName, String componentType, String componentProjectPathName, String componentName, Integer observationalState, String dateFrom, String dateTo, Integer severity, Integer operationalState, String messageDetail) {
        int count;
        StringBuffer whereStmt;
        StringBuffer stmt;
        block33: {
            long t;
            Date date;
            ParsePosition pos;
            SimpleDateFormat formatter;
            block32: {
                stmt = new StringBuffer("select * from NOTIFICATION_EVENT");
                whereStmt = new StringBuffer();
                count = 1;
                if (notificationType != null && notificationType.length() > 0) {
                    whereStmt.append("notificationType = '" + notificationType + "'");
                    ++count;
                }
                if (environmentName != null && environmentName.length() > 0) {
                    if (count > 1) {
                        whereStmt.append(" and ");
                    }
                    whereStmt.append("environmentName = '" + environmentName + "'");
                    ++count;
                }
                if (logicalHostName != null && logicalHostName.length() > 0) {
                    if (count > 1) {
                        whereStmt.append(" and ");
                    }
                    whereStmt.append("logicalHostName = '" + logicalHostName + "'");
                    ++count;
                }
                if (serverType != null && serverType.length() > 0) {
                    if (count > 1) {
                        whereStmt.append(" and ");
                    }
                    whereStmt.append("serverType = '" + serverType + "'");
                    ++count;
                }
                if (serverName != null && serverName.length() > 0) {
                    if (count > 1) {
                        whereStmt.append(" and ");
                    }
                    whereStmt.append("serverName = '" + serverName + "'");
                    ++count;
                }
                if (componentType != null && componentType.length() > 0) {
                    if (count > 1) {
                        whereStmt.append(" and ");
                    }
                    whereStmt.append("componentType = '" + componentType + "'");
                    ++count;
                }
                if (componentProjectPathName != null && componentProjectPathName.length() > 0) {
                    if (count > 1) {
                        whereStmt.append(" and ");
                    }
                    whereStmt.append("componentProjectPathName = '" + componentProjectPathName + "'");
                    ++count;
                }
                if (componentName != null && componentName.length() > 0) {
                    if (count > 1) {
                        whereStmt.append(" and ");
                    }
                    whereStmt.append("componentName = '" + componentName + "'");
                    ++count;
                }
                if (observationalState != null) {
                    if (count > 1) {
                        whereStmt.append(" and ");
                    }
                    whereStmt.append("observationalState = " + observationalState);
                    ++count;
                }
                if (dateFrom != null && dateFrom.length() > 0) {
                    try {
                        formatter = new SimpleDateFormat("MM/dd/yyyy");
                        pos = new ParsePosition(0);
                        date = formatter.parse(dateFrom, pos);
                        t = date.getTime();
                        if (count > 1) {
                            whereStmt.append(" and ");
                        }
                        whereStmt.append("timeStamp >= " + t);
                        ++count;
                    }
                    catch (Exception e) {
                        if (!mLogger.isLoggable(Level.SEVERE)) break block32;
                        mLogger.severe("Unable to parse dateFrom:" + dateFrom);
                    }
                }
            }
            if (dateTo != null && dateTo.length() > 0) {
                try {
                    formatter = new SimpleDateFormat("MM/dd/yyyy hh:mm:sss");
                    pos = new ParsePosition(0);
                    date = formatter.parse(dateTo + " 23:59:59", pos);
                    t = date.getTime();
                    if (count > 1) {
                        whereStmt.append(" and ");
                    }
                    whereStmt.append("timeStamp <= " + t);
                    ++count;
                }
                catch (Exception e) {
                    if (!mLogger.isLoggable(Level.SEVERE)) break block33;
                    mLogger.severe("Unable to parse dateTo:" + dateTo);
                }
            }
        }
        if (severity != null) {
            if (count > 1) {
                whereStmt.append(" and ");
            }
            whereStmt.append("severity <= " + severity);
            ++count;
        }
        if (operationalState != null) {
            if (count > 1) {
                whereStmt.append(" and ");
            }
            whereStmt.append("operationalState = " + operationalState);
            ++count;
        }
        if (messageDetail != null && messageDetail.length() > 0) {
            if (count > 1) {
                whereStmt.append(" and ");
            }
            whereStmt.append("messageDetail like '" + messageDetail + "%'");
            ++count;
        }
        if (count > 1) {
            stmt.append(" where ");
            stmt.append(whereStmt.toString());
        }
        stmt.append(" order by timeStamp desc");
        return stmt.toString();
    }

    public static void main(String[] args) {
        NotificationEventImpl event = new NotificationEventImpl();
    }
}

