/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jbi.serviceengine.bridge;

import com.sun.ejb.Container;
import com.sun.enterprise.jbi.serviceengine.ServiceEngineException;
import com.sun.enterprise.jbi.serviceengine.bridge.RuntimeEndpointInfoRegistryImpl;
import com.sun.enterprise.jbi.serviceengine.comm.MessageProcessor;
import com.sun.enterprise.jbi.serviceengine.util.soap.MessageExchangeHelper;
import com.sun.enterprise.webservice.Ejb2RuntimeEndpointInfo;
import com.sun.enterprise.webservice.EjbRuntimeEndpointInfo;
import com.sun.logging.LogDomains;
import com.sun.xml.rpc.spi.JaxRpcObjectFactory;
import com.sun.xml.rpc.spi.runtime.Handler;
import com.sun.xml.rpc.spi.runtime.SOAPMessageContext;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.messaging.MessageExchange;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.soap.SOAPMessage;

public class JAXRPCMessageProcessor
extends MessageProcessor {
    protected static final Logger logger = LogDomains.getLogger((String)"javax.enterprise.system.container.ejb");
    JaxRpcObjectFactory rpcFactory = JaxRpcObjectFactory.newInstance();

    public void process() {
        this.execute();
    }

    public void doWork() {
        try {
            MessageExchange me = this.getMessageExchange();
            String endpoint = me.getEndpoint().getEndpointName();
            QName service = me.getEndpoint().getServiceName();
            SOAPMessage response = null;
            MessageExchangeHelper meHelper = new MessageExchangeHelper();
            meHelper.setMessageExchange(me);
            try {
                this.debug(Level.FINEST, "serviceengine.process_incoming_request", new Object[]{service.getLocalPart(), endpoint});
                EjbRuntimeEndpointInfo runtimeEndpointInfo = (EjbRuntimeEndpointInfo)RuntimeEndpointInfoRegistryImpl.getInstance().getRuntimeEndpointInfo(service, endpoint);
                response = this.processEJBRequest(meHelper.denormalizeMessage(true), runtimeEndpointInfo);
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, "serviceengine.error_incoming_request", e);
                ServiceEngineException seException = new ServiceEngineException(e);
                meHelper.handleException((Exception)seException);
            }
            meHelper.handleResponse(response, false);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "JavaEEServiceEngine : Error processing request" + e, e);
        }
    }

    private void debug(Level logLevel, String msgID, Object[] params) {
        logger.log(logLevel, msgID, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SOAPMessage processEJBRequest(SOAPMessage message, EjbRuntimeEndpointInfo endpointInfo) {
        if (message != null) {
            Container container = endpointInfo.getContainer();
            SOAPMessageContext msgContext = this.rpcFactory.createSOAPMessageContext();
            container.externalPreInvoke();
            msgContext.setMessage(message);
            try {
                Handler implementor = ((Ejb2RuntimeEndpointInfo)endpointInfo).getHandlerImplementor((MessageContext)msgContext);
                implementor.handle(msgContext);
                SOAPMessage reply = msgContext.getMessage();
                if (reply.saveRequired()) {
                    reply.saveChanges();
                }
                SOAPMessage sOAPMessage = reply;
                return sOAPMessage;
            }
            catch (Exception e) {
                logger.fine(e.getMessage());
            }
            finally {
                endpointInfo.releaseImplementor();
                container.externalPostInvoke();
            }
        } else {
            String errorMsg = "null message POSTed to ejb endpoint " + endpointInfo.getEndpoint().getEndpointName() + " at " + endpointInfo.getEndpointAddressUri();
            logger.severe(errorMsg);
        }
        return null;
    }
}

