/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.common.classloader;

import com.sun.jbi.common.classloader.CustomJarCache;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomClassLoaderUtil {
    private ClassLoader mComponentClassLoader = null;
    private Map<String, ClassLoaderCache> mCache;

    public CustomClassLoaderUtil(ClassLoader componentClassloader) {
        this.mComponentClassLoader = componentClassloader;
    }

    public synchronized void registerServiceClassLoader(String key, String path) {
        File rootFile = new File(path);
        JarFileFilter filter = new JarFileFilter();
        Collection<URL> urlColl = this.listFiles(rootFile, filter, true);
        int colSize = urlColl.size();
        if (colSize == 0) {
            return;
        }
        URL[] urls = new URL[urlColl.size()];
        urlColl.toArray(urls);
        ServiceClassLoader serviceLoader = new ServiceClassLoader(urls, this.mComponentClassLoader);
        ClassLoaderCache clCache = new ClassLoaderCache(serviceLoader);
        if (this.mCache == null) {
            this.mCache = new HashMap<String, ClassLoaderCache>();
        }
        this.mCache.put(key, clCache);
    }

    public synchronized void unregisterServiceClassLoader(String key) {
        if (this.mCache != null && this.mCache.containsKey(key)) {
            ClassLoaderCache suCache = this.mCache.get(key);
            suCache.cleanup();
            suCache = null;
            this.mCache.remove(key);
        }
    }

    public synchronized void switchClassLoader(String suName, SwitchType type) {
        if (this.mCache == null) {
            return;
        }
        boolean key = this.mCache.containsKey(suName);
        if (!key) {
            return;
        }
        ClassLoader toSwitch = null;
        ClassLoaderCache clObj = this.mCache.get(suName);
        switch (type) {
            case service_classloader: {
                clObj.setThreadCtxClassLoader(Thread.currentThread().getContextClassLoader());
                toSwitch = clObj.getServiceClassLoader();
                break;
            }
            default: {
                toSwitch = clObj.getThreadCtxClassLoader();
            }
        }
        Thread.currentThread().setContextClassLoader(toSwitch);
    }

    public synchronized void cleanup() {
        this.mComponentClassLoader = null;
        if (this.mCache != null && this.mCache.size() > 0) {
            Set<String> keys = this.mCache.keySet();
            for (String key : keys) {
                ClassLoaderCache cache = this.mCache.get(key);
                if (cache != null) {
                    cache.cleanup();
                }
                this.mCache.remove(key);
            }
        }
        this.mCache = null;
    }

    private Collection<URL> listFiles(File directory, FilenameFilter filter, boolean recurse) {
        File[] entries;
        ArrayList<URL> urls = new ArrayList<URL>();
        for (File entry : entries = directory.listFiles()) {
            if (filter == null || filter.accept(directory, entry.getName())) {
                try {
                    URL url = entry.toURI().toURL();
                    urls.add(url);
                }
                catch (MalformedURLException urlExp) {
                    // empty catch block
                }
            }
            if (!recurse || !entry.isDirectory()) continue;
            urls.addAll(this.listFiles(entry, filter, recurse));
        }
        return urls;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ServiceClassLoader
    extends ClassLoader {
        private CustomJarCache mJarCache;

        public ServiceClassLoader(URL[] urls, ClassLoader parent) {
            super(parent);
            this.initJarCache(urls);
        }

        @Override
        public Class<?> findClass(String name) throws ClassNotFoundException {
            try {
                return super.findClass(name);
            }
            catch (ClassNotFoundException cnfe) {
                InputStream is = this.getResourceAsStream(name.replace('.', '/') + ".class");
                if (is == null) {
                    throw new ClassNotFoundException(name);
                }
                byte[] buf = new byte[8192];
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                try {
                    int count;
                    while ((count = is.read(buf, 0, buf.length)) > 0) {
                        bos.write(buf, 0, count);
                    }
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
                byte[] classBytes = bos.toByteArray();
                return this.defineClass(name, classBytes, 0, classBytes.length);
            }
        }

        @Override
        public InputStream getResourceAsStream(String fileName) {
            InputStream is = super.getResourceAsStream(fileName);
            if (is != null) {
                return is;
            }
            return this.mJarCache.getResourceAsStream(fileName);
        }

        @Override
        public URL findResource(String fileName) {
            URL url = this.mJarCache.findResource(fileName);
            if (url == null) {
                url = super.findResource(fileName);
            }
            return url;
        }

        @Override
        public Enumeration<URL> findResources(String fileName) throws IOException {
            Enumeration<URL> e = this.mJarCache.findResources(fileName).elements();
            if (e.hasMoreElements()) {
                return e;
            }
            return super.findResources(fileName);
        }

        private void initJarCache(URL[] urls) {
            this.mJarCache = new CustomJarCache();
            for (URL url : urls) {
                try {
                    File file = new File(url.getFile());
                    if (!file.exists() || !file.getName().endsWith(".jar")) continue;
                    this.mJarCache.addJar(file.getPath());
                }
                catch (IOException ioEx) {
                    // empty catch block
                }
            }
        }

        public void releaseResources() {
            this.mJarCache.close();
            this.mJarCache = null;
        }
    }

    private class ClassLoaderCache {
        private ClassLoader mThreadCtxClassLoader;
        private ServiceClassLoader mServiceClassLoader;

        public ClassLoaderCache(ServiceClassLoader serviceClassLoader) {
            this.mServiceClassLoader = serviceClassLoader;
        }

        public ClassLoader getThreadCtxClassLoader() {
            return this.mThreadCtxClassLoader;
        }

        public ClassLoader getServiceClassLoader() {
            return this.mServiceClassLoader;
        }

        public void cleanup() {
            this.mThreadCtxClassLoader = null;
            this.mServiceClassLoader.releaseResources();
            this.mServiceClassLoader = null;
        }

        public void setThreadCtxClassLoader(ClassLoader componentLoader) {
            this.mThreadCtxClassLoader = componentLoader;
        }
    }

    private class JarFileFilter
    implements FilenameFilter {
        private JarFileFilter() {
        }

        public boolean accept(File dir, String name) {
            return name != null && name.length() > 0 && name.endsWith(".jar");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SwitchType {
        context_classloader,
        service_classloader;

    }
}

