/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.configuration;

import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

public class RuntimeConfigurationHelper {
    public static final String COMPONENT_TYPE_BINDING = "bindingComponents";
    public static final String COMPONENT_TYPE_ENGINE = "serviceEngines";
    ObjectName objectName;
    MBeanServer connection;

    public RuntimeConfigurationHelper(String componentType, String componentName, MBeanServer mbeanServer) throws MalformedObjectNameException {
        this.objectName = RuntimeConfigurationHelper.constructObjectName(componentType, componentName);
        this.connection = mbeanServer;
    }

    public RuntimeConfigurationHelper(String componentType, String componentName, MBeanServer mbeanServer, String suid) throws MalformedObjectNameException {
        this.objectName = RuntimeConfigurationHelper.constructObjectName(componentType, componentName, suid);
        this.connection = mbeanServer;
    }

    public RuntimeConfigurationHelper(ObjectName objName, MBeanServer mbeanServer) throws MalformedObjectNameException {
        this.objectName = objName;
        this.connection = mbeanServer;
    }

    public void registerMBean(Object mbeanInstance) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        if (this.connection != null && !this.connection.isRegistered(this.objectName)) {
            this.connection.registerMBean(mbeanInstance, this.objectName);
        }
    }

    public void unregisterMBean() throws InstanceNotFoundException, MBeanRegistrationException {
        if (this.connection != null && this.connection.isRegistered(this.objectName)) {
            this.connection.unregisterMBean(this.objectName);
        }
    }

    public ObjectName getRuntimeConfigObjectName() {
        return this.objectName;
    }

    public static ObjectName constructObjectName(String componentType, String componentName) throws MalformedObjectNameException {
        String objectNameString = "com.sun.ebi:ServiceType=Configuration,InstallationType=" + componentType + ",IdentificationName=" + componentName;
        ObjectName objectName = new ObjectName(objectNameString);
        return objectName;
    }

    public static ObjectName constructObjectName(String componentType, String componentName, String serviceUnitId) throws MalformedObjectNameException {
        String objectNameString = "com.sun.ebi:ServiceType=Configuration,InstallationType=" + componentType + ",IdentificationName=" + componentName + ",ServiceUnitID=" + serviceUnitId;
        ObjectName objectName = new ObjectName(objectNameString);
        return objectName;
    }
}

