/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.systemic.quality.propagation.api.experimental.impl;

import com.sun.jbi.systemic.quality.propagation.api.CorrelatedMessageExchangeException;
import com.sun.jbi.systemic.quality.propagation.api.experimental.CorrelatedMessageExchangeFactory;
import com.sun.jbi.systemic.quality.propagation.api.experimental.MessageExchangeNode;
import com.sun.jbi.systemic.quality.propagation.api.experimental.MutableMessageExchangeNode;
import com.sun.jbi.systemic.quality.propagation.api.experimental.impl.MessageExchangeNodeFactory;
import java.util.logging.Logger;
import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.security.auth.Subject;

public class CorrelatedMessageExchangeFactoryImpl
implements CorrelatedMessageExchangeFactory {
    private static Logger mLogger = Logger.getLogger(CorrelatedMessageExchangeFactory.class.getName());
    private ComponentContext mContext;
    private DeliveryChannel mChannel;
    private MessageExchangeFactory mExchangeFactory;

    public CorrelatedMessageExchangeFactoryImpl(ComponentContext context) throws MessagingException {
        this.mContext = context;
        this.mChannel = this.mContext.getDeliveryChannel();
        this.mExchangeFactory = this.mChannel.createExchangeFactory();
    }

    public InOnly createInOnlyExchange(MessageExchange parentExchange) throws CorrelatedMessageExchangeException {
        InOnly childExchange = null;
        try {
            MessageExchangeFactory meFactory = this.mExchangeFactory;
            childExchange = meFactory.createInOnlyExchange();
            this.createMessageExchangeNode(parentExchange, (MessageExchange)childExchange);
            if (parentExchange == null) {
                return childExchange;
            }
            ExchangeStatus parentMEStatus = parentExchange.getStatus();
            if (parentMEStatus == ExchangeStatus.ACTIVE) {
                this.doTransactionPropogationToChildExchange(parentExchange, (MessageExchange)childExchange);
            } else {
                Object parentTransaction = parentExchange.getProperty("javax.jbi.transaction.jta");
                if (parentTransaction != null) {
                    throw new CorrelatedMessageExchangeException("Can not create child exchange, parent exchange is not active.");
                }
            }
        }
        catch (MessagingException ex) {
            throw new CorrelatedMessageExchangeException("Failed to create child exchange.", ex);
        }
        return childExchange;
    }

    public InOut createInOutExchange(MessageExchange parentExchange) throws CorrelatedMessageExchangeException {
        InOut childExchange = null;
        try {
            MessageExchangeFactory meFactory = this.mExchangeFactory;
            childExchange = meFactory.createInOutExchange();
            this.createMessageExchangeNode(parentExchange, (MessageExchange)childExchange);
            if (parentExchange == null) {
                return childExchange;
            }
            ExchangeStatus parentMEStatus = parentExchange.getStatus();
            if (parentMEStatus == ExchangeStatus.ACTIVE) {
                this.doTransactionPropogationToChildExchange(parentExchange, (MessageExchange)childExchange);
            } else {
                Object parentTransaction = parentExchange.getProperty("javax.jbi.transaction.jta");
                if (parentTransaction != null) {
                    throw new CorrelatedMessageExchangeException("Can not create child exchange, parent exchange is not active.");
                }
            }
        }
        catch (MessagingException ex) {
            throw new CorrelatedMessageExchangeException("Failed to create child exchange.", ex);
        }
        return childExchange;
    }

    public void send(MessageExchange me) throws CorrelatedMessageExchangeException {
        MessageExchangeNode node = (MessageExchangeNode)me.getProperty("javax.jbi.messageexchange.parent.node");
        if (node != null) {
            MessageExchangeNode parent = node.getParentExchange();
            if (parent != null) {
                MessageExchange parentExchange = parent.getMessageExchange();
                if (parentExchange.getStatus() != ExchangeStatus.ACTIVE && me.isTransacted()) {
                    throw new CorrelatedMessageExchangeException("Can not send message exchange, the exchange " + me + " transacted but parent exchange " + parentExchange + " is not active.");
                }
                this.doSecurityPropogationToChildExchange(parentExchange, me);
            }
        } else {
            throw new CorrelatedMessageExchangeException("Can not send message exchange, the exchange " + me + " is not created by this factory");
        }
        this.sendAsyncMessage(me);
    }

    public void sendSync(MessageExchange me) throws CorrelatedMessageExchangeException {
        MessageExchangeNode node = (MessageExchangeNode)me.getProperty("javax.jbi.messageexchange.parent.node");
        if (node != null) {
            MessageExchangeNode parent = node.getParentExchange();
            if (parent != null) {
                MessageExchange parentExchange = parent.getMessageExchange();
                if (parentExchange.getStatus() != ExchangeStatus.ACTIVE && me.isTransacted()) {
                    throw new CorrelatedMessageExchangeException("Can not send message exchange, the exchange " + me + " transacted but parent exchange " + parentExchange + " is not active.");
                }
                this.doSecurityPropogationToChildExchange(parentExchange, me);
            }
        } else {
            throw new CorrelatedMessageExchangeException("Can not send message exchange, the exchange " + me + " is not created by this factory");
        }
        this.sendSyncMessage(me);
    }

    public void sendSync(MessageExchange me, long timeout) throws CorrelatedMessageExchangeException {
        MessageExchangeNode node = (MessageExchangeNode)me.getProperty("javax.jbi.messageexchange.parent.node");
        if (node != null) {
            MessageExchangeNode parent = node.getParentExchange();
            if (parent != null) {
                MessageExchange parentExchange = parent.getMessageExchange();
                if (parentExchange.getStatus() != ExchangeStatus.ACTIVE && me.isTransacted()) {
                    throw new CorrelatedMessageExchangeException("Can not send message exchange, the exchange " + me + " transacted but parent exchange " + parentExchange + " is not active.");
                }
                this.doSecurityPropogationToChildExchange(parentExchange, me);
            }
        } else {
            throw new CorrelatedMessageExchangeException("Can not send message exchange, the exchange " + me + " is not created by this factory");
        }
        this.sendSyncMessage(me, timeout);
    }

    private void createMessageExchangeNode(MessageExchange parentExchange, MessageExchange childExchange) {
        if (parentExchange == null) {
            MutableMessageExchangeNode root = MessageExchangeNodeFactory.getInstance().createMessageExchangeNode(childExchange);
            childExchange.setProperty("javax.jbi.messageexchange.parent.node", (Object)root);
        } else {
            MutableMessageExchangeNode root = (MutableMessageExchangeNode)parentExchange.getProperty("javax.jbi.messageexchange.parent.node");
            if (root == null) {
                root = MessageExchangeNodeFactory.getInstance().createMessageExchangeNode(parentExchange);
                MutableMessageExchangeNode child = MessageExchangeNodeFactory.getInstance().createMessageExchangeNode(childExchange);
                root.addChildExchange(child);
                childExchange.setProperty("javax.jbi.messageexchange.parent.node", (Object)child);
                parentExchange.setProperty("javax.jbi.messageexchange.parent.node", (Object)root);
            }
        }
    }

    private void sendAsyncMessage(MessageExchange me) throws CorrelatedMessageExchangeException {
        try {
            this.mChannel.send(me);
        }
        catch (MessagingException ex) {
            throw new CorrelatedMessageExchangeException("Can not asynchronous send message exchange, the exchange " + me + " encountered problem by delivery channel while sending it", ex);
        }
    }

    private void sendSyncMessage(MessageExchange me) throws CorrelatedMessageExchangeException {
        try {
            this.mChannel.sendSync(me);
        }
        catch (MessagingException ex) {
            throw new CorrelatedMessageExchangeException("Can not send synchronous message exchange, the exchange " + me + " encountered problem by delivery channel while sending it", ex);
        }
    }

    private void sendSyncMessage(MessageExchange me, long timeout) throws CorrelatedMessageExchangeException {
        try {
            this.mChannel.sendSync(me, timeout);
        }
        catch (MessagingException ex) {
            throw new CorrelatedMessageExchangeException("Can not send synchronous message exchange, the exchange " + me + " encountered problem by delivery channel while sending it", ex);
        }
    }

    private void doTransactionPropogationToChildExchange(MessageExchange parentExchange, MessageExchange childExchange) {
        Object parentTransaction = parentExchange.getProperty("javax.jbi.transaction.jta");
        if (parentTransaction != null) {
            childExchange.setProperty("javax.jbi.transaction.jta", parentTransaction);
        }
    }

    private void doSecurityPropogationToChildExchange(MessageExchange parentExchange, MessageExchange childExchange) {
        InOut inOut;
        InOnly inOnly;
        NormalizedMessage parentInMessage = null;
        NormalizedMessage childInMessage = null;
        if (parentExchange instanceof InOnly) {
            inOnly = (InOnly)parentExchange;
            parentInMessage = inOnly.getInMessage();
        } else if (parentExchange instanceof InOut) {
            inOut = (InOut)parentExchange;
            parentInMessage = inOut.getInMessage();
        }
        if (childExchange instanceof InOnly) {
            inOnly = (InOnly)childExchange;
            childInMessage = inOnly.getInMessage();
        } else if (childExchange instanceof InOut) {
            inOut = (InOut)childExchange;
            childInMessage = inOut.getInMessage();
        }
        this.doSecurityPropogationToChildExchange(parentInMessage, childInMessage);
    }

    private void doSecurityPropogationToChildExchange(NormalizedMessage parentInMessage, NormalizedMessage childInMessage) {
        Subject subject;
        if (parentInMessage != null && childInMessage != null && (subject = parentInMessage.getSecuritySubject()) != null) {
            childInMessage.setSecuritySubject(subject);
        }
    }
}

