/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc.util;

import com.sun.jbi.httpsoapbc.util.TransformerPool;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DebugLog {
    private static final TransformerPool cTransformerPool = new TransformerPool();

    public static void debugLog(Logger aLogger, Level logLevel, String msg, Document doc) {
        if (aLogger != null) {
            if (doc != null) {
                DebugLog.debugLog(aLogger, logLevel, msg, doc.getDocumentElement());
            } else if (aLogger.isLoggable(logLevel)) {
                aLogger.log(logLevel, msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void debugLog(Logger aLogger, Level logLevel, String msg, Source src) {
        if (aLogger != null && aLogger.isLoggable(logLevel) && src != null) {
            Transformer transformer = null;
            try {
                Reader reader;
                InputStream inputStream;
                StreamSource stream;
                StringWriter writer = new StringWriter();
                StreamResult dest = new StreamResult(writer);
                transformer = cTransformerPool.retrieve();
                if (src instanceof StreamSource) {
                    stream = (StreamSource)src;
                    inputStream = stream.getInputStream();
                    if (inputStream != null) {
                        inputStream.reset();
                    }
                    if ((reader = stream.getReader()) != null) {
                        reader.reset();
                    }
                }
                transformer.transform(src, dest);
                if (src instanceof StreamSource) {
                    stream = (StreamSource)src;
                    inputStream = stream.getInputStream();
                    if (inputStream != null) {
                        inputStream.reset();
                    }
                    if ((reader = stream.getReader()) != null) {
                        reader.reset();
                    }
                }
                String s = msg + ":\n" + writer.toString();
                aLogger.log(logLevel, s);
                cTransformerPool.relinquish(transformer);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                cTransformerPool.relinquish(transformer);
            }
        }
    }

    public static void debugLog(Logger aLogger, Level logLevel, String msg, Element elem) {
        if (aLogger != null && aLogger.isLoggable(logLevel)) {
            try {
                if (elem != null) {
                    DOMSource src = new DOMSource(elem);
                    DebugLog.debugLog(aLogger, logLevel, msg, src);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void debugLog(Logger aLogger, Level logLevel, String msg, Map map) {
        if (aLogger != null && aLogger.isLoggable(logLevel)) {
            StringBuffer strBuff = new StringBuffer();
            if (map != null) {
                Set keys = map.keySet();
                for (Object key : keys) {
                    Object val = map.get(key);
                    strBuff.append(key).append('=').append(val).append('\n');
                }
            }
            strBuff.insert(0, '{');
            strBuff.insert(strBuff.length(), '}');
            strBuff.insert(0, msg + ":\n");
            aLogger.log(logLevel, strBuff.toString());
        }
    }
}

