/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jbi.serviceengine.comm;

import com.sun.enterprise.jbi.serviceengine.comm.MessageExchangeTransportImpl;
import com.sun.enterprise.jbi.serviceengine.comm.UnWrappedMessage;
import com.sun.enterprise.jbi.serviceengine.comm.WrappedMessage;
import com.sun.enterprise.jbi.serviceengine.util.soap.EndpointMetaData;
import com.sun.enterprise.jbi.serviceengine.util.soap.StringTranslator;
import com.sun.xml.ws.api.message.Attachment;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import java.util.logging.Level;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.namespace.QName;

public class ConsumerInOut
extends MessageExchangeTransportImpl {
    private InOut me;

    public ConsumerInOut(InOut me) {
        super((MessageExchange)me);
        this.me = me;
    }

    public NormalizedMessage receiveNormalized() {
        this.msg = this.me.getFault() != null ? this.me.getFault() : this.me.getOutMessage();
        this.preReceive();
        return this.msg;
    }

    public void sendNormalized() throws Exception {
        this.me.setInMessage(this.msg);
        this.send();
    }

    public void send(Packet packet, EndpointMetaData emd) throws Exception {
        Message message = packet.getMessage();
        String operationName = this.me.getOperation().getLocalPart();
        WrappedMessage wrappedMessage = new WrappedMessage();
        wrappedMessage.setAbstractMessage(message);
        if (message.isFault()) {
            wrappedMessage.wrapFault(operationName, emd);
        } else {
            wrappedMessage.setWSDLBindingStyle(emd.getBindingStyle(operationName));
            wrappedMessage.setWSDLMessageType(emd.getInputMessage(operationName).getQName());
            wrappedMessage.setWSDLMessageName(emd.getOperationInputName(operationName));
            wrappedMessage.setWSDLOrderedParts(emd.getInputMessage(operationName).getOrderedParts(null));
            wrappedMessage.setWSDLPartBindings(emd.getInputPartBindings(operationName));
            wrappedMessage.wrap();
        }
        this.msg = this.me.createMessage();
        this.msg.setContent(wrappedMessage.readPayloadAsSource());
        for (Attachment attachment : message.getAttachments()) {
            logger.log(Level.FINE, "Adding attachment to Normalized Message, attachmentID = " + attachment.getContentId());
            this.msg.addAttachment(attachment.getContentId(), attachment.asDataHandler());
        }
        this.setMessageProperties(packet.invocationProperties);
        this.sendNormalized();
    }

    public UnWrappedMessage receive(EndpointMetaData emd) {
        NormalizedMessage normalizedMessage = this.receiveNormalized();
        UnWrappedMessage unwrappedMessage = null;
        if (normalizedMessage != null) {
            try {
                String operationName = this.me.getOperation().getLocalPart();
                unwrappedMessage = new UnWrappedMessage();
                unwrappedMessage.setNormalizedMessage(normalizedMessage);
                if (normalizedMessage instanceof Fault) {
                    unwrappedMessage.unwrapFault();
                } else {
                    unwrappedMessage.setWSDLMessageType(new QName(emd.getOutputMessage(operationName).getQName().getNamespaceURI(), operationName + "Response"));
                    unwrappedMessage.setWSDLBindingStyle(emd.getBindingStyle(operationName));
                    unwrappedMessage.setWSDLOrderedParts(emd.getOutputMessage(operationName).getOrderedParts(null));
                    unwrappedMessage.setWSDLPartBindings(emd.getOutputPartBindings(operationName));
                    unwrappedMessage.unwrap();
                }
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, ex.getMessage() + StringTranslator.getDefaultInstance().getString("serviceengine.unwrapping_failed_hint1"));
            }
        }
        return unwrappedMessage;
    }
}

