/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc.management;

import com.sun.jbi.httpsoapbc.HttpSoapBindingLifeCycle;
import com.sun.jbi.httpsoapbc.management.HTTPManagementMBean;
import com.sun.jbi.internationalization.Messages;
import java.util.logging.Logger;
import javax.management.MBeanException;

public class HTTPManagement
implements HTTPManagementMBean {
    private static final Messages mMessages = Messages.getMessages(HTTPManagement.class);
    private HttpSoapBindingLifeCycle mLifecycleListener;
    private Logger mLogger = Messages.getLogger(HTTPManagement.class);

    public HTTPManagement(HttpSoapBindingLifeCycle lifecycleListener) {
        this.mLifecycleListener = lifecycleListener;
    }

    public boolean suspend(String consumingEndpointName) throws MBeanException {
        boolean isSuspended = false;
        if (consumingEndpointName == null || consumingEndpointName.equals("")) {
            throw new MBeanException(new Exception(mMessages.getString("HTTPBC-E01300.Invalid_endpoint_name", (Object)consumingEndpointName)));
        }
        try {
            isSuspended = this.mLifecycleListener.suspendActivatedEndpoint(consumingEndpointName);
        }
        catch (Exception e) {
            throw new MBeanException(e, mMessages.getString("HTTPBC-E01301.Failed_to_suspend_endpoint", (Object)consumingEndpointName) + e.getMessage());
        }
        return isSuspended;
    }

    public boolean resume(String consumingEndpointName) throws MBeanException {
        boolean isResumed = false;
        if (consumingEndpointName == null || consumingEndpointName.equals("")) {
            throw new MBeanException(new Exception(mMessages.getString("HTTPBC-E01300.Invalid_endpoint_name", (Object)consumingEndpointName)));
        }
        try {
            isResumed = this.mLifecycleListener.resumeActivatedEndpoint(consumingEndpointName);
        }
        catch (Exception e) {
            throw new MBeanException(e, mMessages.getString("HTTPBC-E01302.Failed_to_resume_endpoint", (Object)consumingEndpointName) + e.getMessage());
        }
        return isResumed;
    }

    public boolean isEndpointActive(String consumingEndpointName) throws MBeanException {
        if (consumingEndpointName == null || consumingEndpointName.equals("")) {
            throw new MBeanException(new Exception(mMessages.getString("HTTPBC-E01300.Invalid_endpoint_name", (Object)consumingEndpointName)));
        }
        return this.mLifecycleListener.isEndpointActive(consumingEndpointName);
    }

    public String[] listActiveEndpoints() {
        return this.mLifecycleListener.getActiveConsumingEndpoints();
    }

    public String[] listInactiveEndpoints() {
        return this.mLifecycleListener.getInactiveConsumingEndpoints();
    }
}

