/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jbi.serviceengine.util.soap;

import com.sun.enterprise.jbi.serviceengine.util.soap.MessageNormalizer;
import com.sun.enterprise.jbi.serviceengine.util.soap.Operation;
import com.sun.enterprise.jbi.serviceengine.util.soap.SOAPWrapper;
import com.sun.enterprise.jbi.serviceengine.util.soap.StringTranslator;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.jbi.JBIException;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.Detail;
import javax.xml.soap.Name;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.soap.Text;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MessageNormalizerImpl
implements MessageNormalizer {
    private Logger mLogger = Logger.getLogger(this.getClass().getPackage().getName());
    private StringTranslator mStringTranslator = new StringTranslator(this.getClass().getPackage().getName(), this.getClass().getClassLoader());

    public void normalizeMessage(SOAPWrapper soapWrapper, NormalizedMessage normalizedMessage, Operation operation) throws JBIException {
        if (soapWrapper.getStatus() == 500) {
            this.normalizeFaultMessage(soapWrapper, normalizedMessage);
        } else {
            this.normalizeResponseMessage(soapWrapper, normalizedMessage, operation);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void normalizeFaultMessage(SOAPWrapper soapWrapper, NormalizedMessage normalizedMessage) throws JBIException {
        try {
            SOAPMessage soapMessage = soapWrapper.getMessage();
            if (soapMessage == null) return;
            SOAPPart soapPart = soapMessage.getSOAPPart();
            SOAPEnvelope soapEnvelope = soapPart.getEnvelope();
            SOAPBody soapBody = soapEnvelope.getBody();
            if (soapBody.hasFault()) {
                this.mLogger.fine(this.mStringTranslator.getString("SBC_FAULT_ELEMENT_FOUND"));
                SOAPFault soapFault = soapBody.getFault();
                Detail soapDetail = soapFault.getDetail();
                if (soapDetail == null) throw new JBIException(soapFault.getFaultString());
                normalizedMessage.setContent((Source)new DOMSource(this.getChildElement((org.w3c.dom.Node)soapDetail)));
                SOAPHeader soapHeader = soapEnvelope.getHeader();
                if (soapHeader != null) {
                    normalizedMessage.setProperty("SoapHeader", (Object)soapHeader);
                }
                normalizedMessage.setProperty("FAULT_STRING", (Object)soapFault.getFaultString());
                normalizedMessage.setProperty("FAULT_ACTOR", (Object)this.extractFaultCode(soapFault.getFaultCode()));
                return;
            } else {
                this.mLogger.severe(this.mStringTranslator.getString("SBC_ALGORITHM_ERROR"));
            }
            return;
        }
        catch (SOAPException soapException) {
            this.mLogger.severe(this.mStringTranslator.getString("SBC_NORMALIZE_FAULT_MESSAGE_FAILURE"));
            this.mLogger.severe(this.mStringTranslator.getString("SBC_ERROR_DETAILS"));
            JBIException jbiException = new JBIException(this.mStringTranslator.getString("SBC_NORMALIZE_FAULT_MESSAGE_FAILURE"));
            jbiException.initCause((Throwable)soapException);
            throw jbiException;
        }
    }

    public void normalizeResponseMessage(SOAPWrapper soapWrapper, NormalizedMessage normalizedMessage, Operation operation) throws JBIException {
        this.mLogger.fine(this.mStringTranslator.getString("SBC_NORMALIZE_SOAP_MESSAGE"));
        try {
            SOAPMessage soapMessage = soapWrapper.getMessage();
            if (soapMessage != null) {
                SOAPPart soapPart = soapMessage.getSOAPPart();
                SOAPEnvelope soapEnvelope = soapPart.getEnvelope();
                SOAPBody soapBody = soapEnvelope.getBody();
                org.w3c.dom.Node bodyContents = this.getBodyContentsAsNode(soapBody);
                DOMSource ds = new DOMSource(bodyContents);
                normalizedMessage.setContent((Source)ds);
                this.normalizeAttachments(soapMessage, normalizedMessage);
                SOAPHeader soapHeader = soapEnvelope.getHeader();
                if (soapHeader != null) {
                    // empty if block
                }
            }
            Iterator messageProperties = soapWrapper.getProperties();
            while (messageProperties.hasNext()) {
                String propertyName = (String)messageProperties.next();
                normalizedMessage.setProperty(propertyName, soapWrapper.getValue(propertyName));
            }
        }
        catch (RuntimeException runtimeException) {
            this.mLogger.severe(this.mStringTranslator.getString("SBC_NORMALIZE_SOAP_MESSAGE_FAILURE_RT_EXP"));
            JBIException jbiException = new JBIException(this.mStringTranslator.getString("SBC_NORMALIZE_SOAP_MESSAGE_FAILURE"));
            jbiException.initCause((Throwable)runtimeException);
            throw jbiException;
        }
        catch (SOAPException soapException) {
            this.mLogger.severe(this.mStringTranslator.getString("SBC_NORMALIZE_SOAP_MESSAGE_FAILURE"));
            this.mLogger.severe(this.mStringTranslator.getString("SBC_ERROR_DETAILS", soapException.toString()));
            JBIException jbiException = new JBIException(this.mStringTranslator.getString("SBC_NORMALIZE_SOAP_MESSAGE_FAILURE"));
            jbiException.initCause((Throwable)soapException);
            throw jbiException;
        }
        catch (Exception ex) {
            this.mLogger.severe("Some Exception while dumping Source.");
            ex.printStackTrace();
        }
        this.mLogger.fine(this.mStringTranslator.getString("SBC_SUCCESS_NORMALISE_SUCCESS"));
    }

    private org.w3c.dom.Node getBodyContentsAsNode(SOAPBody body) {
        org.w3c.dom.Node dNode = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document mDoc = builder.newDocument();
            Iterator iter2 = body.getChildElements();
            while (iter2.hasNext()) {
                Node n = (Node)iter2.next();
                if (!(n instanceof SOAPElement)) continue;
                dNode = this.createDOMNodeFromSOAPNode(n, mDoc);
                break;
            }
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return dNode;
    }

    private org.w3c.dom.Node createDOMNodeFromSOAPNode(Node soapNode, Document document) throws ParserConfigurationException {
        org.w3c.dom.Node result = null;
        if (soapNode instanceof SOAPElement) {
            SOAPElement soapElement = (SOAPElement)soapNode;
            Name name = soapElement.getElementName();
            if (name.getURI().length() != 0 && name.getQualifiedName().length() != 0) {
                result = document.createElementNS(name.getURI(), name.getQualifiedName());
            } else if (name.getLocalName() != null) {
                result = document.createElement(name.getLocalName());
            }
            Iterator iter = soapElement.getAllAttributes();
            while (iter.hasNext()) {
                Name attrName = (Name)iter.next();
                String attrValue = soapElement.getAttributeValue(attrName);
                Attr attribute = null;
                attribute = attrName.getURI() == null ? document.createAttribute(attrName.getQualifiedName()) : document.createAttributeNS(attrName.getURI(), attrName.getQualifiedName());
                attribute.setValue(attrValue);
                ((Element)result).setAttributeNodeNS(attribute);
            }
            iter = soapElement.getChildElements();
            while (iter.hasNext()) {
                Node childSOAPNode = (Node)iter.next();
                this.appendSOAPNodeToDOMNode(document, result, childSOAPNode);
            }
        } else if (soapNode instanceof Text) {
            Text textNode = (Text)soapNode;
            String textValue = textNode.getValue();
            result = textNode.isComment() ? document.createComment(textValue) : document.createTextNode(textValue);
        }
        return result;
    }

    private void appendSOAPNodeToDOMNode(Document document, org.w3c.dom.Node domNode, Node soapNode) throws ParserConfigurationException {
        org.w3c.dom.Node newDOMNode = this.createDOMNodeFromSOAPNode(soapNode, document);
        domNode.appendChild(newDOMNode);
    }

    private static void dump(Source source) throws Exception {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer t = tf.newTransformer();
        StreamResult stdOut = new StreamResult(System.out);
        System.out.println("[BEGIN_MESSAGE_DUMP]");
        t.transform(source, stdOut);
        System.out.println("[END_MESSAGE_DUMP]");
    }

    protected org.w3c.dom.Node extractPayload(SOAPBody soapBody, Operation operation, boolean isFault) throws JBIException {
        this.mLogger.fine(this.mStringTranslator.getString("SBC_EXTRACT_REQUEST_PAYLOAD"));
        return this.getChildElement((org.w3c.dom.Node)soapBody);
    }

    public boolean isFault(int responseCode) {
        return false;
    }

    private org.w3c.dom.Node getChildElement(org.w3c.dom.Node parentNode) {
        NodeList childNodes = parentNode.getChildNodes();
        org.w3c.dom.Node currentNode = null;
        org.w3c.dom.Node elementNode = null;
        for (int i = 0; i < childNodes.getLength(); ++i) {
            currentNode = childNodes.item(i);
            if (currentNode.getNodeType() != 1) continue;
            elementNode = currentNode;
            break;
        }
        return elementNode;
    }

    private String extractFaultCode(String completeFaultCode) {
        String faultCode;
        StringTokenizer tokenizer = new StringTokenizer(completeFaultCode, ":");
        if (tokenizer.countTokens() == 1) {
            faultCode = completeFaultCode;
        } else {
            tokenizer.nextToken();
            faultCode = tokenizer.nextToken();
        }
        return faultCode;
    }

    private void normalizeAttachments(SOAPMessage soapMessage, NormalizedMessage normalizedMessage) throws SOAPException, MessagingException {
        if (soapMessage != null && soapMessage.countAttachments() > 0) {
            Iterator attachmentIter = soapMessage.getAttachments();
            while (attachmentIter.hasNext()) {
                AttachmentPart attachment = (AttachmentPart)attachmentIter.next();
                DataHandler dataHandler = attachment.getDataHandler();
                String contentId = attachment.getContentId();
                normalizedMessage.addAttachment(contentId, dataHandler);
            }
        }
    }
}

