/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc;

import com.sun.jbi.httpsoapbc.OperationMetaData;
import com.sun.jbi.httpsoapbc.util.DebugLog;
import com.sun.jbi.httpsoapbc.util.Util;
import com.sun.jbi.internationalization.Messages;
import com.sun.jbi.nms.wsdl11wrapper.HelperFactory;
import com.sun.jbi.nms.wsdl11wrapper.WrapperParser;
import com.sun.jbi.nms.wsdl11wrapper.WrapperProcessingException;
import com.sun.jbi.nms.wsdl11wrapper.util.WrapperUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.wsdl.Fault;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPHeaderFault;
import javax.xml.namespace.QName;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.soap.Detail;
import javax.xml.soap.DetailEntry;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.TransformerException;
import net.java.hulp.measure.Probe;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SoapDenormalizer {
    static final String SCHEMA_XSD_URI_2001 = "http://www.w3.org/2001/XMLSchema";
    static final String SCHEMA_XSI_URI_2001 = "http://www.w3.org/2001/XMLSchema-instance";
    static final String SCHEMA_XSD_URI_1999 = "http://www.w3.org/1999/XMLSchema";
    static final String SCHEMA_XSI_URI_1999 = "http://www.w3.org/1999/XMLSchema-instance";
    static final String SCHEMA_XMLNS_URI_2000 = "http://www.w3.org/2000/xmlns/";
    static final String RPC_RESPONSE_SUFFIX = "Response";
    static final String IN_MSG = "in";
    private static final String SOAP_HEADERS_PROPERTY = "com.sun.jbi.headers.soap";
    private static Messages mMessages = Messages.getMessages(SoapDenormalizer.class);
    private static Logger mLog = Messages.getLogger(SoapDenormalizer.class);
    private SOAPFactory mSoapFactory;
    private boolean mIsHeaderCopyEnabled = false;
    private Probe mMeasurement = null;
    private static Map<String, String> mStandardNamespaceURIs = new HashMap<String, String>();

    public SoapDenormalizer() {
        try {
            this.mSoapFactory = SOAPFactory.newInstance();
        }
        catch (Exception e) {
            mLog.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public SOAPMessage denormalize(NormalizedMessage normalizedMessage, MessageExchange exchange, OperationMetaData meta, MessageFactory messageFactory, boolean inMsg) throws MessagingException {
        try {
            if (mLog.isLoggable(Level.FINE)) {
                DebugLog.debugLog(mLog, Level.FINE, "Normalized message to denormalize", normalizedMessage.getContent());
            }
            String topic = "normalize" + (inMsg ? "Request" : "Reply");
            this.mMeasurement = Probe.fine(this.getClass(), (String)topic);
            Node node = Util.messageAsDom(normalizedMessage);
            Document normalDoc = null;
            Element normalRoot = null;
            if (node == null) {
                throw new WrapperProcessingException(mMessages.getString("HTTPBC-E00795.Not_wrapped_wsdl_11"));
            }
            normalDoc = node instanceof Document ? (Document)node : ((Element)node).getOwnerDocument();
            normalRoot = normalDoc.getDocumentElement();
            Map jbiMessageNSs = WrapperUtil.extractNamespaceDeclarations((Element)normalRoot);
            if (mLog.isLoggable(Level.FINE)) {
                DebugLog.debugLog(mLog, Level.FINE, "JBI message namespaces", jbiMessageNSs);
            }
            SOAPMessage outSoapMessage = messageFactory.createMessage();
            WrapperParser wrapperParser = HelperFactory.createParser();
            if (javax.jbi.messaging.Fault.class.isInstance(normalizedMessage)) {
                wrapperParser.parse(normalDoc, meta.getFullDefinition());
                if (!wrapperParser.isMessageWrapped()) {
                    throw new WrapperProcessingException(mMessages.getString("HTTPBC-E00795.Not_wrapped_wsdl_11"));
                }
                this.processSoapFault(normalRoot, outSoapMessage, meta, inMsg, wrapperParser);
            } else {
                Message msgDef = null;
                msgDef = inMsg ? meta.getInputMessage() : meta.getOutputMessage();
                wrapperParser.parse(normalDoc, msgDef);
                if (!wrapperParser.isMessageWrapped()) {
                    throw new WrapperProcessingException(mMessages.getString("HTTPBC-E00795.Not_wrapped_wsdl_11"));
                }
                this.processSoapHeader(exchange, outSoapMessage, meta, inMsg, wrapperParser, jbiMessageNSs);
                this.processSoapBody(outSoapMessage, meta, inMsg, wrapperParser, jbiMessageNSs);
            }
            if (mLog.isLoggable(Level.FINE)) {
                DebugLog.debugLog(mLog, Level.FINE, "Denormalized SOAP envelope", (Element)outSoapMessage.getSOAPPart().getEnvelope());
            }
            SOAPMessage sOAPMessage = outSoapMessage;
            return sOAPMessage;
        }
        catch (FactoryConfigurationError fce) {
            String msg = mMessages.getString("HTTPBC-E00776.Failed_create_soap_normalizer");
            mLog.log(Level.SEVERE, msg, fce);
            throw new IllegalStateException(msg);
        }
        catch (TransformerException tex) {
            String msg = mMessages.getString("Unable to obtain normalized message as DOM");
            throw new MessagingException(msg, (Throwable)tex);
        }
        catch (WrapperProcessingException ex) {
            String msg = mMessages.getString("HTTPBC-E00799.Denormalize_fail");
            throw new MessagingException(msg, (Throwable)ex);
        }
        catch (Exception ex) {
            String msg = mMessages.getString("HTTPBC-E00799.Denormalize_fail");
            throw new MessagingException(msg, (Throwable)ex);
        }
        finally {
            if (this.mMeasurement != null) {
                this.mMeasurement.end();
            }
        }
    }

    private void copyNode(Node src, Node dest) {
        NodeList nl = src.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            n = dest.getOwnerDocument().importNode(n, true);
            dest.appendChild(n);
        }
        NamedNodeMap attrs = src.getAttributes();
        NamedNodeMap destAttrs = dest.getAttributes();
        if (attrs != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                Node attr = attrs.item(i);
                Node n = dest.getOwnerDocument().importNode(attr, true);
                if (destAttrs == null) continue;
                destAttrs.setNamedItemNS(n);
            }
        }
    }

    private void processSoapFault(Element normalRoot, SOAPMessage outSoapMessage, OperationMetaData meta, boolean inMsg, WrapperParser wrapperParser) throws MessagingException, SOAPException, WrapperProcessingException {
        DetailEntry de;
        Name name;
        Detail detail;
        String tagName = null;
        if (wrapperParser.isMessageWrapped()) {
            Map definedFaults;
            tagName = wrapperParser.getMessageType().getLocalPart();
            List headerList = null;
            headerList = inMsg ? meta.getInputSoapHeaders() : meta.getOutputSoapHeaders();
            if (headerList != null && headerList.size() > 0) {
                SOAPHeader soapHeader = outSoapMessage.getSOAPHeader();
                for (int i = 0; i < headerList.size(); ++i) {
                    javax.wsdl.extensions.soap.SOAPHeader headerDef = (javax.wsdl.extensions.soap.SOAPHeader)headerList.get(i);
                    List soapHeaderFaults = headerDef.getSOAPHeaderFaults();
                    if (soapHeaderFaults == null || soapHeaderFaults.size() <= 0) continue;
                    for (int hfCount = 0; hfCount < soapHeaderFaults.size(); ++hfCount) {
                        SOAPHeaderFault hf = (SOAPHeaderFault)soapHeaderFaults.get(hfCount);
                        QName hfMsgName = hf.getMessage();
                        String hfPartName = hf.getPart();
                        if (!wrapperParser.hasPart(hfPartName)) continue;
                        SOAPFault fault = outSoapMessage.getSOAPBody().addFault();
                        String faultCode = outSoapMessage.getSOAPPart().getEnvelope().getPrefix() + ":" + "Client";
                        fault.setFaultCode(faultCode);
                        fault.setFaultString("headerfault");
                        Message wsMessage = meta.getFullDefinition().getMessage(hfMsgName);
                        if (wsMessage == null) {
                            mLog.log(Level.WARNING, "HTTPBC-W00704.Headerfault_bad_message_reference", hfMsgName);
                        } else {
                            Part wsdlPart = wsMessage.getPart(hfPartName);
                            if (wsdlPart == null) {
                                mLog.log(Level.WARNING, "HTTPBC-W00702.Headerfault_bad_message_part_reference", new Object[]{hfMsgName, hfPartName});
                            } else {
                                QName partElemQName = wsdlPart.getElementName();
                                if (partElemQName == null) {
                                    String msg = mMessages.getString("HTTPBC-W00703.Part_non_element_type_not_supported", new Object[]{hfPartName, wsMessage.getQName()});
                                    throw new IllegalStateException(msg);
                                }
                                Name name2 = this.mSoapFactory.createName(partElemQName.getLocalPart(), partElemQName.getPrefix(), partElemQName.getNamespaceURI());
                                SOAPHeaderElement headerElem = soapHeader.addHeaderElement(name2);
                                boolean found = false;
                                NodeList unwrappedList = wrapperParser.getPartNodes(hfPartName);
                                for (int j = 0; j < unwrappedList.getLength(); ++j) {
                                    Node unwrapped = unwrappedList.item(j);
                                    if (unwrapped.getLocalName() == null || !unwrapped.getLocalName().equals(partElemQName.getLocalPart())) continue;
                                    this.copyNode(unwrapped, (Node)headerElem);
                                    found = true;
                                    break;
                                }
                                if (!found) {
                                    String msg = mMessages.getString("HTTPBC-W00705.Message_missing_element", new Object[]{hfPartName, partElemQName.getLocalPart()});
                                    throw new IllegalStateException(msg);
                                }
                            }
                        }
                        if (mLog.isLoggable(Level.FINE)) {
                            DebugLog.debugLog(mLog, Level.FINE, "Denormalized SOAP headerfault", (Document)outSoapMessage.getSOAPPart());
                        }
                        return;
                    }
                }
            }
            if ((definedFaults = meta.getFaults()) != null && definedFaults.size() > 0) {
                for (Fault f : definedFaults.values()) {
                    Message msg = f.getMessage();
                    QName faultMsgName = msg.getQName();
                    if (!tagName.equals(faultMsgName.getLocalPart())) continue;
                    SOAPFault fault = outSoapMessage.getSOAPBody().addFault();
                    String faultCode = outSoapMessage.getSOAPPart().getEnvelope().getPrefix() + ":" + "Client";
                    fault.setFaultCode(faultCode);
                    String faultName = f.getName();
                    fault.setFaultString(faultName);
                    Detail detail2 = fault.addDetail();
                    List l = msg.getOrderedParts(null);
                    for (int i = 0; l != null && i < l.size(); ++i) {
                        Part p = (Part)l.get(i);
                        tagName = p.getName();
                        String partName = tagName;
                        if (!wrapperParser.hasPart(partName)) continue;
                        NodeList detailList = wrapperParser.getPartNodes(partName);
                        for (int j = 0; j < detailList.getLength(); ++j) {
                            DetailEntry de2;
                            Name name3;
                            Node detailnode = detailList.item(j);
                            if (detailnode.getNodeType() == 3) {
                                name3 = this.mSoapFactory.createName(tagName, "", "");
                                de2 = detail2.addDetailEntry(name3);
                                de2.addTextNode(detailnode.getNodeValue());
                                continue;
                            }
                            name3 = this.mSoapFactory.createName(detailnode.getLocalName(), "", detailnode.getNamespaceURI());
                            de2 = detail2.addDetailEntry(name3);
                            NodeList nl = detailnode.getChildNodes();
                            for (int k = 0; k < nl.getLength(); ++k) {
                                Node n2 = nl.item(k);
                                n2 = outSoapMessage.getSOAPBody().getOwnerDocument().importNode(n2, true);
                                de2.appendChild(n2);
                            }
                        }
                    }
                    if (mLog.isLoggable(Level.FINE)) {
                        DebugLog.debugLog(mLog, Level.FINE, "Denormalized SOAP fault", (Document)outSoapMessage.getSOAPPart());
                    }
                    return;
                }
                String msg = mMessages.getString("HTTPBC-W00706.Fault_not_for_operation", (Object)meta.getOperationName());
                mLog.log(Level.WARNING, msg);
            } else {
                String msg = mMessages.getString("HTTPBC-W00707.Operation_no_faults", (Object)meta.getOperationName());
                mLog.log(Level.WARNING, msg);
            }
        }
        SOAPFault fault = outSoapMessage.getSOAPBody().addFault();
        String faultCode = outSoapMessage.getSOAPPart().getEnvelope().getPrefix() + ":" + "Server";
        fault.setFaultCode(faultCode);
        fault.setFaultString("");
        if (tagName != null) {
            detail = fault.addDetail();
            name = this.mSoapFactory.createName(tagName);
            de = detail.addDetailEntry(name);
            if (normalRoot != null) {
                this.copyNode(normalRoot, (Node)de);
            }
        } else if (normalRoot != null) {
            detail = fault.addDetail();
            name = this.mSoapFactory.createName(normalRoot.getLocalName());
            de = detail.addDetailEntry(name);
            this.copyNode(normalRoot, (Node)de);
        }
        if (mLog.isLoggable(Level.FINE)) {
            DebugLog.debugLog(mLog, Level.FINE, "Denormalized SOAP fault", (Document)outSoapMessage.getSOAPPart());
        }
    }

    private void processSoapHeader(MessageExchange exchange, SOAPMessage outSoapMessage, OperationMetaData meta, boolean inMsg, WrapperParser wrapperParser, Map jbiMessageNSs) throws MessagingException, SOAPException, WrapperProcessingException {
        String messageID;
        List headerList = null;
        headerList = inMsg ? meta.getInputSoapHeaders() : meta.getOutputSoapHeaders();
        if (outSoapMessage.getSOAPHeader() == null) {
            outSoapMessage.getSOAPPart().getEnvelope().addHeader();
        }
        SOAPHeader soapHeader = outSoapMessage.getSOAPHeader();
        NormalizedMessage inNormalMsg = exchange.getMessage(IN_MSG);
        if (inNormalMsg != null && (messageID = (String)inNormalMsg.getProperty("com.stc.jbi.messaging.messageid")) != null) {
            Name msgIDHeaderName = this.mSoapFactory.createName("MessageID", null, "http://schemas.stc.com/ws/2005/07/custrm");
            SOAPHeaderElement headerElem = soapHeader.addHeaderElement(msgIDHeaderName);
            headerElem.setTextContent(messageID);
        }
        if (this.mIsHeaderCopyEnabled && inNormalMsg != null) {
            this.extractSOAPHeadersProperty(soapHeader, inNormalMsg);
        }
        if ((headerList == null || headerList.size() < 1) && inNormalMsg.getProperty("com.stc.jbi.messaging.messageid") == null) {
            outSoapMessage.getSOAPHeader().detachNode();
            return;
        }
        Message wsMessage = null;
        wsMessage = inMsg ? meta.getInputMessage() : meta.getOutputMessage();
        for (int i = 0; i < headerList.size(); ++i) {
            javax.wsdl.extensions.soap.SOAPHeader headerDef = (javax.wsdl.extensions.soap.SOAPHeader)headerList.get(i);
            String partName = headerDef.getPart();
            if (wrapperParser.hasPart(partName)) {
                Part wsdlPart = wsMessage.getPart(partName);
                if (wsdlPart == null) {
                    String msg = mMessages.getString("HTTPBC-W00714.Unsupported_feature_part_in_header_not_in_message", new Object[]{partName, wsMessage.getQName()});
                    throw new IllegalStateException(msg);
                }
                QName partElemQName = wsdlPart.getElementName();
                if (partElemQName == null) {
                    String msg = mMessages.getString("HTTPBC-W00715.Unsupported_feature_part_in_header_not_element", new Object[]{partName, wsMessage.getQName()});
                    mLog.log(Level.WARNING, msg);
                }
                Name name = this.mSoapFactory.createName(partElemQName.getLocalPart(), partElemQName.getPrefix(), partElemQName.getNamespaceURI());
                SOAPHeaderElement headerElem = soapHeader.addHeaderElement(name);
                Node e2 = null;
                NodeList unwrappedList = wrapperParser.getPartNodes(partName);
                if (unwrappedList == null) continue;
                for (int j = 0; j < unwrappedList.getLength(); ++j) {
                    Node unwrapped = unwrappedList.item(j);
                    if (unwrapped.getLocalName() == null || !unwrapped.getLocalName().equals(partElemQName.getLocalPart())) continue;
                    e2 = unwrapped;
                    break;
                }
                if (e2 != null) {
                    Map jbiWrappedPartNSs;
                    this.copyNode(e2, (Node)headerElem);
                    HashMap partElemNSs = jbiMessageNSs != null ? new HashMap(jbiMessageNSs) : new HashMap();
                    Element jbiWrappedPart = wrapperParser.getWrappedPart(partName);
                    if (jbiWrappedPart != null && (jbiWrappedPartNSs = WrapperUtil.extractNamespaceDeclarations((Element)jbiWrappedPart)) != null) {
                        if (mLog.isLoggable(Level.FINE)) {
                            DebugLog.debugLog(mLog, Level.FINE, "JBI part '" + partName + "' namespaces", jbiWrappedPartNSs);
                        }
                        partElemNSs.putAll(jbiWrappedPartNSs);
                    }
                    this.copyNameSpaces((Element)headerElem, partElemNSs);
                    continue;
                }
                String err = mMessages.getString("HTTPBC-W00703.Part_non_element_type_not_supported", new Object[]{partElemQName.getLocalPart(), wsMessage.getQName().toString()});
                throw new IllegalArgumentException(err);
            }
            String msg = mMessages.getString("HTTPBC-W00701.Message_has_no_match_for_part", (Object)partName);
            mLog.warning(msg);
        }
        if (mLog.isLoggable(Level.FINE)) {
            DebugLog.debugLog(mLog, Level.FINE, "Denormalized SOAP header", (Element)soapHeader);
        }
    }

    private void processRpcBody(SOAPMessage outSoapMessage, OperationMetaData meta, boolean inMsg, WrapperParser wrapperParser, Map jbiMessageNSs) throws MessagingException, SOAPException, WrapperProcessingException {
        javax.xml.soap.SOAPBody bodyElement = outSoapMessage.getSOAPBody();
        Message msg = null;
        msg = inMsg ? meta.getInputMessage() : meta.getOutputMessage();
        SOAPBody soapBody = null;
        soapBody = inMsg ? meta.getInputSoapBody() : meta.getOutputSoapBody();
        List bodyParts = soapBody.getParts();
        Iterator bodyIterator = null;
        if (bodyParts != null && bodyParts.size() > 0) {
            bodyIterator = bodyParts.iterator();
        } else {
            if (msg == null) {
                throw new IllegalStateException("Unexpected state, input WSDLMessage is not defined, however we are attempting to invoke the operation with non-empty input");
            }
            List msgParts = msg.getOrderedParts(null);
            if (msgParts != null && msgParts.size() > 0) {
                bodyIterator = msgParts.iterator();
            } else {
                String wrapperName = meta.getOperationName();
                String wrapperNS = soapBody.getNamespaceURI();
                if (wrapperNS != null && wrapperNS.length() > 0) {
                    wrapperName = "m:" + wrapperName;
                }
                if (!inMsg) {
                    wrapperName = wrapperName + RPC_RESPONSE_SUFFIX;
                }
                Element wrapper = bodyElement.getOwnerDocument().createElementNS(wrapperNS, wrapperName);
                bodyElement.appendChild((Node)wrapper);
                if (mLog.isLoggable(Level.FINE)) {
                    DebugLog.debugLog(mLog, Level.FINE, "RPC - Denormalized SOAP body", bodyElement.getOwnerDocument());
                }
                return;
            }
        }
        while (bodyIterator != null && bodyIterator.hasNext()) {
            Map jbiWrappedPartNSs;
            Element jbiWrappedPart;
            HashMap partElemNSs;
            Node n;
            Node unwrapped;
            NodeList unwrappedList;
            String prefix;
            String namespace;
            Element partElem;
            Element wrapper;
            String wrapperNS;
            String wrapperName;
            Element bodyElementRoot;
            String partName;
            Part part = null;
            int nsCount = 0;
            Object value = bodyIterator.next();
            if (value instanceof String) {
                if (msg == null) {
                    throw new IllegalStateException("Unexpected state, input WSDLMessage is not defined, however we are attempting to invoke the operation with non-empty input");
                }
                String bodyPart = partName = (String)value;
                part = msg.getPart(bodyPart);
            } else {
                part = (Part)value;
                String string = partName = part == null ? null : part.toString();
            }
            if (part == null) {
                String err = mMessages.getString("HTTPBC-E00702.Message_part_bad_reference", new Object[]{partName, msg.getQName().toString()});
                throw new IllegalStateException(err);
            }
            QName typeQName = part.getTypeName();
            QName elemQName = part.getElementName();
            if (typeQName != null) {
                if (mLog.isLoggable(Level.FINEST)) {
                    mLog.log(Level.FINEST, "Looking for part " + part.getName() + " in normalized message");
                }
                if (wrapperParser.hasPart(part.getName())) {
                    if (mLog.isLoggable(Level.FINEST)) {
                        mLog.log(Level.FINEST, "Creating SOAP node in rpc-literal mode with types");
                    }
                    if ((bodyElementRoot = (Element)bodyElement.getFirstChild()) == null) {
                        wrapperName = meta.getOperationName();
                        wrapperNS = soapBody.getNamespaceURI();
                        if (wrapperNS != null && wrapperNS.length() > 0) {
                            wrapperName = "m:" + wrapperName;
                        }
                        if (!inMsg) {
                            wrapperName = wrapperName + RPC_RESPONSE_SUFFIX;
                        }
                        wrapper = bodyElement.getOwnerDocument().createElementNS(wrapperNS, wrapperName);
                        bodyElement.appendChild((Node)wrapper);
                    } else {
                        wrapper = bodyElementRoot;
                    }
                    bodyElement.getOwnerDocument().importNode(wrapper, true);
                    bodyElement.appendChild((Node)wrapper);
                    partElem = bodyElement.getOwnerDocument().createElement(part.getName());
                    if ("encoded".equalsIgnoreCase(soapBody.getUse())) {
                        namespace = outSoapMessage.getSOAPPart().getEnvelope().lookupNamespaceURI(part.getTypeName().getNamespaceURI());
                        prefix = meta.getFullDefinition().getPrefix(part.getTypeName().getNamespaceURI());
                        if (prefix == null || prefix.equals("")) {
                            if (namespace == null) {
                                outSoapMessage.getSOAPPart().getEnvelope().setAttribute("xmlns:ns" + nsCount++, part.getTypeName().getNamespaceURI());
                                part.getTypeName().getNamespaceURI();
                            }
                            partElem.setAttributeNS(SCHEMA_XSI_URI_2001, "xsi:type", part.getTypeName().getLocalPart());
                        } else {
                            if (namespace == null) {
                                outSoapMessage.getSOAPPart().getEnvelope().setAttribute("xmlns:" + meta.getFullDefinition().getPrefix(part.getTypeName().getNamespaceURI()), part.getTypeName().getNamespaceURI());
                            }
                            partElem.setAttributeNS(SCHEMA_XSI_URI_2001, "xsi:type", prefix + ":" + part.getTypeName().getLocalPart());
                        }
                    }
                    wrapper.appendChild(partElem);
                    unwrappedList = wrapperParser.getPartNodes(part.getName());
                    if (unwrappedList != null) {
                        for (int i = 0; i < unwrappedList.getLength(); ++i) {
                            unwrapped = unwrappedList.item(i);
                            n = bodyElement.getOwnerDocument().importNode(unwrapped, true);
                            partElem.appendChild(n);
                        }
                    }
                    partElemNSs = jbiMessageNSs != null ? new HashMap(jbiMessageNSs) : new HashMap();
                    jbiWrappedPart = wrapperParser.getWrappedPart(part.getName());
                    if (jbiWrappedPart != null && (jbiWrappedPartNSs = WrapperUtil.extractNamespaceDeclarations((Element)jbiWrappedPart)) != null) {
                        if (mLog.isLoggable(Level.FINE)) {
                            DebugLog.debugLog(mLog, Level.FINE, "JBI part '" + part.getName() + "' namespaces", jbiWrappedPartNSs);
                        }
                        partElemNSs.putAll(jbiWrappedPartNSs);
                    }
                    this.copyNameSpaces(partElem, partElemNSs);
                    continue;
                }
                mLog.log(Level.WARNING, "HTTPBC-W00701.Message_has_no_match_for_part", part.getName());
                continue;
            }
            if (elemQName != null) {
                if (mLog.isLoggable(Level.FINEST)) {
                    mLog.log(Level.FINEST, "Looking for part " + part.getName() + " in normalized message");
                }
                if (wrapperParser.hasPart(part.getName())) {
                    if (mLog.isLoggable(Level.FINEST)) {
                        mLog.log(Level.FINEST, "Creating SOAP node for rpc-literal mode with elements");
                    }
                    if ((bodyElementRoot = (Element)bodyElement.getFirstChild()) == null) {
                        wrapperName = meta.getOperationName();
                        wrapperNS = soapBody.getNamespaceURI();
                        if (wrapperNS != null && wrapperNS.length() > 0) {
                            wrapperName = "m:" + wrapperName;
                        }
                        if (!inMsg) {
                            wrapperName = wrapperName + RPC_RESPONSE_SUFFIX;
                        }
                        wrapper = bodyElement.getOwnerDocument().createElementNS(wrapperNS, wrapperName);
                        bodyElement.appendChild((Node)wrapper);
                    } else {
                        wrapper = bodyElementRoot;
                    }
                    partElem = bodyElement.getOwnerDocument().createElement(part.getName());
                    if ("encoded".equalsIgnoreCase(soapBody.getUse())) {
                        namespace = outSoapMessage.getSOAPPart().getEnvelope().lookupNamespaceURI(part.getElementName().getNamespaceURI());
                        prefix = meta.getFullDefinition().getPrefix(part.getElementName().getNamespaceURI());
                        if (prefix == null || prefix.equals("")) {
                            if (namespace == null) {
                                outSoapMessage.getSOAPPart().getEnvelope().setAttribute("xmlns:ns" + nsCount++, part.getElementName().getNamespaceURI());
                            }
                            partElem.setAttributeNS(SCHEMA_XSI_URI_2001, "xsi:type", part.getElementName().getLocalPart());
                        } else {
                            if (namespace == null) {
                                outSoapMessage.getSOAPPart().getEnvelope().setAttribute("xmlns:" + meta.getFullDefinition().getPrefix(part.getElementName().getNamespaceURI()), part.getElementName().getNamespaceURI());
                            }
                            partElem.setAttributeNS(SCHEMA_XSI_URI_2001, "xsi:type", prefix + ":" + part.getElementName().getLocalPart());
                        }
                    }
                    wrapper.appendChild(partElem);
                    unwrappedList = wrapperParser.getPartNodes(part.getName());
                    if (unwrappedList != null) {
                        for (int i = 0; i < unwrappedList.getLength(); ++i) {
                            unwrapped = unwrappedList.item(i);
                            n = bodyElement.getOwnerDocument().importNode(unwrapped, true);
                            partElem.appendChild(n);
                        }
                    }
                    partElemNSs = jbiMessageNSs != null ? new HashMap(jbiMessageNSs) : new HashMap();
                    jbiWrappedPart = wrapperParser.getWrappedPart(part.getName());
                    if (jbiWrappedPart != null && (jbiWrappedPartNSs = WrapperUtil.extractNamespaceDeclarations((Element)jbiWrappedPart)) != null) {
                        if (mLog.isLoggable(Level.FINE)) {
                            DebugLog.debugLog(mLog, Level.FINE, "JBI part '" + part.getName() + "' namespaces", jbiWrappedPartNSs);
                        }
                        partElemNSs.putAll(jbiWrappedPartNSs);
                    }
                    this.copyNameSpaces(partElem, partElemNSs);
                    continue;
                }
                mLog.log(Level.WARNING, "HTTPBC-W00701.Message_has_no_match_for_part", part.getName());
                continue;
            }
            mLog.log(Level.SEVERE, "HTTPBC-E00783.Part_not_element_nor_type", part.getName());
        }
        if (mLog.isLoggable(Level.FINEST)) {
            DebugLog.debugLog(mLog, Level.FINEST, "RPC - Denormalized SOAP body", bodyElement.getOwnerDocument());
        }
    }

    private void processDocBody(SOAPMessage outSoapMessage, OperationMetaData meta, boolean inMsg, WrapperParser wrapperParser, Map jbiMessageNSs) throws MessagingException, SOAPException, WrapperProcessingException {
        javax.xml.soap.SOAPBody bodyElement = outSoapMessage.getSOAPBody();
        Message msg = null;
        msg = inMsg ? meta.getInputMessage() : meta.getOutputMessage();
        SOAPBody soapBody = null;
        soapBody = inMsg ? meta.getInputSoapBody() : meta.getOutputSoapBody();
        List bodyParts = soapBody.getParts();
        Iterator bodyIterator = null;
        bodyIterator = bodyParts != null && bodyParts.size() > 0 ? bodyParts.iterator() : msg.getOrderedParts(null).iterator();
        while (bodyIterator != null && bodyIterator.hasNext()) {
            String partName;
            Part part = null;
            Object value = bodyIterator.next();
            if (value instanceof String) {
                String bodyPart = partName = (String)value;
                part = msg.getPart(bodyPart);
            } else {
                part = (Part)value;
                String string = partName = part == null ? null : part.toString();
            }
            if (msg == null) {
                throw new IllegalStateException("Unexpected state, input WSDLMessage is not defined, however we are attempting to invoke the operation with non-empty input");
            }
            if (part == null) {
                String err = mMessages.getString("HTTPBC-W00703.Part_non_element_type_not_supported", new Object[]{partName, msg.getQName().toString()});
                throw new IllegalStateException(err);
            }
            QName typeQName = part.getTypeName();
            QName elemQName = part.getElementName();
            if (typeQName != null) {
                if (mLog.isLoggable(Level.FINEST)) {
                    mLog.log(Level.FINEST, "Looking for part " + part.getName() + " in normalized message");
                }
                if (wrapperParser.hasPart(part.getName())) {
                    Map jbiWrappedPartNSs;
                    if (mLog.isLoggable(Level.FINEST)) {
                        mLog.log(Level.FINEST, "Creating SOAP node in document-literal mode with types");
                    }
                    Element srcPart = wrapperParser.getWrappedPart(part.getName());
                    Element partElem = bodyElement.getOwnerDocument().createElement(part.getName());
                    this.copyNode(srcPart, partElem);
                    bodyElement.appendChild((Node)partElem);
                    HashMap partElemNSs = jbiMessageNSs != null ? new HashMap(jbiMessageNSs) : new HashMap();
                    if (srcPart != null && (jbiWrappedPartNSs = WrapperUtil.extractNamespaceDeclarations((Element)srcPart)) != null) {
                        if (mLog.isLoggable(Level.FINE)) {
                            DebugLog.debugLog(mLog, Level.FINE, "JBI part '" + part.getName() + "' namespaces", jbiWrappedPartNSs);
                        }
                        partElemNSs.putAll(jbiWrappedPartNSs);
                    }
                    this.copyNameSpaces(partElem, partElemNSs);
                    continue;
                }
                mLog.log(Level.WARNING, "HTTPBC-W00701.Message_has_no_match_for_part", part.getName());
                continue;
            }
            if (elemQName != null) {
                if (mLog.isLoggable(Level.FINEST)) {
                    mLog.log(Level.FINEST, "Looking for part " + part.getName() + " in normalized message");
                }
                if (wrapperParser.hasPart(part.getName())) {
                    Node e2 = null;
                    NodeList unwrappedList = wrapperParser.getPartNodes(part.getName());
                    if (unwrappedList != null) {
                        Probe m = Probe.fine(this.getClass(), (String)"findDocumentElement");
                        for (int i = 0; i < unwrappedList.getLength(); ++i) {
                            Map jbiWrappedPartNSs;
                            Node unwrapped = unwrappedList.item(i);
                            if (elemQName.getLocalPart().equals(unwrapped.getLocalName())) {
                                e2 = unwrapped;
                            }
                            if (e2 == null) continue;
                            if (mLog.isLoggable(Level.FINEST)) {
                                mLog.log(Level.FINEST, "Creating SOAP message for document-literal mode with elements");
                            }
                            Node n = bodyElement.getOwnerDocument().importNode(e2, true);
                            bodyElement.appendChild(n);
                            if (!(n instanceof Element)) break;
                            HashMap partElemNSs = jbiMessageNSs != null ? new HashMap(jbiMessageNSs) : new HashMap();
                            Element jbiWrappedPart = wrapperParser.getWrappedPart(part.getName());
                            if (jbiWrappedPart != null && (jbiWrappedPartNSs = WrapperUtil.extractNamespaceDeclarations((Element)jbiWrappedPart)) != null) {
                                if (mLog.isLoggable(Level.FINE)) {
                                    DebugLog.debugLog(mLog, Level.FINE, "JBI part '" + part.getName() + "' namespaces", jbiWrappedPartNSs);
                                }
                                partElemNSs.putAll(jbiWrappedPartNSs);
                            }
                            this.copyNameSpaces((Element)n, partElemNSs);
                            break;
                        }
                        if (m != null) {
                            m.end();
                        }
                    }
                    if (e2 != null) continue;
                    String err = mMessages.getString("HTTPBC-W00703.Part_non_element_type_not_supported", new Object[]{elemQName.getLocalPart(), msg.getQName().toString()});
                    throw new IllegalArgumentException(err);
                }
                mLog.log(Level.WARNING, "HTTPBC-W00701.Message_has_no_match_for_part", part.getName());
                continue;
            }
            throw new IllegalArgumentException(mMessages.getString("HTTPBC-E00783.Part_not_element_nor_type", (Object)part.getName()));
        }
        if (mLog.isLoggable(Level.FINEST)) {
            DebugLog.debugLog(mLog, Level.FINEST, "Document - Denormalized SOAP Body", (Element)outSoapMessage.getSOAPBody());
        }
    }

    private void processSoapBody(SOAPMessage outSoapMessage, OperationMetaData meta, boolean inMsg, WrapperParser wrapperParser, Map jbiMessageNSs) throws MessagingException, SOAPException, WrapperProcessingException {
        if (meta.isDocumentMode()) {
            this.processDocBody(outSoapMessage, meta, inMsg, wrapperParser, jbiMessageNSs);
        } else {
            this.processRpcBody(outSoapMessage, meta, inMsg, wrapperParser, jbiMessageNSs);
        }
    }

    private void copyNameSpaces(Element elem, Map namespaces) {
        if (elem == null || namespaces == null) {
            return;
        }
        Set keys = namespaces.keySet();
        for (String prefix : keys) {
            String nsURI = (String)namespaces.get(prefix);
            String normalizedURI = nsURI.trim();
            String string = normalizedURI = normalizedURI.endsWith("/") ? new StringBuffer(normalizedURI).deleteCharAt(normalizedURI.length() - 1).toString() : normalizedURI;
            if (mStandardNamespaceURIs.containsKey(normalizedURI)) {
                if (!elem.hasAttribute(prefix)) continue;
                elem.removeAttribute(prefix);
                continue;
            }
            boolean foundMatching = false;
            for (String standardURI : mStandardNamespaceURIs.keySet()) {
                if (!nsURI.contains(standardURI) && !standardURI.contains(nsURI)) continue;
                foundMatching = true;
                if (!elem.hasAttribute(prefix)) break;
                elem.removeAttribute(prefix);
                break;
            }
            if (foundMatching) continue;
            elem.setAttributeNS(SCHEMA_XMLNS_URI_2000, prefix.startsWith("xmlns:") ? prefix : "xmlns:" + prefix, nsURI);
        }
    }

    private void extractSOAPHeadersProperty(SOAPHeader soapHeader, NormalizedMessage normalMsg) throws SOAPException {
        Map propertyMap = (Map)normalMsg.getProperty(SOAP_HEADERS_PROPERTY);
        if (propertyMap != null) {
            for (DocumentFragment frag : propertyMap.values()) {
                Element aHeader = (Element)frag.getChildNodes().item(0);
                String nsuri = aHeader.getNamespaceURI();
                String localname = aHeader.getLocalName();
                QName name = nsuri == null ? new QName("", localname) : new QName(nsuri, localname);
                SOAPHeaderElement headerElem = soapHeader.addHeaderElement(name);
                this.copyNode(aHeader, (Node)headerElem);
            }
        }
    }

    static {
        mStandardNamespaceURIs.put("http://schemas.xmlsoap.org/soap/envelope", "http://schemas.xmlsoap.org/soap/envelope");
        mStandardNamespaceURIs.put(SCHEMA_XSD_URI_1999, SCHEMA_XSD_URI_1999);
        mStandardNamespaceURIs.put(SCHEMA_XSI_URI_1999, SCHEMA_XSI_URI_1999);
        mStandardNamespaceURIs.put(SCHEMA_XSD_URI_2001, SCHEMA_XSD_URI_2001);
        mStandardNamespaceURIs.put(SCHEMA_XSI_URI_2001, SCHEMA_XSI_URI_2001);
    }
}

