/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc;

import com.sun.jbi.httpsoapbc.OperationMetaData;
import com.sun.jbi.httpsoapbc.util.DebugLog;
import com.sun.jbi.internationalization.Messages;
import com.sun.jbi.nms.wsdl11wrapper.HelperFactory;
import com.sun.jbi.nms.wsdl11wrapper.WrapperBuilder;
import com.sun.jbi.nms.wsdl11wrapper.WrapperProcessingException;
import com.sun.jbi.nms.wsdl11wrapper.util.WrapperUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.wsdl.Fault;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.Detail;
import javax.xml.soap.DetailEntry;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.ws.handler.MessageContext;
import net.java.hulp.measure.Probe;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SoapNormalizer {
    public static final String CUSTOM_RELIABILITY_MESSAGE_ID_PROPERTY = "com.stc.jbi.messaging.messageid";
    public static final String CUSTOM_RELIABILITY_HEADER_NAMESPACE_URI = "http://schemas.stc.com/ws/2005/07/custrm";
    public static final String CUSTOM_RELIABILITY_HEADER_LOCAL_NAME = "MessageID";
    public static final String SOAP_HEADERS_PROPERTY = "com.sun.jbi.headers.soap";
    public static final String HTTP_HEADERS_PROPERTY = "com.sun.jbi.headers.http";
    public static final String CRMP_GROUP_ID = "com.sun.jbi.messaging.groupid";
    public static final String CRMP_MESSAGE_ID = "com.sun.jbi.messaging.messageid";
    public static final String WSRM__1_0__NAMESPACE_URI = "http://schemas.xmlsoap.org/ws/2005/02/rm";
    public static final String WSRM__1_1__NAMESPACE_URI = "http://docs.oasis-open.org/ws-rx/wsrm/200702";
    public static final String WSRM_Sequence = "Sequence";
    public static final String WSRM_Sequence_Identifier = "Identifier";
    public static final String WSRM_Sequence_MessageNumber = "MessageNumber";
    public static final QName QNAME_WSRM__1_0__Sequence_Identifier = new QName("http://schemas.xmlsoap.org/ws/2005/02/rm", "Identifier");
    public static final QName QNAME_WSRM__1_0__Sequence_MessageNumber = new QName("http://schemas.xmlsoap.org/ws/2005/02/rm", "MessageNumber");
    public static final QName QNAME_WSRM__1_1__Sequence_Identifier = new QName("http://docs.oasis-open.org/ws-rx/wsrm/200702", "Identifier");
    public static final QName QNAME_WSRM__1_1__Sequence_MessageNumber = new QName("http://docs.oasis-open.org/ws-rx/wsrm/200702", "MessageNumber");
    private static Messages mMessages = Messages.getMessages(SoapNormalizer.class);
    private static Logger mLog = Messages.getLogger(SoapNormalizer.class);
    private boolean mIsHeaderCopyEnabled = false;
    private Probe mMeasurement = null;

    public NormalizedMessage normalize(Object message, MessageExchange exchange, OperationMetaData meta, boolean inMsg, MessageContext context) throws MessagingException, SOAPException {
        NormalizedMessage normalMsg = exchange.createMessage();
        try {
            String topic = "normalize" + (inMsg ? "Request" : "Reply");
            this.mMeasurement = Probe.fine(this.getClass(), (String)topic);
            WrapperBuilder wrapperBuilder = HelperFactory.createBuilder();
            SOAPMessage soapMessage = (SOAPMessage)message;
            Map soapEnvelopeNSs = new HashMap();
            SOAPPart soapPart = soapMessage.getSOAPPart();
            if (soapPart != null) {
                SOAPEnvelope soapEnvelope = soapMessage.getSOAPPart().getEnvelope();
                soapEnvelopeNSs = WrapperUtil.extractNamespaceDeclarations((Element)soapEnvelope);
            }
            wrapperBuilder.declareGlobalNS(soapEnvelopeNSs);
            if (mLog.isLoggable(Level.FINE)) {
                DebugLog.debugLog(mLog, Level.FINE, "SOAP envelope namespaces", soapEnvelopeNSs);
            }
            Object type = null;
            String name = null;
            Message msg = null;
            if (inMsg) {
                name = meta.getInMsgName();
                msg = meta.getInputMessage();
            } else {
                name = meta.getOutMsgName();
                msg = meta.getOutputMessage();
            }
            wrapperBuilder.initialize(msg, name);
            javax.xml.soap.SOAPBody soapBody = soapMessage.getSOAPBody();
            if (mLog.isLoggable(Level.FINE)) {
                DebugLog.debugLog(mLog, Level.FINE, "SOAP body to normalize", (Element)soapBody);
            }
            this.processSoapBody(wrapperBuilder, soapBody, meta, inMsg);
            SOAPHeader soapHeader = soapMessage.getSOAPHeader();
            if (mLog.isLoggable(Level.FINE)) {
                DebugLog.debugLog(mLog, Level.FINE, "SOAP header to normalize", (Element)soapHeader);
            }
            this.processSoapHeader(wrapperBuilder, normalMsg, soapHeader, meta, inMsg, exchange);
            if (this.mIsHeaderCopyEnabled && context != null && inMsg) {
                this.processHTTPRequestHeaders(normalMsg, context);
            }
            Document normalDoc = wrapperBuilder.getResult();
            if (mLog.isLoggable(Level.FINE)) {
                DebugLog.debugLog(mLog, Level.FINE, "Normalized message", normalDoc);
            }
            normalMsg.setContent((Source)new DOMSource(normalDoc));
        }
        catch (ParserConfigurationException tex) {
            throw new MessagingException(mMessages.getString("HTTPBC-E00798.Normalize_fail", (Object)tex.getLocalizedMessage()), (Throwable)tex);
        }
        catch (WrapperProcessingException ex) {
            throw new MessagingException(mMessages.getString("HTTPBC-E00798.Normalize_fail", (Object)ex.getLocalizedMessage()), (Throwable)ex);
        }
        catch (ClassCastException ex) {
            String msg = mMessages.getString("HTTPBC-E00797.Normalize_fail_wrong_type", new Object[]{"SOAPMessage", message.getClass().toString()});
            throw new MessagingException(msg, (Throwable)ex);
        }
        catch (Exception ex) {
            throw new MessagingException(mMessages.getString("HTTPBC-E00798.Normalize_fail", (Object)ex.getLocalizedMessage()), (Throwable)ex);
        }
        finally {
            if (this.mMeasurement != null) {
                this.mMeasurement.end();
            }
        }
        return normalMsg;
    }

    public javax.jbi.messaging.Fault normalizeFault(SOAPMessage soapMessage, MessageExchange exchange, OperationMetaData meta, boolean failFast) throws MessagingException, SOAPException {
        return this.normalizeFault(soapMessage.getSOAPBody().getFault(), exchange, meta, failFast);
    }

    public javax.jbi.messaging.Fault normalizeFault(SOAPFault soapFault, MessageExchange exchange, OperationMetaData meta, boolean failFast) throws MessagingException, SOAPException {
        javax.jbi.messaging.Fault normalFault = exchange.createFault();
        boolean hasMatchingDefinedFault = false;
        boolean hasFaultDetail = false;
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document normalDoc = docBuilder.newDocument();
            normalFault.setContent((Source)new DOMSource(normalDoc));
            Element normalRoot = null;
            Detail detail = soapFault.getDetail();
            boolean bl = hasFaultDetail = detail != null;
            if (hasFaultDetail) {
                Map definedFaults = meta.getFaults();
                Message foundFault = null;
                String foundFaultName = null;
                Part foundPart = null;
                Iterator detailIterator = detail.getDetailEntries();
                while (detailIterator != null && detailIterator.hasNext() && foundFault == null) {
                    DetailEntry de = (DetailEntry)detailIterator.next();
                    String detailName = de.getLocalName();
                    String detailElemURI = de.getElementName().getURI();
                    String detailElemLocalName = de.getElementName().getLocalName();
                    Iterator faultsIter = definedFaults.entrySet().iterator();
                    while (faultsIter.hasNext() && foundFault == null) {
                        Map.Entry entry = faultsIter.next();
                        String faultName = (String)entry.getKey();
                        Fault wsdlFault = (Fault)entry.getValue();
                        Message faultMsg = wsdlFault.getMessage();
                        Map partNamesToParts = faultMsg.getParts();
                        Iterator partsIter = partNamesToParts.values().iterator();
                        if (partsIter.hasNext()) {
                            Part part = (Part)partsIter.next();
                            QName partElemName = part.getElementName();
                            QName partTypeName = part.getTypeName();
                            if (partElemName != null) {
                                String partElemURI = partElemName.getNamespaceURI();
                                String partElemLocalName = partElemName.getLocalPart();
                                if ((detailElemURI != null || partElemURI != null) && (detailElemURI == null || !detailElemURI.equals(partElemURI)) || !detailElemLocalName.equals(partElemLocalName)) continue;
                                foundFault = faultMsg;
                                foundFaultName = faultName;
                                foundPart = part;
                                continue;
                            }
                            if (partTypeName == null || !detailElemLocalName.equals(part.getName())) continue;
                            foundFault = faultMsg;
                            foundFaultName = faultName;
                            foundPart = part;
                            continue;
                        }
                        if (!mLog.isLoggable(Level.WARNING)) continue;
                        mLog.log(Level.WARNING, "HTTPBC-W00710.Fault_message_has_no_parts", faultName);
                    }
                    boolean bl2 = hasMatchingDefinedFault = foundFault != null;
                    if (hasMatchingDefinedFault) {
                        QName type = foundFault.getQName();
                        WrapperBuilder wrapperBuilder = HelperFactory.createBuilder();
                        wrapperBuilder.initialize(normalDoc, foundFault, foundFaultName);
                        if (mLog.isLoggable(Level.FINE)) {
                            mLog.log(Level.FINE, "Found matching WSDL message for detail entry: " + detailName);
                        }
                        wrapperBuilder.addPart(foundPart.getName(), (Element)de);
                        normalDoc = wrapperBuilder.getResult();
                        continue;
                    }
                    if (mLog.isLoggable(Level.FINE)) {
                        mLog.log(Level.FINE, "Did NOT find matching WSDL message for detail entry " + detailName);
                    }
                    normalRoot = normalDoc.createElement(meta.getOperationName());
                    normalDoc.appendChild(normalRoot);
                    Node n = normalDoc.importNode((Node)de, true);
                    normalRoot.appendChild(n);
                }
            }
            if (mLog.isLoggable(Level.FINE)) {
                DebugLog.debugLog(mLog, Level.FINE, "SOAP Fault to normalize", normalDoc);
            }
        }
        catch (ParserConfigurationException ex) {
            throw new MessagingException(mMessages.getString("HTTPBC-E00809_Failed_to_create_document_builder"), (Throwable)ex);
        }
        catch (WrapperProcessingException ex) {
            throw new MessagingException(mMessages.getString("HTTPBC-E00798.Normalize_fail", (Object)ex.getLocalizedMessage()), (Throwable)ex);
        }
        if (!(!failFast || hasMatchingDefinedFault && hasFaultDetail)) {
            return null;
        }
        return normalFault;
    }

    private void processSoapBody(WrapperBuilder wrapperBuilder, javax.xml.soap.SOAPBody soapElement, OperationMetaData meta, boolean inMsg) throws WrapperProcessingException, Exception {
        Map nameSpaces = WrapperUtil.extractNamespaceDeclarations((Element)soapElement);
        if (mLog.isLoggable(Level.FINE)) {
            DebugLog.debugLog(mLog, Level.FINE, "SOAP body namespaces", nameSpaces);
        }
        SOAPBody soapBody = null;
        soapBody = inMsg ? meta.getInputSoapBody() : meta.getOutputSoapBody();
        Message msg = null;
        msg = inMsg ? meta.getInputMessage() : meta.getOutputMessage();
        String msgTNS = meta.getFullDefinition().getTargetNamespace();
        if (soapBody == null) {
            return;
        }
        List bodyParts = soapBody.getParts();
        Iterator<Object> bodyIterator = null;
        if (bodyParts != null && bodyParts.size() > 0) {
            bodyIterator = bodyParts.iterator();
        } else {
            if (msg == null) {
                throw new IllegalStateException("Unexpected state, input WSDLMessage is not defined, however we are attempting to invoke the operation with non-empty input");
            }
            bodyIterator = msg.getParts().keySet().iterator();
        }
        String soapBodyURI = soapBody.getNamespaceURI();
        boolean isDocument = meta.isDocumentMode();
        boolean isRPC = !meta.isDocumentMode();
        Element operElem = null;
        if (isRPC) {
            String operationTNS;
            if (soapBodyURI != null && mLog.isLoggable(Level.FINER)) {
                mLog.log(Level.FINER, "SOAP body namespace in use: " + soapBodyURI);
            }
            if ((operElem = this.findResponsePart((Element)soapElement, new QName(operationTNS = soapBodyURI == null ? "*" : soapBodyURI, meta.getOperationName()), inMsg)) == null) {
                mLog.log(Level.WARNING, "HTTPBC-W00711.Soap_message_has_no_match_for_operation", meta.getOperationName());
                throw new WrapperProcessingException(mMessages.getString("HTTPBC-W00711.Soap_message_has_no_match_for_operation", (Object)meta.getOperationName()));
            }
            Map operElemNSs = WrapperUtil.extractNamespaceDeclarations((Element)operElem);
            if (mLog.isLoggable(Level.FINE)) {
                DebugLog.debugLog(mLog, Level.FINE, "Operation  " + operElem.getLocalName() + " namespaces", nameSpaces);
            }
            if (operElemNSs != null) {
                nameSpaces.putAll(operElemNSs);
            }
        }
        while (bodyIterator != null && bodyIterator.hasNext()) {
            boolean ELEM_RPC;
            HashMap partNameSpaces = nameSpaces != null ? new HashMap(nameSpaces) : new HashMap();
            String bodyPart = (String)bodyIterator.next();
            if (msg == null) {
                throw new IllegalStateException("Unexpected state, input WSDLMessage is not defined, however we are attempting to invoke the operation with non-empty input");
            }
            Part part = msg.getPart(bodyPart);
            if (part == null) {
                String err = mMessages.getString("HTTPBC-E00702.Message_part_bad_reference", new Object[]{bodyPart, msg.getQName().toString()});
                throw new IllegalStateException(err);
            }
            QName typeQName = part.getTypeName();
            QName elemQName = part.getElementName();
            boolean isType = typeQName != null;
            boolean isElem = elemQName != null;
            boolean TYPE_DOC = isType && isDocument;
            boolean TYPE_RPC = isType && isRPC;
            boolean ELEM_DOC = isElem && isDocument;
            boolean bl = ELEM_RPC = isElem && isRPC;
            if (mLog.isLoggable(Level.FINE)) {
                mLog.log(Level.FINE, "TYPE_DOC: " + TYPE_DOC + " TYPE_RPC: " + TYPE_RPC + " ELEM_DOC: " + ELEM_DOC + " ELEM_RPC: " + ELEM_RPC);
            }
            Element e = null;
            Object msgElem = isDocument ? soapElement : operElem;
            String lookingMsg = isType ? "Looking for part in SOAP message" : "Looking for element in normalized message";
            String nullMsg = isType ? "HTTPBC-W00712.Soap_message_has_no_match_for_part" : "HTTPBC-W00713.Soap_message_has_no_match_for_element";
            String creatingMsg = null;
            String uri = null;
            String localName = null;
            if (TYPE_DOC) {
                if (mLog.isLoggable(Level.FINE)) {
                    mLog.log(Level.FINE, "Style is Document, part " + part.getName() + " is Type, QName " + typeQName.toString());
                }
                creatingMsg = "Creating normalized message for doc-literal mode with type";
                uri = msgTNS;
                localName = part.getName();
            } else if (TYPE_RPC) {
                if (mLog.isLoggable(Level.FINE)) {
                    mLog.log(Level.FINE, "Style is RPC, part " + part.getName() + " is Type, QName " + typeQName.toString());
                }
                creatingMsg = "Creating normalized message for rpc-literal mode with type";
                uri = "*";
                localName = part.getName();
            } else if (ELEM_DOC) {
                if (mLog.isLoggable(Level.FINE)) {
                    mLog.log(Level.FINE, "Style is Document, part " + part.getName() + " is Element, QName " + elemQName.toString());
                }
                creatingMsg = "Creating normalized message for doc-literal mode with element";
                uri = elemQName.getNamespaceURI();
                localName = elemQName.getLocalPart();
            } else if (ELEM_RPC) {
                if (mLog.isLoggable(Level.FINE)) {
                    mLog.log(Level.FINE, "Style is RPC, part " + part.getName() + " is Element, QName " + elemQName.toString());
                }
                creatingMsg = "Creating normalized message for rpc-literal mode with element";
                uri = "*";
                msgElem = this.findMsgElement(operElem, new QName(uri, bodyPart));
                if (msgElem == null) {
                    throw new Exception(mMessages.getString("HTTPBC-E00802.Missing_message_part_in_RPC_element", (Object)bodyPart));
                }
                localName = elemQName.getLocalPart();
            }
            QName partQName = new QName(uri, localName);
            if (mLog.isLoggable(Level.FINEST)) {
                mLog.log(Level.FINEST, lookingMsg);
            }
            if ((e = this.findMsgElement((Element)msgElem, partQName)) != null) {
                if (isType) {
                    Map partNSs = WrapperUtil.extractNamespaceDeclarations((Element)e);
                    if (mLog.isLoggable(Level.FINE)) {
                        DebugLog.debugLog(mLog, Level.FINE, "Part  '" + localName + "' namespaces", partNSs);
                    }
                    if (partNSs != null) {
                        partNameSpaces.putAll(partNSs);
                    }
                }
                if (mLog.isLoggable(Level.FINEST)) {
                    mLog.log(Level.FINEST, creatingMsg);
                }
                if (TYPE_DOC) {
                    wrapperBuilder.addPart(part.getName(), e.getChildNodes(), partNameSpaces);
                    continue;
                }
                if (TYPE_RPC) {
                    wrapperBuilder.addPart(part.getName(), e.getChildNodes(), partNameSpaces);
                    continue;
                }
                if (ELEM_DOC) {
                    wrapperBuilder.addPart(part.getName(), e, partNameSpaces);
                    continue;
                }
                if (!ELEM_RPC) continue;
                wrapperBuilder.addPart(part.getName(), e, partNameSpaces);
                continue;
            }
            throw new WrapperProcessingException(mMessages.getString(nullMsg, (Object)partQName.toString()));
        }
    }

    private void processSoapHeader(WrapperBuilder wrapperBuilder, NormalizedMessage normalMsg, SOAPHeader soapHeader, OperationMetaData meta, boolean inMsg, MessageExchange mex) throws WrapperProcessingException {
        Iterator headerIter;
        List headerList = null;
        headerList = inMsg ? meta.getInputSoapHeaders() : meta.getOutputSoapHeaders();
        if (soapHeader != null) {
            headerIter = soapHeader.examineAllHeaderElements();
            while (headerIter.hasNext()) {
                SOAPHeaderElement he = (SOAPHeaderElement)headerIter.next();
                if (he.getLocalName().equals(WSRM_Sequence) && (he.getNamespaceURI().equals(WSRM__1_0__NAMESPACE_URI) || he.getNamespaceURI().equals(WSRM__1_1__NAMESPACE_URI))) {
                    this.propagateWSRMIdsToExchange(he, mex);
                }
                if (!he.getLocalName().equals(CUSTOM_RELIABILITY_HEADER_LOCAL_NAME) || !CUSTOM_RELIABILITY_HEADER_NAMESPACE_URI.equals(he.getNamespaceURI())) continue;
                String messageID = he.getTextContent();
                normalMsg.setProperty(CUSTOM_RELIABILITY_MESSAGE_ID_PROPERTY, (Object)messageID);
                if (!mLog.isLoggable(Level.FINEST)) continue;
                mLog.log(Level.FINEST, "Normalized Message ID set to: " + messageID);
            }
        }
        if (this.mIsHeaderCopyEnabled && soapHeader != null && (headerList == null || headerList.size() < 1)) {
            headerIter = soapHeader.examineAllHeaderElements();
            while (headerIter.hasNext()) {
                this.addSOAPHeader(normalMsg, (SOAPHeaderElement)headerIter.next());
            }
            return;
        }
        Message wsMessage = null;
        wsMessage = inMsg ? meta.getInputMessage() : meta.getOutputMessage();
        if (soapHeader != null) {
            Map nameSpaces = WrapperUtil.extractNamespaceDeclarations((Element)soapHeader);
            if (mLog.isLoggable(Level.FINE)) {
                DebugLog.debugLog(mLog, Level.FINE, "SOAP header namespaces", nameSpaces);
            }
            Iterator headerIter2 = soapHeader.examineAllHeaderElements();
            while (headerIter2.hasNext()) {
                SOAPHeaderElement elem = (SOAPHeaderElement)headerIter2.next();
                boolean headerProcessed = false;
                for (int i = 0; i < headerList.size() && !headerProcessed; ++i) {
                    javax.wsdl.extensions.soap.SOAPHeader headerDef = (javax.wsdl.extensions.soap.SOAPHeader)headerList.get(i);
                    if (!headerDef.getMessage().equals(wsMessage.getQName())) continue;
                    Part part = wsMessage.getPart(headerDef.getPart());
                    if (part == null) {
                        String msg = mMessages.getString("HTTPBC-W00714.Unsupported_feature_part_in_header_not_in_message", new Object[]{headerDef.getPart(), wsMessage.getQName()});
                        throw new IllegalArgumentException(msg);
                    }
                    QName partElemName = part.getElementName();
                    if (partElemName == null) {
                        String msg = mMessages.getString("HTTPBC-W00715.Unsupported_feature_part_in_header_not_element", new Object[]{headerDef.getPart(), wsMessage.getQName()});
                        throw new IllegalArgumentException(msg);
                    }
                    if (!partElemName.equals(elem.getElementQName())) continue;
                    HashMap partNameSpaces = nameSpaces != null ? new HashMap(nameSpaces) : new HashMap();
                    wrapperBuilder.addPart(part.getName(), (Element)elem, partNameSpaces);
                    headerProcessed = true;
                }
                if (!this.mIsHeaderCopyEnabled || headerProcessed) continue;
                this.addSOAPHeader(normalMsg, elem);
            }
        }
    }

    private void addSOAPHeader(NormalizedMessage msg, SOAPHeaderElement elem) throws WrapperProcessingException {
        HashMap<String, DocumentFragment> propertyMap = (HashMap<String, DocumentFragment>)msg.getProperty(SOAP_HEADERS_PROPERTY);
        if (propertyMap == null) {
            propertyMap = new HashMap<String, DocumentFragment>();
            msg.setProperty(SOAP_HEADERS_PROPERTY, propertyMap);
        }
        DocumentBuilder docBuilder = null;
        Document document = null;
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilder = docBuilderFactory.newDocumentBuilder();
            document = docBuilder.newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new WrapperProcessingException(mMessages.getString("HTTPBC-E00809_Failed_to_create_document_builder"), (Throwable)e);
        }
        QName name = elem.getElementQName();
        DocumentFragment documentFragment = document.createDocumentFragment();
        documentFragment.getOwnerDocument().importNode((Node)elem, true);
        documentFragment.appendChild((Node)elem);
        propertyMap.put(name.toString(), documentFragment);
    }

    private Element findResponsePart(Element soapElement, QName operationQName, boolean inMsg) throws Exception {
        Element e = null;
        if (!inMsg) {
            e = this.findMsgElement(soapElement, new QName(operationQName.getNamespaceURI(), operationQName.getLocalPart() + "Response"));
        }
        if (e == null) {
            e = this.findMsgElement(soapElement, operationQName);
        }
        return e;
    }

    private Element findMsgElement(Element root, QName elemQName) throws Exception {
        if (mLog.isLoggable(Level.FINER)) {
            mLog.log(Level.FINER, "Finding part for root", elemQName.toString());
            DebugLog.debugLog(mLog, Level.FINER, "", root);
        }
        boolean ignoreNS = elemQName.getNamespaceURI().equals("*");
        NodeList nl = root.getChildNodes();
        int nodeLen = nl.getLength();
        if (mLog.isLoggable(Level.FINEST)) {
            mLog.log(Level.FINEST, "Found " + nl.getLength() + " nodes");
        }
        if (nl != null && nl.getLength() > 0) {
            for (int i = 0; i < nodeLen; ++i) {
                String e2NS;
                Node obj = nl.item(i);
                if (!(obj instanceof Element)) continue;
                Element e2 = (Element)obj;
                if (mLog.isLoggable(Level.FINEST)) {
                    mLog.log(Level.FINEST, "Looking for element namespace [" + e2.getNamespaceURI() + "] localname [" + e2.getLocalName() + "]");
                }
                if (!e2.getLocalName().equals(elemQName.getLocalPart())) continue;
                String string = e2NS = e2.getNamespaceURI() == null ? "" : e2.getNamespaceURI();
                if (!ignoreNS && !e2NS.equals(elemQName.getNamespaceURI())) continue;
                if (mLog.isLoggable(Level.FINER)) {
                    mLog.log(Level.FINEST, "Found element with namespace [" + e2.getNamespaceURI() + "] localname [" + e2.getLocalName() + "]");
                    DebugLog.debugLog(mLog, Level.FINER, "Returning element", e2);
                }
                return e2;
            }
        }
        return null;
    }

    private void propagateWSRMIdsToExchange(SOAPHeaderElement wsrmSequenceElem, MessageExchange mex) {
        block8: {
            String sequenceMessageNumber;
            SOAPElement messageNumberElem;
            String sequenceIdentifier;
            SOAPElement identifierElem;
            boolean sequenceIdentifierFound = false;
            Iterator identifierIter = wsrmSequenceElem.getChildElements(QNAME_WSRM__1_0__Sequence_Identifier);
            if (identifierIter.hasNext()) {
                identifierElem = (SOAPElement)identifierIter.next();
                sequenceIdentifier = identifierElem.getValue();
                mex.setProperty(CRMP_GROUP_ID, (Object)sequenceIdentifier);
                sequenceIdentifierFound = true;
                if (mLog.isLoggable(Level.FINE)) {
                    mLog.log(Level.FINE, "The soap message is ws-rm 1.0 enabled message; populated com.sun.jbi.messaging.groupid with value [" + sequenceIdentifier + "] for message exchange with ID [" + mex.getExchangeId() + "]");
                }
            }
            if (!sequenceIdentifierFound) {
                identifierIter = wsrmSequenceElem.getChildElements(QNAME_WSRM__1_1__Sequence_Identifier);
                if (identifierIter.hasNext()) {
                    identifierElem = (SOAPElement)identifierIter.next();
                    sequenceIdentifier = identifierElem.getValue();
                    mex.setProperty(CRMP_GROUP_ID, (Object)sequenceIdentifier);
                    sequenceIdentifierFound = true;
                    if (mLog.isLoggable(Level.FINE)) {
                        mLog.log(Level.FINE, "The soap message is ws-rm 1.1 enabled message; populated com.sun.jbi.messaging.groupid with value [" + sequenceIdentifier + "] for message exchange with ID [" + mex.getExchangeId() + "]");
                    }
                }
            }
            boolean sequenceMessageNumberFound = false;
            Iterator messageNumberIter = wsrmSequenceElem.getChildElements(QNAME_WSRM__1_0__Sequence_MessageNumber);
            if (messageNumberIter.hasNext()) {
                messageNumberElem = (SOAPElement)messageNumberIter.next();
                sequenceMessageNumber = messageNumberElem.getValue();
                mex.setProperty(CRMP_MESSAGE_ID, (Object)sequenceMessageNumber);
                sequenceMessageNumberFound = true;
                if (mLog.isLoggable(Level.FINE)) {
                    mLog.log(Level.FINE, "The soap message is ws-rm 1.0 enabled message; populated com.sun.jbi.messaging.messageid with value [" + sequenceMessageNumber + "] for message exchange with ID [" + mex.getExchangeId() + "]");
                }
            }
            if (sequenceMessageNumberFound || !(messageNumberIter = wsrmSequenceElem.getChildElements(QNAME_WSRM__1_1__Sequence_MessageNumber)).hasNext()) break block8;
            messageNumberElem = (SOAPElement)messageNumberIter.next();
            sequenceMessageNumber = messageNumberElem.getValue();
            mex.setProperty(CRMP_MESSAGE_ID, (Object)sequenceMessageNumber);
            sequenceMessageNumberFound = true;
            if (mLog.isLoggable(Level.FINE)) {
                mLog.log(Level.FINE, "The soap message is ws-rm 1.1 enabled message; populated com.sun.jbi.messaging.messageid with value [" + sequenceMessageNumber + "] for message exchange with ID [" + mex.getExchangeId() + "]");
            }
        }
    }

    private void copyNode(Node src, Node dest) {
        NodeList nl = src.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            n = dest.getOwnerDocument().importNode(n, true);
            dest.appendChild(n);
        }
        NamedNodeMap attrs = src.getAttributes();
        NamedNodeMap destAttrs = dest.getAttributes();
        if (attrs != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                Node attr = attrs.item(i);
                Node n = dest.getOwnerDocument().importNode(attr, true);
                if (destAttrs == null) continue;
                destAttrs.setNamedItemNS(n);
            }
        }
    }

    private void processHTTPRequestHeaders(NormalizedMessage normalMsg, MessageContext context) {
        HashMap<String, String> httpHeadersProperty = (HashMap<String, String>)normalMsg.getProperty(HTTP_HEADERS_PROPERTY);
        if (httpHeadersProperty == null) {
            httpHeadersProperty = new HashMap<String, String>();
            normalMsg.setProperty(HTTP_HEADERS_PROPERTY, httpHeadersProperty);
        }
        Map requestHeaders = (Map)context.get((Object)"javax.xml.ws.http.request.headers");
        for (Map.Entry entry : requestHeaders.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)((List)entry.getValue()).get(0);
            httpHeadersProperty.put(key, value);
        }
    }
}

