/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc;

import com.sun.jbi.httpsoapbc.AbstractEndpoint;
import com.sun.jbi.httpsoapbc.Endpoint;
import com.sun.jbi.httpsoapbc.HttpEndpoint;
import com.sun.jbi.httpsoapbc.HttpSoapEndpoint;
import com.sun.jbi.httpsoapbc.security.api.EndpointSecurityConfig;
import com.sun.jbi.httpsoapbc.security.impl.CredentialValidatorManager;
import com.sun.jbi.internationalization.Messages;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.http.HTTPAddress;
import javax.wsdl.extensions.http.HTTPBinding;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.xml.namespace.QName;

public class EndpointFactory {
    private static final Messages mMessages = Messages.getMessages(EndpointFactory.class);

    public static Endpoint createEndpoint(Definition def, QName serviceName, String endpointName, QName interfaceName, boolean isProvider, String wsdlPath, EndpointSecurityConfig securityConfig, String serviceUnitID, String serviceUnitRootPath, CredentialValidatorManager cvm) throws Exception {
        AbstractEndpoint bcEndpoint = null;
        Port matchedPort = EndpointFactory.getPort(def, serviceName.toString(), endpointName);
        if (matchedPort != null) {
            Binding matchedBinding = matchedPort.getBinding();
            if (EndpointFactory.hasSOAPBinding(matchedBinding)) {
                bcEndpoint = new HttpSoapEndpoint(def, serviceName, endpointName, interfaceName, isProvider, wsdlPath, securityConfig, serviceUnitID, serviceUnitRootPath, cvm);
            }
            if (EndpointFactory.hasHTTPBinding(matchedBinding)) {
                bcEndpoint = new HttpEndpoint(def, serviceName, endpointName, interfaceName, isProvider, wsdlPath, securityConfig, serviceUnitID, serviceUnitRootPath, cvm);
            }
        }
        return bcEndpoint;
    }

    private static boolean hasSOAPBinding(Binding binding) throws Exception {
        boolean hasSoapBinding = false;
        if (binding != null) {
            Iterator extIter;
            List extElems = binding.getExtensibilityElements();
            Iterator iterator = extIter = extElems == null ? null : extElems.iterator();
            while (extIter != null && extIter.hasNext()) {
                ExtensibilityElement ee = (ExtensibilityElement)extIter.next();
                if (!SOAPBinding.class.isInstance(ee)) continue;
                if (hasSoapBinding) {
                    throw new Exception(mMessages.getString("HttpSoapBindingDeployer.Multiple_Soap_binding_elements"));
                }
                hasSoapBinding = true;
            }
        }
        return hasSoapBinding;
    }

    private static boolean hasHTTPBinding(Binding binding) throws Exception {
        boolean hasHttpBinding = false;
        if (binding != null) {
            Iterator extIter;
            List extElems = binding.getExtensibilityElements();
            Iterator iterator = extIter = extElems == null ? null : extElems.iterator();
            while (extIter != null && extIter.hasNext()) {
                ExtensibilityElement ee = (ExtensibilityElement)extIter.next();
                if (!HTTPBinding.class.isInstance(ee)) continue;
                if (hasHttpBinding) {
                    throw new Exception(mMessages.getString("HttpSoapBindingDeployer.Multiple_Http_binding_elements"));
                }
                hasHttpBinding = true;
            }
        }
        return hasHttpBinding;
    }

    private static Port getPort(Definition def, String serviceName, String endpointName) {
        Port port = null;
        Map services = def.getServices();
        Service svc = (Service)services.get(QName.valueOf(serviceName));
        if (svc == null) {
            return null;
        }
        port = svc.getPort(QName.valueOf(endpointName).getLocalPart());
        if (port != null) {
            for (ExtensibilityElement element : port.getExtensibilityElements()) {
                SOAPAddress addr;
                String location;
                if (!(element instanceof SOAPAddress ? !(location = (addr = (SOAPAddress)element).getLocationURI()).equals("REPLACE_WITH_ACTUAL_URL") : element instanceof HTTPAddress)) continue;
                return port;
            }
        }
        return null;
    }
}

