/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc.security.http.impl;

import com.sun.jbi.httpsoapbc.Endpoint;
import com.sun.jbi.httpsoapbc.security.api.EndpointSecurityConfig;
import com.sun.jbi.httpsoapbc.security.api.EndpointSecurityManager;
import com.sun.jbi.httpsoapbc.security.api.HTTPBasicAuthCredential;
import com.sun.jbi.httpsoapbc.security.auth.HttpAuthenticator;
import com.sun.jbi.httpsoapbc.security.impl.EndpointSecurityManagerImpl;
import com.sun.jbi.internationalization.Messages;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BasicAuthenticator {
    private static final Logger mLog = Messages.getLogger(BasicAuthenticator.class);
    private static Map<Endpoint, HTTPBasicAuthCredential> epCredentialMap = new HashMap<Endpoint, HTTPBasicAuthCredential>();
    private static EndpointSecurityManager securityManager;

    public BasicAuthenticator() {
        securityManager = new EndpointSecurityManagerImpl();
    }

    public static void registerEndPointCredentials(Endpoint ep, HTTPBasicAuthCredential cred) {
        if (!epCredentialMap.containsKey(ep)) {
            epCredentialMap.put(ep, cred);
        }
    }

    public static void unregisterEndPointCredentials(Endpoint ep, HTTPBasicAuthCredential credentials) {
        if (epCredentialMap.containsKey(ep)) {
            epCredentialMap.remove(ep);
        }
    }

    public void register() {
        HttpAuthenticator.registerBasicAuthenticator(this);
        if (mLog.isLoggable(Level.FINE)) {
            mLog.log(Level.FINE, "BasicAuthenticator registered");
        }
    }

    public void unregister() {
        HttpAuthenticator.unregisterBasicAuthenticator();
        if (mLog.isLoggable(Level.FINE)) {
            mLog.log(Level.FINE, "BasicAuthenticator unregistered");
        }
    }

    public static void initializeEndPointSecurityManager(EndpointSecurityConfig securityConfig) {
        if (!securityManager.isInitialized()) {
            securityManager.initialize(securityConfig);
        }
    }

    public HTTPBasicAuthCredential getCredentialsForEndpointURI(URL url) {
        Set<Endpoint> eps = epCredentialMap.keySet();
        for (Endpoint ep : eps) {
            if (!ep.getEndpointUrl().equals(url)) continue;
            return epCredentialMap.get(ep);
        }
        return null;
    }

    public static EndpointSecurityManager getEndpointSecurityManager() {
        return securityManager;
    }
}

