/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.configuration;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConfigPersistence {
    public static final String PERSISTENT_CONFIG_FILE_EXT = ".properties";
    public static final String PERSISTENT_CONFIG_FILE_NAME = "config.properties";
    public static final String INSTALLATION_CONFIGURATION_EXTENSION_ELEMENT = "Configuration";
    private static final Logger mLogger = Logger.getLogger(ConfigPersistence.class.getName());

    public static Properties parseDefaultConfig(DocumentFragment jbiConfigurationExtension) throws JBIException {
        Properties defaultConfig;
        block8: {
            defaultConfig = new Properties();
            try {
                if (jbiConfigurationExtension == null) break block8;
                NodeList nodes = jbiConfigurationExtension.getChildNodes();
                for (int nodeCount = 0; nodeCount < nodes.getLength(); ++nodeCount) {
                    Node aNode = nodes.item(nodeCount);
                    if (aNode != null && aNode.getNodeType() == 1) {
                        int colonPos;
                        String qualifiedName;
                        String elementName = qualifiedName = aNode.getNodeName();
                        if (qualifiedName != null && (colonPos = qualifiedName.indexOf(58)) > -1) {
                            elementName = qualifiedName.substring(colonPos + 1);
                        }
                        if (elementName == null || !elementName.equals(INSTALLATION_CONFIGURATION_EXTENSION_ELEMENT)) continue;
                        mLogger.config("Default configuration located in installation extension.");
                        NodeList elemChildren = aNode.getChildNodes();
                        for (int elemChildCount = 0; elemChildCount < elemChildren.getLength(); ++elemChildCount) {
                            int propColonPos;
                            Node elemChild = elemChildren.item(elemChildCount);
                            if (elemChild.getNodeType() != 1) continue;
                            String propNodeName = elemChild.getNodeName();
                            if (propNodeName != null && (propColonPos = propNodeName.indexOf(58)) > -1) {
                                propNodeName = propNodeName.substring(propColonPos + 1);
                            }
                            String textVal = elemChild.getTextContent();
                            if (mLogger.isLoggable(Level.CONFIG)) {
                                mLogger.config("Configuration default for property " + propNodeName + " set to: " + textVal);
                            }
                            defaultConfig.setProperty(propNodeName, textVal);
                        }
                        continue;
                    }
                    mLogger.config("No installation extension details defined.");
                }
            }
            catch (Exception ex) {
                throw new JBIException("Could not get the default configuration from the jbi descriptor: " + ex.getMessage(), (Throwable)ex);
            }
        }
        return defaultConfig;
    }

    public static void persistInitialConfig(MBeanServer mbServer, ObjectName installerExtName, String workspaceRoot, Properties defaultConfig) throws JBIException {
        Properties persistentConfig = defaultConfig;
        if (persistentConfig == null) {
            persistentConfig = new Properties();
        }
        try {
            MBeanInfo mbInfo = mbServer.getMBeanInfo(installerExtName);
            MBeanAttributeInfo[] attrs = mbInfo.getAttributes();
            for (int attrCount = 0; attrCount < attrs.length; ++attrCount) {
                String attributeName = attrs[attrCount].getName();
                Object attr = mbServer.getAttribute(installerExtName, attributeName);
                if (attr == null) continue;
                persistentConfig.setProperty(attributeName, attr.toString());
                if (!mLogger.isLoggable(Level.CONFIG)) continue;
                mLogger.config("Override default for " + attributeName + ": " + attr.toString());
            }
            ConfigPersistence.persistConfig(workspaceRoot, persistentConfig);
        }
        catch (JMException ex) {
            throw new JBIException("Could not retrieve configuration settings from MBean " + installerExtName + ": " + ex.getMessage(), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void persistConfig(String workspaceRoot, Properties persistentConfig) throws JBIException {
        File persistentConfigName = new File(workspaceRoot, PERSISTENT_CONFIG_FILE_NAME);
        try {
            Class<ConfigPersistence> clazz = ConfigPersistence.class;
            synchronized (ConfigPersistence.class) {
                FileOutputStream os = new FileOutputStream(persistentConfigName);
                persistentConfig.store(os, null);
                ((OutputStream)os).close();
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        }
        catch (IOException ex) {
            throw new JBIException("Could not store configuration settings to file " + persistentConfigName + ": " + ex.getMessage(), (Throwable)ex);
        }
        {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadConfig(String workspaceRoot) throws JBIException {
        Properties persistentConfig = new Properties();
        File persistentConfigName = new File(workspaceRoot, PERSISTENT_CONFIG_FILE_NAME);
        try {
            Class<ConfigPersistence> clazz = ConfigPersistence.class;
            synchronized (ConfigPersistence.class) {
                FileInputStream is = new FileInputStream(persistentConfigName);
                persistentConfig.load(is);
                ((InputStream)is).close();
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        }
        catch (IOException ex) {
            throw new JBIException("Failed to load configuration " + persistentConfigName + " : " + ex.getMessage(), (Throwable)ex);
        }
        {
            return persistentConfig;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadInstanceConfig(String workspaceRoot, String serviceUnitID) throws JBIException {
        Properties persistentConfig = new Properties();
        File persistentConfigName = new File(workspaceRoot, serviceUnitID + PERSISTENT_CONFIG_FILE_EXT);
        if (persistentConfigName.exists()) {
            try {
                Class<ConfigPersistence> clazz = ConfigPersistence.class;
                synchronized (ConfigPersistence.class) {
                    FileInputStream is = new FileInputStream(persistentConfigName);
                    persistentConfig.load(is);
                    ((InputStream)is).close();
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                }
            }
            catch (IOException ex) {
                throw new JBIException("Failed to load instance configuration " + persistentConfigName + " : " + ex.getMessage(), (Throwable)ex);
            }
        }
        {
            return persistentConfig;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void persistInstanceConfig(String workspaceRoot, Properties persistentConfig, String serviceUnitID) throws JBIException {
        File persistentConfigName = new File(workspaceRoot, serviceUnitID + PERSISTENT_CONFIG_FILE_EXT);
        try {
            Class<ConfigPersistence> clazz = ConfigPersistence.class;
            synchronized (ConfigPersistence.class) {
                FileOutputStream os = new FileOutputStream(persistentConfigName);
                persistentConfig.store(os, null);
                ((OutputStream)os).close();
                // ** MonitorExit[var4_4] (shouldn't be in output)
            }
        }
        catch (IOException ex) {
            throw new JBIException("Could not store configuration settings to file " + persistentConfigName + ": " + ex.getMessage(), (Throwable)ex);
        }
        {
            return;
        }
    }

    public static void deleteInstanceConfig(String workspaceRoot, String serviceUnitID) {
        boolean deleted;
        File persistentConfigName = new File(workspaceRoot, serviceUnitID + PERSISTENT_CONFIG_FILE_EXT);
        if (persistentConfigName.exists() && !(deleted = persistentConfigName.delete())) {
            mLogger.warning("failed to remove service unit configuration - " + persistentConfigName.getAbsolutePath());
        }
    }
}

