/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc;

import com.sun.jbi.internationalization.Messages;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.activation.DataSource;
import javax.xml.namespace.QName;

class StringDataSourceImpl
implements DataSource {
    private static Messages mMessages = Messages.getMessages(StringDataSourceImpl.class);
    private final String mData;
    private final QName mName;

    public StringDataSourceImpl(QName name, String data) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.mData = data;
        this.mName = name;
    }

    public String getContentType() {
        return "text/plain";
    }

    public InputStream getInputStream() throws UnsupportedEncodingException {
        return new ByteArrayInputStream(this.mData.getBytes("UTF-8"));
    }

    public String getName() {
        return this.mName.toString();
    }

    public OutputStream getOutputStream() throws IOException {
        throw new IOException("This DataSource implementation is read-only; output stream not supported.");
    }
}

