/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.nms.wsdl11wrapper.impl;

import com.sun.jbi.nms.wsdl11wrapper.HelperFactory;
import com.sun.jbi.nms.wsdl11wrapper.WrapperBuilder;
import com.sun.jbi.nms.wsdl11wrapper.WrapperProcessingException;
import com.sun.jbi.nms.wsdl11wrapper.impl.NodeListImpl;
import com.sun.jbi.nms.wsdl11wrapper.impl.WSDLInfo;
import com.sun.jbi.nms.wsdl11wrapper.util.WrappedDocument;
import com.sun.jbi.nms.wsdl11wrapper.util.WrapperUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WrapperBuilderImpl
implements WrapperBuilder {
    DocumentBuilder mBuilder;
    Document normalDoc;
    Element jbiMessageWrapper;
    WSDLInfo info;
    String operationMessageName;
    boolean isResultPrepared;
    Map mPartNameToPartNodes;
    private Map<String, Map> mNamespaceMap;
    private Map<String, String> mGlobalNamespaces;

    public void initialize(Document docToPopulate, Message wsdlMessageDefinition, String operationBindingMessageName) throws WrapperProcessingException {
        this.isResultPrepared = false;
        this.mPartNameToPartNodes = null;
        this.operationMessageName = operationBindingMessageName;
        this.normalDoc = docToPopulate;
        if (docToPopulate == null) {
            try {
                this.normalDoc = this.newDocument();
            }
            catch (ParserConfigurationException ex) {
                throw new WrapperProcessingException("Failed to create an empty target document for building the wrapped normalized message: " + ex.getMessage(), ex);
            }
        }
        this.info = WSDLInfo.getInstance(wsdlMessageDefinition);
        Document currDoc = this.normalDoc;
        this.jbiMessageWrapper = WrapperUtil.createJBIMessageWrapper(currDoc, this.info.getMessageType(), operationBindingMessageName);
        currDoc.appendChild(this.jbiMessageWrapper);
    }

    public void initialize(Message wsdlMessageDefinition, String operationBindingMessageName) throws WrapperProcessingException {
        this.isResultPrepared = false;
        this.mPartNameToPartNodes = null;
        this.operationMessageName = operationBindingMessageName;
        this.info = WSDLInfo.getInstance(wsdlMessageDefinition);
    }

    public void declareGlobalNS(Map namespaceMap) {
        if (this.jbiMessageWrapper != null && namespaceMap != null) {
            this.copyNamespaces(this.jbiMessageWrapper, namespaceMap);
        } else if (namespaceMap != null) {
            this.mGlobalNamespaces = new HashMap<String, String>();
            this.mGlobalNamespaces.putAll(namespaceMap);
        }
    }

    public void addPart(String partName, NodeList partNodes) throws WrapperProcessingException {
        this.addPart(partName, partNodes, null);
    }

    public void addPart(String partName, Element partNode) throws WrapperProcessingException {
        this.addPart(partName, new NodeListImpl(partNode), null);
    }

    public void addParts(Map partNameToPartNodes) throws WrapperProcessingException {
        this.addParts(partNameToPartNodes, null);
    }

    public void addPart(String partName, Element partNode, Map namespaceMap) throws WrapperProcessingException {
        this.addPart(partName, new NodeListImpl(partNode), namespaceMap);
    }

    public void addPart(String partName, NodeList partNodes, Map namespaceMap) throws WrapperProcessingException {
        List partsOrder;
        int partPos;
        if (this.jbiMessageWrapper == null) {
            if (partNodes.getLength() > 0) {
                Document doc = partNodes.item(0).getOwnerDocument();
                this.jbiMessageWrapper = WrapperUtil.createJBIMessageWrapper(doc, this.info.getMessageType(), this.operationMessageName);
            } else {
                throw new WrapperProcessingException("Invalid zero-length data for part: " + partName);
            }
        }
        if ((partPos = (partsOrder = this.info.getPartsOrder()).indexOf(partName)) > -1) {
            if (this.mPartNameToPartNodes == null) {
                this.mPartNameToPartNodes = new HashMap();
                this.mNamespaceMap = new HashMap<String, Map>();
            }
            this.mPartNameToPartNodes.put(partName, partNodes);
            if (namespaceMap != null) {
                this.mNamespaceMap.put(partName, new HashMap(namespaceMap));
            }
        } else {
            throw new WrapperProcessingException("Unknown part " + partName + " is not defined in the WSDL message definition for " + this.info.getMessageType() + ". Cannot add part to normalized message.");
        }
    }

    public void addParts(Map partNameToPartNodes, Map namespaceMap) throws WrapperProcessingException {
        this.mPartNameToPartNodes = partNameToPartNodes;
        this.mNamespaceMap = new HashMap<String, Map>();
        if (namespaceMap != null) {
            for (String part : partNameToPartNodes.keySet()) {
                this.mNamespaceMap.put(part, new HashMap(namespaceMap));
            }
        }
    }

    protected void copyNamespaces(Element elem, Map namespaces) {
        if (elem == null || namespaces == null) {
            return;
        }
        Set keys = namespaces.keySet();
        for (String prefix : keys) {
            elem.setAttributeNS("http://www.w3.org/2000/xmlns/", prefix.startsWith("xmlns:") ? prefix : "xmlns:" + prefix, (String)namespaces.get(prefix));
        }
    }

    public Document getResult() throws WrapperProcessingException {
        if (!this.isResultPrepared) {
            if (this.mGlobalNamespaces != null) {
                this.copyNamespaces(this.jbiMessageWrapper, this.mGlobalNamespaces);
            }
            for (Part aPart : this.info.getOrderedMessageParts()) {
                String partName = aPart.getName();
                NodeList nodes = null;
                if (this.mPartNameToPartNodes != null) {
                    Object payload = this.mPartNameToPartNodes.get(partName);
                    nodes = payload instanceof NodeList ? (NodeList)payload : new NodeListImpl();
                }
                Element currJBIMessageWrapper = this.jbiMessageWrapper;
                Element wrapperElem = WrapperUtil.importJBIWrappedPart(currJBIMessageWrapper.getOwnerDocument(), nodes);
                Map nsMap = this.mNamespaceMap.get(partName);
                if (nsMap != null) {
                    this.copyNamespaces(wrapperElem, nsMap);
                }
                currJBIMessageWrapper.appendChild(wrapperElem);
            }
            if (this.jbiMessageWrapper == null) {
                if (this.info == null || this.info.getMessageType() == null) {
                    throw new WrapperProcessingException("initialize() must be called on the WrapperBuilder instance first to set up the WSDL info to normalize the message");
                }
                Document doc = null;
                try {
                    doc = this.newDocument();
                }
                catch (ParserConfigurationException e) {
                    throw new WrapperProcessingException("Failed to create an empty target document for building the wrapped normalized message: " + e.getMessage(), e);
                }
                this.jbiMessageWrapper = WrapperUtil.createJBIMessageWrapper(doc, this.info.getMessageType(), this.operationMessageName);
                this.normalDoc = doc;
                this.normalDoc.appendChild(this.jbiMessageWrapper);
            } else {
                Document origDoc = this.jbiMessageWrapper.getOwnerDocument();
                origDoc.removeChild(origDoc.getDocumentElement());
                origDoc.appendChild(this.jbiMessageWrapper);
                if (this.normalDoc == null) {
                    this.normalDoc = new WrappedDocument(origDoc, this.jbiMessageWrapper);
                }
            }
            this.isResultPrepared = true;
            this.mPartNameToPartNodes = null;
        }
        return this.normalDoc;
    }

    public Message getStatusMessage() throws WrapperProcessingException {
        Message msg = null;
        try {
            WSDLFactory factory = WSDLFactory.newInstance();
            Definition def = factory.newDefinition();
            msg = def.createMessage();
            msg.setQName(new QName("Status"));
            Part part = def.createPart();
            part.setName("Result");
            msg.addPart(part);
        }
        catch (WSDLException ex) {
            throw new WrapperProcessingException(ex);
        }
        return msg;
    }

    public Document getStatusDocument(String statusMessage) throws WrapperProcessingException {
        Document res = null;
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            WrapperBuilder builder = HelperFactory.createBuilder();
            builder.initialize(doc, this.getStatusMessage(), null);
            Element statusElem = doc.createElement("Status");
            statusElem.appendChild(doc.createTextNode(statusMessage));
            builder.addPart("Result", statusElem);
            res = builder.getResult();
        }
        catch (ParserConfigurationException ex) {
            throw new WrapperProcessingException(ex);
        }
        return res;
    }

    private Document newDocument() throws ParserConfigurationException {
        if (this.mBuilder == null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            this.mBuilder = factory.newDocumentBuilder();
        }
        return this.mBuilder.newDocument();
    }
}

